/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class LootableEntityRegistry {
    private static final Map<Class<? extends Entity>, List<ItemStack>> entityLoot = new HashMap<Class<? extends Entity>, List<ItemStack>>();
    private static final Map<Class<? extends Entity>, Float> lootChance = new HashMap<Class<? extends Entity>, Float>();
    private static final Random rand = new Random();

    public static boolean addLootableEntity(Class<? extends Entity> entity, float chance, ItemStack ... loot) {
        return LootableEntityRegistry.addLootableEntity(entity, chance, Arrays.asList(loot));
    }

    public static boolean addLootableEntity(Class<? extends Entity> entity, float chance, List<ItemStack> loot) {
        if (entityLoot.containsKey(entity)) {
            return false;
        }
        entityLoot.put(entity, loot);
        lootChance.put(entity, Float.valueOf(chance));
        return true;
    }

    public static ItemStack getEntityLoot(Class<? extends Entity> entity) {
        List<ItemStack> loot = entityLoot.get(entity);
        if (loot != null && loot.size() > 0) {
            ItemStack stack = loot.get(rand.nextInt(loot.size()));
            return stack == null ? null : stack.func_77946_l();
        }
        return null;
    }

    public static float getEntityLootChance(Class<? extends Entity> entity) {
        return lootChance.containsKey(entity) ? lootChance.get(entity).floatValue() : 0.0f;
    }
}

