/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.util.MathHelper;
import zeldaswordskills.api.entity.ai.EntityAIDynamicAction;
import zeldaswordskills.api.entity.ai.EntityAction;

public class EntityAIDynamicRangedAction
extends EntityAIDynamicAction {
    protected final float range;
    protected final float minRangeSq;
    protected final int minDelay;
    protected final int maxDelay;
    protected final float speed;
    protected int visibilityTimer;
    protected int delay;
    protected int timer;
    protected boolean difficultScaled;

    public <T extends EntityCreature> EntityAIDynamicRangedAction(T entity, EntityAction action, float rangeMin, float rangeMax, int minDelay, int maxDelay, float speed, boolean require_ground) {
        this(entity, action, rangeMin, rangeMax, minDelay, maxDelay, speed, require_ground, true);
    }

    public <T extends EntityCreature> EntityAIDynamicRangedAction(T entity, EntityAction action, float rangeMin, float rangeMax, int minDelay, int maxDelay, float speed, boolean require_ground, boolean require_sight) {
        super(entity, action, rangeMax, require_ground, require_sight);
        this.range = rangeMax;
        this.minRangeSq = rangeMin * rangeMin;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.speed = speed;
    }

    public EntityAIDynamicRangedAction setDifficultyScaled() {
        this.difficultScaled = true;
        return this;
    }

    @Override
    protected boolean checkRange() {
        double distance = this.entity.func_70068_e(this.target);
        return distance > (double)this.minRangeSq && distance <= (double)this.rangeSq;
    }

    @Override
    protected boolean canPerformAction() {
        if (this.target == null || !this.target.func_70089_S()) {
            return false;
        }
        if (this.require_ground && !this.entity.field_70122_E) {
            return false;
        }
        return !this.require_sight || this.entity.func_70635_at().func_75522_a(this.target);
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() || !this.entity.func_70661_as().func_75500_f();
    }

    @Override
    public boolean func_75250_a() {
        if (super.func_75250_a()) {
            if (this.target == null) {
                return true;
            }
            if (this.delay == 0) {
                float f = this.entity.func_70032_d(this.target) / this.range;
                float scale = this.difficultScaled ? 2.0f - 0.5f * (float)this.entity.field_70170_p.field_73013_u.func_151525_a() : 1.0f;
                this.delay = MathHelper.func_76141_d((float)(f * scale * (float)(this.maxDelay - this.minDelay)));
                this.delay += this.minDelay - this.entity.field_70170_p.field_73012_v.nextInt(Math.max(1, this.minDelay));
            }
            return this.timer++ > this.delay;
        }
        if (this.target != null) {
            this.moveIntoPosition();
        }
        return false;
    }

    protected boolean moveIntoPosition() {
        double distance = this.entity.func_70092_e(this.target.field_70165_t, this.target.field_70121_D.field_72338_b, this.target.field_70161_v);
        boolean flag = this.entity.func_70635_at().func_75522_a(this.target);
        this.visibilityTimer = flag ? ++this.visibilityTimer : 0;
        if (distance <= (double)this.rangeSq && this.visibilityTimer >= 20) {
            this.entity.func_70661_as().func_75499_g();
            return false;
        }
        if (this.speed > 0.0f) {
            this.entity.func_70661_as().func_75497_a(this.target, (double)this.speed);
        }
        this.entity.func_70671_ap().func_75651_a(this.target, 30.0f, 30.0f);
        return this.speed > 0.0f;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.target = null;
        this.delay = 0;
        this.timer = 0;
        this.visibilityTimer = 0;
    }
}

