/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.client.render.block.RenderAncientTablet;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityInvulnerableItem;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;

public class BlockAncientTablet
extends Block
implements IWhipBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottomRotated;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTopRotated;

    public BlockAncientTablet(Material material) {
        super(material);
        this.func_149722_s();
        this.func_149752_b(BlockWeight.IMPOSSIBLE.weight);
        this.func_149672_a(field_149769_e);
        this.func_149676_a(0.125f, 0.0f, 0.375f, 0.875f, 0.9375f, 0.625f);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return side > 1;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        return Event.Result.DEFAULT;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderAncientTablet.renderId;
    }

    public int func_149656_h() {
        return 2;
    }

    public int func_149692_a(int meta) {
        return EnumType.byMetadata(meta).ordinal();
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        EnumType type = EnumType.byMetadata(world.func_72805_g(x, y, z));
        if (world.func_72957_l(x, y, z) < 8) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.ancient_tablet.dark", new Object[0]);
        } else if (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() != ZSSItems.bookMudora) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.ancient_tablet.unknown", new Object[0]);
        } else if (!PlayerUtils.hasMasterSword(player)) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.ancient_tablet.text." + type.name, new Object[0]);
        } else {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.ancient_tablet.text." + type.name, new Object[0]);
            for (int i = 1; i < 6; ++i) {
                if (world.func_147437_c(x, y + i, z)) continue;
                PlayerUtils.sendTranslatedChat(player, "chat.zss.ancient_tablet.confined", new Object[0]);
                return false;
            }
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
            world.func_147454_a(x, y, z, (Block)this, 5, 1);
            return true;
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int face = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int meta = (face & 1) == 0 ? 1 : 0;
        world.func_72921_c(x, y, z, meta |= stack.func_77960_j() < 4 ? stack.func_77960_j() << 2 : stack.func_77960_j(), 2);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int i = EnumType.byMetadata(world.func_72805_g(x, y, z)).ordinal();
        EntityInvulnerableItem item = new EntityInvulnerableItem(world, (double)x + 0.5, (double)y + 5.5, (double)z + 0.5, new ItemStack(ZSSItems.medallion, 1, i));
        item.field_145804_b = 10;
        world.func_72838_d((Entity)item);
        world.func_147480_a(x, y, z, false);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if ((world.func_72805_g(x, y, z) & 1) == 0) {
            this.func_149676_a(0.375f, 0.0f, 0.125f, 0.625f, 0.9375f, 0.875f);
        } else {
            this.func_149676_a(0.125f, 0.0f, 0.375f, 0.875f, 0.9375f, 0.625f);
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.125f, 0.0f, 0.375f, 0.875f, 0.9375f, 0.625f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumType variant : EnumType.values()) {
            list.add(new ItemStack(item, 1, variant.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (meta & 1) {
            case 0: {
                return side == 0 ? this.iconBottomRotated : (side == 1 ? this.iconTopRotated : (side == 4 || side == 5 ? this.field_149761_L : this.iconSide));
            }
            case 1: {
                return side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : (side == 2 || side == 3 ? this.field_149761_L : this.iconSide));
            }
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String s = "zeldaswordskills:" + this.func_149739_a().substring(9);
        this.field_149761_L = register.func_94245_a(s + "_face");
        this.iconBottom = register.func_94245_a(s + "_bottom");
        this.iconBottomRotated = register.func_94245_a(s + "_bottom_rotated");
        this.iconSide = register.func_94245_a(s + "_side");
        this.iconTop = register.func_94245_a(s + "_top");
        this.iconTopRotated = register.func_94245_a(s + "_top_rotated");
    }

    public static enum EnumType {
        BOMBOS(0, "bombos", -1),
        ETHER(4, "ether", 30),
        QUAKE(8, "quake", 30);

        private final int meta;
        private final String name;
        private final int itemUseDuration;

        private EnumType(int meta, String name, int maxUseDuration) {
            this.meta = meta;
            this.name = name;
            this.itemUseDuration = maxUseDuration;
        }

        public String getName() {
            return this.name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public int getItemUseDuration() {
            return this.itemUseDuration;
        }

        public static EnumType byMetadata(int meta) {
            return EnumType.values()[(meta > 3 ? meta >> 2 : meta) % EnumType.values().length];
        }
    }
}

