/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;

public class BlockDoorLocked
extends Block
implements IDungeonBlock {
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconEmpty;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconUpper;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconLower;

    public BlockDoorLocked(Material material) {
        super(material);
        this.func_149722_s();
        this.func_149752_b(BlockWeight.IMPOSSIBLE.weight);
        this.func_149672_a(field_149777_j);
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return y >= 255 ? false : World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && super.func_149742_c(world, x, y, z) && super.func_149742_c(world, x, y + 1, z);
    }

    protected boolean canUnlock(EntityPlayer player, int meta) {
        ItemStack key = player.func_70694_bm();
        if (key != null) {
            if (key.func_77973_b() == ZSSItems.keySmall) {
                return PlayerUtils.consumeHeldItem(player, ZSSItems.keySmall, 1);
            }
            if (key.func_77973_b() == ZSSItems.keySkeleton) {
                key.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (this.canUnlock(player, world.func_72805_g(x, y, z))) {
                world.func_72956_a((Entity)player, "zeldaswordskills:lock_door", 0.25f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
                world.func_147468_f(x, y, z);
            } else {
                world.func_72956_a((Entity)player, "zeldaswordskills:lock_rattle", 0.25f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
            }
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        if (world.func_147439_a(x, y += oldMeta > 7 ? -1 : 1, z) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(ZSSItems.doorLockedSmall);
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0 && meta > 7 || side == 1 && meta < 8) {
            return this.iconEmpty;
        }
        return meta > 7 ? (side == 1 ? this.iconTop : this.iconUpper) : (side == 0 ? this.iconTop : this.iconLower);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconEmpty = register.func_94245_a("zeldaswordskills:empty");
        this.iconTop = register.func_94245_a("zeldaswordskills:" + this.func_149739_a().substring(9) + "_top");
        this.iconUpper = register.func_94245_a("zeldaswordskills:" + this.func_149739_a().substring(9) + "_upper");
        this.iconLower = register.func_94245_a("zeldaswordskills:" + this.func_149739_a().substring(9) + "_lower");
    }
}

