/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WarpPoint;

public class BlockWarpStone
extends Block
implements ILiftable,
ISmashable {
    public static final Map<Integer, AbstractZeldaSong> warpBlockSongs = new HashMap<Integer, AbstractZeldaSong>();
    public static final Map<AbstractZeldaSong, Integer> reverseLookup = new HashMap<AbstractZeldaSong, Integer>();

    public BlockWarpStone() {
        super(Material.field_151576_e);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(field_149769_e);
        this.func_149658_d("zeldaswordskills:warp_stone");
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    public int func_149656_h() {
        return 2;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float dropChance, int fortune) {
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return BlockWeight.IMPOSSIBLE;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        return Event.Result.DENY;
    }

    @Override
    public BlockWeight getLiftWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return BlockWeight.IMPOSSIBLE;
    }

    @Override
    public void onLifted(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int meta) {
    }

    @Override
    public void onHeldBlockPlaced(World world, ItemStack stack, int x, int y, int z, int meta) {
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        AbstractZeldaSong song;
        int meta = world.func_72805_g(x, y, z);
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemInstrument) {
            AbstractZeldaSong song2 = warpBlockSongs.get(meta);
            ZSSPlayerSongs songs = ZSSPlayerSongs.get(player);
            if (!world.field_72995_K) {
                if (song2 != null) {
                    songs.onActivatedWarpStone(x, y, z, meta);
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.block.warp_stone.activate", new ChatComponentTranslation(song2.getTranslationString(), new Object[0]), x, y, z);
                }
            } else if (!player.func_70093_af()) {
                if (song2 != null) {
                    songs.songToLearn = song2;
                    player.openGui((Object)ZSSMain.instance, 5, player.field_70170_p, x, y, z);
                } else {
                    ZSSMain.logger.warn(String.format("Warp stone at %d/%d/%d had invalid metadata: did not return a song!", x, y, z));
                }
            }
            return true;
        }
        if (player.field_71075_bZ.field_75098_d && player.func_70093_af() && (song = warpBlockSongs.get(meta)) != null && !world.field_72995_K) {
            WarpPoint warp = new WarpPoint(world.field_73011_w.field_76574_g, x, y, z);
            WarpPoint previous = Config.setDefaultWarpPoint(song, warp);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.block.warp_stone.set_default", song.getDisplayName(), warp.toString());
            if (previous != null) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.block.warp_stone.previous", song.getDisplayName(), previous.toString());
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < warpBlockSongs.size(); ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    private static void addSongMapping(int meta, AbstractZeldaSong song) {
        warpBlockSongs.put(meta, song);
        reverseLookup.put(song, meta);
    }

    static {
        int i = 0;
        BlockWarpStone.addSongMapping(i++, ZeldaSongs.songWarpForest);
        BlockWarpStone.addSongMapping(i++, ZeldaSongs.songWarpFire);
        BlockWarpStone.addSongMapping(i++, ZeldaSongs.songWarpWater);
        BlockWarpStone.addSongMapping(i++, ZeldaSongs.songWarpSpirit);
        BlockWarpStone.addSongMapping(i++, ZeldaSongs.songWarpShadow);
        BlockWarpStone.addSongMapping(i++, ZeldaSongs.songWarpLight);
        BlockWarpStone.addSongMapping(i++, ZeldaSongs.songWarpOrder);
    }
}

