/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import zeldaswordskills.client.gui.GuiMusicBase;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.LearnSongPacket;
import zeldaswordskills.network.bidirectional.PlayRecordPacket;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;

@SideOnly(value=Side.CLIENT)
public class GuiLearnSong
extends GuiMusicBase {
    protected static final ResourceLocation texture = new ResourceLocation("zeldaswordskills", "textures/gui/gui_ocarina.png");
    private AbstractZeldaSong songToLearn;
    private int currentNoteIndex;
    private boolean demoPlayed;

    public GuiLearnSong(int x, int y, int z) {
        super(x, y, z);
        this.songToLearn = ZSSPlayerSongs.get((EntityPlayer)this.field_146297_k.field_71439_g).songToLearn;
        if (this.songToLearn == null || this.songToLearn.getNotes() == null || this.songToLearn.getNotes().isEmpty()) {
            throw new IllegalArgumentException("ZSSPlayerSongs#songToLearn may not be null or empty when opening the Song Learning GUI!");
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (ZSSPlayerSongs.get((EntityPlayer)this.field_146297_k.field_71439_g).isSongKnown(this.songToLearn)) {
            PlayerUtils.sendTranslatedChat((EntityPlayer)this.field_146297_k.field_71439_g, "chat.zss.song.forgot", new Object[0]);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return texture;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        if (!this.demoPlayed && this.song == null) {
            String s = this.songToLearn.getDisplayName();
            this.field_146289_q.func_78276_b(s, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(s) / 2, this.guiTop + 3, 0xFFFFFF);
        }
    }

    @Override
    public void func_73876_c() {
        if (!this.demoPlayed) {
            if (++this.ticksSinceLastNote == 20) {
                if (this.currentNoteIndex == this.songToLearn.getNotes().size()) {
                    PlayerUtils.sendTranslatedChat((EntityPlayer)this.field_146297_k.field_71439_g, "chat.zss.song.mimic", new Object[0]);
                    this.demoPlayed = true;
                    this.melody.clear();
                    this.ticksSinceLastNote = 0;
                } else {
                    this.onNotePlayed(this.songToLearn.getNotes().get(this.currentNoteIndex++));
                }
            }
        } else {
            super.func_73876_c();
        }
    }

    @Override
    protected boolean allowKeyInput() {
        return this.demoPlayed && super.allowKeyInput();
    }

    public void func_146281_b() {
        ZSSPlayerSongs.get((EntityPlayer)this.field_146297_k.field_71439_g).songToLearn = null;
        if (this.song != null) {
            if (this.ticksSinceLastNote > this.song.getMinDuration()) {
                PacketDispatcher.sendToServer(new LearnSongPacket(this.song));
            } else {
                PacketDispatcher.sendToServer(new PlayRecordPacket(null, this.x, this.y, this.z));
                PlayerUtils.sendTranslatedChat((EntityPlayer)this.field_146297_k.field_71439_g, "chat.zss.song.premature", new Object[0]);
            }
        }
    }

    @Override
    protected void onNoteAdded() {
        int i = this.melody.size() - 1;
        if (this.melody.get(i) != this.songToLearn.getNotes().get(i)) {
            PlayerUtils.sendTranslatedChat((EntityPlayer)this.field_146297_k.field_71439_g, "chat.zss.song.incorrect." + this.field_146297_k.field_71441_e.field_73012_v.nextInt(4), new Object[0]);
            this.melody.clear();
        } else if (this.songToLearn.areCorrectNotes(this.melody)) {
            this.song = this.songToLearn;
            this.field_146297_k.field_71439_g.func_85030_a("zeldaswordskills:success", 0.3f, 1.0f);
            PacketDispatcher.sendToServer(new PlayRecordPacket(this.song.getSoundString(), this.x, this.y, this.z));
            PlayerUtils.sendTranslatedChat((EntityPlayer)this.field_146297_k.field_71439_g, "chat.zss.song.correct." + this.field_146297_k.field_71441_e.field_73012_v.nextInt(4), new Object[0]);
        }
    }
}

