/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.client.RenderHelperQ;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.SongNote;

@SideOnly(value=Side.CLIENT)
public abstract class GuiMusicBase
extends GuiScreen {
    protected final Minecraft field_146297_k;
    protected static final int MAX_NOTES = 8;
    protected static final int NOTE_SIZE = 12;
    protected static final int INT_Y = 5;
    protected int xSize = 213;
    protected int ySize = 90;
    protected int fullX = 256;
    protected int fullY = 128;
    protected int guiLeft;
    protected int guiTop;
    protected AbstractZeldaSong song;
    protected final List<SongNote> melody = new ArrayList<SongNote>();
    protected int ticksSinceLastNote;
    protected final int x;
    protected final int y;
    protected final int z;

    public GuiMusicBase(int x, int y, int z) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2 + 25;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected abstract ResourceLocation getTexture();

    public void func_73863_a(int mouseX, int mouseY, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        RenderHelperQ.drawTexturedRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.fullX, this.fullY);
        GL11.glPopAttrib();
        int i1 = this.melody.size() > 8 ? (this.melody.size() - 1) / 8 * 8 : 0;
        int i = 0;
        while (i + i1 < this.melody.size()) {
            SongNote note = this.melody.get(i + i1);
            int j = SongNote.Note.values().length - (note.note.ordinal() + 1) + SongNote.Note.values().length * (2 - note.getOctave());
            int dy = 6 + 5 * j;
            int dx = 46 + 20 * i;
            if (j > 10) {
                int dy2 = 65;
                for (int n = 0; n < (j - 9) / 2; ++n) {
                    RenderHelperQ.drawTexturedRect(this.guiLeft + (dx - 2), this.guiTop + dy2 + n * 2 * 5, 8, 15, 16, 5, this.fullX, this.fullY);
                }
            }
            RenderHelperQ.drawTexturedRect(this.guiLeft + dx, this.guiTop + dy, this.xSize, SongNote.PlayableNote.getOrdinalFromNote(note) * 12, 12, 12, this.fullX, this.fullY);
            if (note.isSharp() || note.isFlat()) {
                RenderHelperQ.drawTexturedRect(this.guiLeft + dx + 12 - 2, this.guiTop + dy, this.xSize + 12, note.isSharp() ? 0 : 5, 5, 5, this.fullX, this.fullY);
            }
            ++i;
        }
        if (this.song != null) {
            String s = this.song.getDisplayName();
            this.field_146289_q.func_78276_b(s, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(s) / 2, this.guiTop + 3, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, f);
    }

    public void func_73876_c() {
        ++this.ticksSinceLastNote;
        if (this.song != null) {
            if (this.ticksSinceLastNote > this.song.getMinDuration()) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        } else if (this.ticksSinceLastNote > Config.getNoteResetInterval()) {
            this.ticksSinceLastNote = 0;
            this.melody.clear();
        }
    }

    protected boolean allowKeyInput() {
        return this.song == null;
    }

    protected void func_73869_a(char c, int key) {
        if (!this.allowKeyInput()) {
            super.func_73869_a(c, key);
            return;
        }
        SongNote.PlayableNote playedNote = null;
        if (key == ZSSKeyHandler.keys[2].func_151463_i()) {
            playedNote = SongNote.PlayableNote.D2;
        } else if (key == ZSSKeyHandler.keys[5].func_151463_i()) {
            playedNote = SongNote.PlayableNote.F1;
        } else if (key == ZSSKeyHandler.keys[3].func_151463_i()) {
            playedNote = SongNote.PlayableNote.B2;
        } else if (key == ZSSKeyHandler.keys[4].func_151463_i()) {
            playedNote = SongNote.PlayableNote.A2;
        } else if (key == this.field_146297_k.field_71474_y.field_74314_A.func_151463_i()) {
            playedNote = SongNote.PlayableNote.D1;
        }
        if (playedNote == null) {
            super.func_73869_a(c, key);
        } else {
            int modifier = 0;
            if (Keyboard.isKeyDown((int)this.field_146297_k.field_71474_y.field_74366_z.func_151463_i())) {
                ++modifier;
            } else if (Keyboard.isKeyDown((int)this.field_146297_k.field_71474_y.field_74370_x.func_151463_i())) {
                --modifier;
            }
            if (Keyboard.isKeyDown((int)this.field_146297_k.field_71474_y.field_74351_w.func_151463_i())) {
                modifier += 2;
            } else if (Keyboard.isKeyDown((int)this.field_146297_k.field_71474_y.field_74368_y.func_151463_i())) {
                modifier -= 2;
            }
            SongNote note = SongNote.getNote(playedNote, modifier);
            if (note != null) {
                this.onNotePlayed(note);
                this.onNoteAdded();
            }
        }
    }

    protected abstract void onNoteAdded();

    protected void onNotePlayed(SongNote note) {
        this.melody.add(note);
        this.ticksSinceLastNote = 0;
        float f = (float)Math.pow(2.0, (double)(note.ordinal() - 12) / 12.0);
        this.field_146297_k.field_71439_g.func_85030_a("zeldaswordskills:note.ocarina", 3.0f, f);
        Vec3 look = this.field_146297_k.field_71439_g.func_70040_Z();
        this.field_146297_k.field_71441_e.func_72869_a("note", this.field_146297_k.field_71439_g.field_70165_t + look.field_72450_a + this.field_146297_k.field_71441_e.field_73012_v.nextDouble() - 0.5, this.field_146297_k.field_71439_g.field_70163_u + look.field_72448_b + (double)this.field_146297_k.field_71439_g.func_70047_e() + this.field_146297_k.field_71441_e.field_73012_v.nextDouble() - 0.5, this.field_146297_k.field_71439_g.field_70161_v + look.field_72449_c + this.field_146297_k.field_71441_e.field_73012_v.nextDouble() - 0.5, (double)note.ordinal() / 24.0, 0.0, 0.0);
    }
}

