/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.client.particle.ParticleCyclone;

@SideOnly(value=Side.CLIENT)
public class FXCycloneRing
extends EntityFX {
    public static float ascendVelocity = 0.2f;
    public static int puffsPerRing = 8;
    public static float maxRingHeight = 4.0f;
    public static float baseAngleVelocity = 0.4f;
    private EntityFX[] puffs;
    private float dAngle;
    private float yaw;
    private float pitch;
    private Vec3 axis;
    private float ringHeight;
    private float baseAngle;

    public FXCycloneRing(World world, double x, double y, double z, double velX, double velY, double velZ, float yaw, float pitch, float alpha, EffectRenderer renderer) {
        super(world, x, y, z);
        this.field_70159_w = velX;
        this.field_70181_x = velY;
        this.field_70179_y = velZ;
        this.axis = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
        this.field_70545_g = 0.0f;
        this.yaw = yaw;
        this.pitch = pitch;
        this.axis.func_72440_a(pitch);
        this.axis.func_72442_b(yaw);
        this.ringHeight = ascendVelocity;
        this.baseAngle = 0.0f;
        this.field_82339_as = alpha;
        this.puffs = new EntityFX[puffsPerRing];
        for (int i = 0; i < puffsPerRing; ++i) {
            int zInt;
            int yInt;
            int xInt;
            Block block;
            if (Math.random() < 0.07 && (block = world.func_147439_a(xInt = MathHelper.func_76128_c((double)x), yInt = MathHelper.func_76128_c((double)y) - 1, zInt = MathHelper.func_76128_c((double)z))) != null) {
                int metadata = world.func_72805_g(xInt, yInt, zInt);
                this.puffs[i] = new EntityDiggingFX(world, x, y + 0.1, z, velX, velY, velZ, block, metadata).func_70596_a(xInt, yInt, zInt).func_70541_f(0.5f);
                renderer.func_78873_a(this.puffs[i]);
                continue;
            }
            this.puffs[i] = new ParticleCyclone(world, x, y, z, velX, velY, velZ);
            this.puffs[i].func_82338_g(this.field_82339_as);
            renderer.func_78873_a(this.puffs[i]);
        }
        this.dAngle = (float)Math.PI * 2 / (float)this.puffs.length;
    }

    public void func_82338_g(float alpha) {
        super.func_82338_g(alpha);
        for (int i = 0; i < this.puffs.length; ++i) {
            this.puffs[i].func_82338_g(alpha);
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
    }

    public void func_70071_h_() {
        int i;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float ringWidth = FXCycloneRing.getWidthVSHeight(this.ringHeight);
        for (i = 0; i < this.puffs.length; ++i) {
            Vec3 vec = Vec3.func_72443_a((double)ringWidth, (double)0.0, (double)0.0);
            vec.func_72442_b(this.baseAngle + (float)i * this.dAngle);
            vec.func_72440_a(this.pitch);
            vec.func_72442_b(this.yaw);
            this.puffs[i].field_70159_w = this.field_70165_t + this.field_70159_w + vec.field_72450_a - this.puffs[i].field_70165_t;
            this.puffs[i].field_70181_x = this.field_70163_u + this.field_70181_x + vec.field_72448_b - this.puffs[i].field_70163_u;
            this.puffs[i].field_70179_y = this.field_70161_v + this.field_70179_y + vec.field_72449_c - this.puffs[i].field_70161_v;
        }
        if (this.axis != null) {
            if (this.ringHeight < maxRingHeight) {
                this.field_70165_t += this.axis.field_72450_a * (double)ascendVelocity;
                this.field_70163_u += this.axis.field_72448_b * (double)ascendVelocity;
                this.field_70161_v += this.axis.field_72449_c * (double)ascendVelocity;
                this.ringHeight += ascendVelocity;
            } else {
                for (i = 0; i < puffsPerRing; ++i) {
                    this.puffs[i].func_70106_y();
                }
                this.func_70106_y();
            }
        }
        this.baseAngle += baseAngleVelocity;
        if ((double)this.baseAngle > Math.PI * 2) {
            this.baseAngle = (float)((double)this.baseAngle - Math.PI * 2);
        }
    }

    public static float getWidthVSHeight(float height) {
        return height * 0.2f + 0.15f;
    }
}

