/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.client.model.ModelCube;
import zeldaswordskills.client.model.ModelWizzrobe;
import zeldaswordskills.entity.mobs.EntityGrandWizzrobe;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.projectile.EntityMagicSpell;

@SideOnly(value=Side.CLIENT)
public class RenderEntityWizzrobe
extends RenderLiving {
    private static final ResourceLocation fireWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_fire.png");
    private static final ResourceLocation iceWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_ice.png");
    private static final ResourceLocation lightningWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_lightning.png");
    private static final ResourceLocation windWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_wind.png");
    private static final ResourceLocation grandFireWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_fire_grand.png");
    private static final ResourceLocation grandIceWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_ice_grand.png");
    private static final ResourceLocation grandLightningWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_lightning_grand.png");
    private static final ResourceLocation grandWindWizTexture = new ResourceLocation("zeldaswordskills", "textures/entity/wizzrobe_wind_grand.png");
    private final EntityMagicSpell spell;
    private final ModelWizzrobe model;
    private final ModelCube box1 = new ModelCube(4);
    private final ModelCube box2 = new ModelCube(4);
    private final float scale;

    public RenderEntityWizzrobe(ModelWizzrobe model, float scale) {
        super((ModelBase)model, 0.5f);
        this.model = model;
        this.scale = scale;
        this.spell = new EntityMagicSpell((World)Minecraft.func_71410_x().field_71441_e);
    }

    protected void func_77041_b(EntityLivingBase entity, float partialTick) {
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
    }

    public void func_76986_a(EntityLiving entity, double dx, double dy, double dz, float yaw, float partialTick) {
        if (entity instanceof IBossDisplayData) {
            BossStatus.func_82824_a((IBossDisplayData)((IBossDisplayData)entity), (boolean)true);
        }
        super.func_76986_a(entity, dx, dy, dz, yaw, partialTick);
        if (this.model.atPeak) {
            this.renderSpell((EntityWizzrobe)entity, dx, dy, dz, yaw, partialTick);
        }
    }

    private void renderSpell(EntityWizzrobe wizzrobe, double dx, double dy, double dz, float yaw, float partialTick) {
        float roll;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Vec3 vec3 = Vec3.func_72443_a((double)dx, (double)dy, (double)dz).func_72432_b();
        GL11.glTranslated((double)(dx - vec3.field_72450_a), (double)(dy + (double)wizzrobe.func_70047_e()), (double)(dz - vec3.field_72449_c));
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        for (roll = ((float)wizzrobe.getCurrentCastingTime() + partialTick) * 40.0f; roll > 360.0f; roll -= 360.0f) {
        }
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)roll, (float)0.8f, (float)0.0f, (float)-0.6f);
        this.func_110776_a(wizzrobe.getMagicType().getEntityTexture());
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        this.box1.render((Entity)this.spell);
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.box2.render((Entity)this.spell);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        boolean grand = entity instanceof EntityGrandWizzrobe;
        switch (((EntityWizzrobe)entity).getMagicType()) {
            case FIRE: {
                return grand ? grandFireWizTexture : fireWizTexture;
            }
            case ICE: {
                return grand ? grandIceWizTexture : iceWizTexture;
            }
            case LIGHTNING: {
                return grand ? grandLightningWizTexture : lightningWizTexture;
            }
        }
        return grand ? grandWindWizTexture : windWizTexture;
    }
}

