/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.command;

import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import zeldaswordskills.api.SongAPI;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.OpenSongGuiPacket;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;

public class CommandGrantSong
extends CommandBase {
    public static final ICommand INSTANCE = new CommandGrantSong();

    private CommandGrantSong() {
    }

    public String func_71517_b() {
        return "grantsong";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender player) {
        return "commands.grantsong.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayerMP commandSender = CommandGrantSong.func_71521_c((ICommandSender)sender);
        EntityPlayerMP player = CommandGrantSong.func_82359_c((ICommandSender)sender, (String)args[0]);
        ZSSPlayerSongs info = ZSSPlayerSongs.get((EntityPlayer)player);
        if (args.length != 2 && args.length != 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if ("all".equals(args[1])) {
            if (args.length != 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            boolean flag = true;
            for (AbstractZeldaSong song : SongAPI.getRegisteredSongs()) {
                if (!song.canLearnFromCommand() || info.learnSong(song, null)) continue;
                flag = false;
            }
            if (!flag) {
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantsong.success.partial", player.func_70005_c_());
                return;
            } else {
                if (commandSender == player) return;
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantsong.success.all", player.func_70005_c_());
            }
            return;
        } else {
            AbstractZeldaSong song = SongAPI.getSongByName(args[1]);
            if (song == null) {
                throw new CommandException("commands.song.generic.unknown", new Object[]{args[1]});
            }
            if (!song.canLearnFromCommand()) {
                throw new CommandException("commands.grantsong.failure.denied", new Object[]{new ChatComponentTranslation(song.getTranslationString(), new Object[0])});
            }
            if (args.length == 3) {
                if (!"true".equals(args[2])) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                PacketDispatcher.sendTo(new OpenSongGuiPacket(song), player);
                return;
            } else if (info.learnSong(song, null)) {
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantsong.success.one", player.func_70005_c_(), new ChatComponentTranslation(song.getTranslationString(), new Object[0]));
                return;
            } else {
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantsong.failure.player", player.func_70005_c_(), new ChatComponentTranslation(song.getTranslationString(), new Object[0]));
            }
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        switch (args.length) {
            case 1: {
                return CommandGrantSong.func_71530_a((String[])args, (String[])this.getPlayers());
            }
            case 2: {
                return CommandGrantSong.func_71530_a((String[])args, (String[])SongAPI.getRegisteredNames().toArray(new String[SongAPI.getTotalSongs()]));
            }
            case 3: {
                return CommandGrantSong.func_71530_a((String[])args, (String[])new String[]{"true"});
            }
        }
        return null;
    }

    protected String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }
}

