/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBombEater;
import zeldaswordskills.api.entity.IEntityBombIngestible;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.buff.BuffBase;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.SyncEntityInfoPacket;
import zeldaswordskills.ref.Config;

public class ZSSEntityInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "ZSSEntityInfo";
    private final EntityLivingBase entity;
    private Map<Buff, BuffBase> activeBuffs = new EnumMap<Buff, BuffBase>(Buff.class);
    private int stunResistTime;
    private int fuseTime;
    private IEntityBombIngestible ingestedBomb;

    public ZSSEntityInfo(EntityLivingBase entity) {
        this.entity = entity;
    }

    public void init(Entity entity, World world) {
    }

    public boolean isBuffActive(Buff buff) {
        return this.activeBuffs.containsKey((Object)buff);
    }

    public BuffBase getActiveBuff(Buff buff) {
        return this.activeBuffs.get((Object)buff);
    }

    public int getBuffAmplifier(Buff buff) {
        return this.isBuffActive(buff) ? this.getActiveBuff(buff).getAmplifier() : 0;
    }

    public boolean isBuffPermanent(Buff buff) {
        return this.isBuffActive(buff) && this.getActiveBuff(buff).isPermanent();
    }

    public Collection<BuffBase> getActiveBuffs() {
        return this.activeBuffs.values();
    }

    public void applyBuff(Buff buff, int duration, int amplifier) {
        this.applyBuff(new BuffBase(buff, duration, amplifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBuff(BuffBase newBuff) {
        Map<Buff, BuffBase> map = this.activeBuffs;
        synchronized (map) {
            if (this.isBuffActive(newBuff.getBuff())) {
                this.getActiveBuff(newBuff.getBuff()).combine(newBuff);
                this.getActiveBuff(newBuff.getBuff()).onChanged(this.entity);
            } else {
                this.activeBuffs.put(newBuff.getBuff(), newBuff);
                newBuff.onAdded(this.entity);
            }
        }
    }

    public void removeAllBuffs() {
        this.removeAllBuffs(true, false);
    }

    public void removeAllBuffs(boolean removeAll, boolean sendUpdate) {
        if (!this.entity.field_70170_p.field_72995_K) {
            Iterator<Buff> iterator = this.activeBuffs.keySet().iterator();
            while (iterator.hasNext()) {
                Buff buff = iterator.next();
                if (!removeAll && this.activeBuffs.get((Object)buff).isPermanent()) continue;
                this.activeBuffs.get((Object)buff).onRemoved(this.entity, sendUpdate);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBuff(Buff buff) {
        Map<Buff, BuffBase> map = this.activeBuffs;
        synchronized (map) {
            BuffBase buffBase = this.activeBuffs.remove((Object)buff);
            if (buffBase != null) {
                buffBase.onRemoved(this.entity);
            }
        }
    }

    protected void updateBuffs() {
        Iterator<BuffBase> iterator = this.activeBuffs.values().iterator();
        while (iterator.hasNext()) {
            BuffBase buff = iterator.next();
            if (!buff.onUpdate(this.entity)) continue;
            buff.onRemoved(this.entity);
            iterator.remove();
        }
    }

    public void stun(int time) {
        this.stun(time, false);
    }

    public void stun(int time, boolean alwaysStuns) {
        int stunTime;
        int n = stunTime = this.stunResistTime > 0 || !alwaysStuns && this.isImmuneToStun() ? 0 : time;
        if (stunTime > 0 && !this.entity.field_70170_p.field_72995_K) {
            stunTime = (int)((float)stunTime * (1.0f + (float)this.getBuffAmplifier(Buff.RESIST_STUN) * 0.01f));
            if ((stunTime = (int)((float)stunTime * (1.0f - (float)this.getBuffAmplifier(Buff.RESIST_STUN) * 0.01f))) > 0) {
                this.stunResistTime = 40;
                this.applyBuff(new BuffBase(Buff.STUN, stunTime, 0));
            }
        }
    }

    public boolean isImmuneToStun() {
        return this.entity instanceof EntityPlayer && !Config.canPlayersBeStunned() || this.entity instanceof IBossDisplayData;
    }

    public boolean hasIngestedBomb() {
        return this.ingestedBomb != null;
    }

    public boolean onBombIngested(IEntityBombIngestible bomb) {
        if (this.ingestedBomb != null || !(bomb instanceof Entity)) {
            return false;
        }
        this.fuseTime = bomb.getFuseTime((Entity)this.entity);
        this.ingestedBomb = bomb;
        if (!this.entity.field_70170_p.field_72995_K) {
            ((Entity)bomb).func_70106_y();
        }
        return true;
    }

    public void refreshFuseTime() {
        if (this.ingestedBomb != null) {
            this.fuseTime = this.ingestedBomb.getFuseTime((Entity)this.entity);
        }
    }

    public void onUpdate() {
        this.updateBuffs();
        if (this.entity.func_70027_ad() && this.entity.field_70170_p.field_73012_v.nextInt(500) < this.getBuffAmplifier(Buff.RESIST_FIRE)) {
            this.entity.func_70066_B();
        }
        if (this.stunResistTime > 0 && !this.isBuffActive(Buff.STUN)) {
            --this.stunResistTime;
        }
        this.updateIngestedTime();
    }

    private void updateIngestedTime() {
        if (this.fuseTime > 0) {
            --this.fuseTime;
            if (this.fuseTime == 0 && this.ingestedBomb != null) {
                this.onBombIndigestion();
            }
        }
    }

    private void onBombIndigestion() {
        boolean explode = true;
        boolean isFatal = true;
        if (this.entity instanceof IEntityBombEater) {
            IEntityBombEater eater = (IEntityBombEater)this.entity;
            if (!eater.onBombIndigestion(this.ingestedBomb)) {
                return;
            }
            explode = eater.doesIngestedBombExplode(this.ingestedBomb);
            isFatal = eater.isIngestedBombFatal(this.ingestedBomb);
        }
        if (isFatal) {
            this.entity.func_70097_a(DamageSource.func_94539_a(null), this.entity.func_110138_aP() * 2.0f);
        }
        if (explode) {
            float r = this.ingestedBomb.getExplosionRadius((Entity)this.entity);
            float dmg = this.ingestedBomb.getExplosionDamage((Entity)this.entity);
            CustomExplosion.createExplosion(this.ingestedBomb, this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, r, dmg, false);
        }
        this.ingestedBomb = null;
    }

    public static final void register(EntityLivingBase entity) {
        entity.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ZSSEntityInfo(entity));
    }

    public static final ZSSEntityInfo get(EntityLivingBase entity) {
        return (ZSSEntityInfo)entity.getExtendedProperties(EXT_PROP_NAME);
    }

    public void onJoinWorld() {
        if (this.entity instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncEntityInfoPacket(this), (EntityPlayerMP)this.entity);
        }
    }

    public void copy(ZSSEntityInfo info) {
        NBTTagCompound compound = new NBTTagCompound();
        info.saveNBTData(compound);
        this.loadNBTData(compound);
        this.removeAllBuffs(false, false);
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (!this.activeBuffs.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (BuffBase buff : this.activeBuffs.values()) {
                list.func_74742_a((NBTBase)buff.writeToNBT(new NBTTagCompound()));
            }
            compound.func_74782_a("ActiveBuffs", (NBTBase)list);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b("ActiveBuffs")) {
            NBTTagList list = compound.func_150295_c("ActiveBuffs", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                BuffBase buff = BuffBase.readFromNBT(tag);
                this.activeBuffs.put(buff.getBuff(), buff);
            }
        }
    }
}

