/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.player.quests.QuestMaskSales;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public class ZSSVillagerInfo
implements IExtendedEntityProperties {
    private static final String SAVE_KEY = "zssVillagerInfo";
    private static final int NONE = -1;
    private final EntityVillager villager;
    private NBTTagCompound data;
    private int desiredMask;
    private static final Map<ItemTreasure.Treasures, MerchantRecipe> treasureTrades = new EnumMap<ItemTreasure.Treasures, MerchantRecipe>(ItemTreasure.Treasures.class);
    private static final Map<ItemTreasure.Treasures, Integer> treasureVillager = new EnumMap<ItemTreasure.Treasures, Integer>(ItemTreasure.Treasures.class);
    private Village village;
    private EntityVillager mate = null;
    private int matingTime = 0;

    public ZSSVillagerInfo(EntityVillager villager) {
        this.villager = villager;
        this.data = new NBTTagCompound();
        this.desiredMask = QuestMaskSales.MASKS.size();
    }

    public static final void register(EntityVillager villager) {
        villager.registerExtendedProperties(SAVE_KEY, (IExtendedEntityProperties)new ZSSVillagerInfo(villager));
    }

    public static final ZSSVillagerInfo get(EntityVillager villager) {
        return (ZSSVillagerInfo)villager.getExtendedProperties(SAVE_KEY);
    }

    public Item getMaskDesired() {
        if (this.desiredMask == QuestMaskSales.MASKS.size()) {
            this.desiredMask = this.villager.field_70170_p.field_73012_v.nextFloat() < Config.getMaskBuyChance() ? this.villager.field_70170_p.field_73012_v.nextInt(QuestMaskSales.MASKS.size()) : -1;
        }
        return this.desiredMask != -1 ? QuestMaskSales.getMask(this.desiredMask) : null;
    }

    public void handleSkulltulaTrade(ItemStack stack, EntityPlayer player) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        String s = "chat.zss.npc.cursed_man.";
        if (this.villager.func_70631_g_()) {
            PlayerUtils.sendTranslatedChat(player, s + "child", new Object[0]);
        } else if (info.canIncrementSkulltulaTokens()) {
            if (info.incrementSkulltulaTokens()) {
                int n = info.getSkulltulaTokens();
                ItemStack reward = null;
                switch (n) {
                    case 1: {
                        PlayerUtils.sendTranslatedChat(player, s + "token." + n, new Object[0]);
                        break;
                    }
                    case 10: {
                        reward = new ItemStack(ZSSItems.whip);
                        break;
                    }
                    case 20: {
                        reward = new ItemStack(ZSSItems.tunicZoraChest);
                        break;
                    }
                    case 30: {
                        reward = new ItemStack(ZSSItems.bombBag);
                        ((ItemBombBag)reward.func_77973_b()).addBombs(reward, new ItemStack(ZSSItems.bomb, 10));
                        break;
                    }
                    case 40: {
                        reward = new ItemStack(ZSSItems.keyBig, 1, player.field_70170_p.field_73012_v.nextInt(BossType.values().length));
                        break;
                    }
                    case 50: {
                        ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
                        for (SkillBase skill : SkillBase.getSkills()) {
                            if (skill.getId() == SkillBase.bonusHeart.getId() || skills.getSkillLevel(skill) >= skill.getMaxLevel() || reward != null && player.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
                            reward = new ItemStack(ZSSItems.skillOrb, 1, (int)skill.getId());
                        }
                        if (reward != null) break;
                        reward = new ItemStack(ZSSItems.arrowLight, 16);
                        break;
                    }
                    case 100: {
                        reward = new ItemStack(Items.field_151166_bC, 64);
                        if (Config.getSkulltulaRewardRate() <= 0) break;
                        this.villager.getEntityData().func_74772_a("NextSkulltulaReward", player.field_70170_p.func_82737_E() + (long)(24000 * Config.getSkulltulaRewardRate()));
                        break;
                    }
                    default: {
                        PlayerUtils.sendTranslatedChat(player, s + "amount", n);
                    }
                }
                if (reward != null) {
                    new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation(s + "token." + n, new Object[0]), new ChatComponentTranslation(s + "reward." + n, new Object[]{new ChatComponentTranslation(reward.func_77977_a() + ".name", new Object[0])})});
                    new TimedAddItem(player, reward, 2500, "zeldaswordskills:success");
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, s + this.villager.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
            }
        } else if (Config.getSkulltulaRewardRate() > 0 && player.field_70170_p.func_82737_E() > this.villager.getEntityData().func_74763_f("NextSkulltulaReward")) {
            ItemStack reward = new ItemStack(Items.field_151166_bC, 64);
            new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation(s + "complete", new Object[0]), new ChatComponentTranslation(s + "reward.100", new Object[]{new ChatComponentTranslation(reward.func_77977_a() + ".name", new Object[0])})});
            new TimedAddItem(player, reward, 2500, "zeldaswordskills:success");
            this.villager.getEntityData().func_74772_a("NextSkulltulaReward", player.field_70170_p.func_82737_E() + (long)(24000 * Config.getSkulltulaRewardRate()));
        } else {
            PlayerUtils.sendTranslatedChat(player, s + "complete", new Object[0]);
        }
    }

    public boolean isHunter() {
        return !this.villager.func_70631_g_() && this.villager.func_70946_n() == TradeHandler.EnumVillager.BUTCHER.ordinal() && this.villager.func_94057_bL() != null && this.villager.func_94057_bL().contains("Hunter");
    }

    public boolean isMonsterHunter() {
        return this.isHunter() && this.villager.func_94057_bL().equals("Monster Hunter");
    }

    public void addHunterTrade(EntityPlayer player, ItemStack toBuy, int price) {
        if (!this.isHunter()) {
            return;
        }
        int n = price = this.isMonsterHunter() ? price + price / 2 : price;
        if (MerchantRecipeHelper.addToListWithCheck(this.villager.func_70934_b(player), new MerchantRecipe(toBuy, new ItemStack(Items.field_151166_bC, price)))) {
            PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.hunter.new", new ChatComponentTranslation(toBuy.func_77977_a() + ".name", new Object[0]));
        } else {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.hunter.old", new ChatComponentTranslation(toBuy.func_77977_a() + ".name", new Object[0]));
        }
    }

    public MerchantRecipe getTreasureTrade(ItemTreasure.Treasures treasure) {
        if (treasureTrades.containsKey((Object)treasure) && treasureVillager.get((Object)treasure).intValue() == this.villager.func_70946_n()) {
            return treasureTrades.get((Object)treasure);
        }
        if (this.isHunter() && treasure.canSell()) {
            boolean flag = "Monster Hunter".equals(this.villager.func_94057_bL());
            int price = treasure.getValue();
            price = flag ? price + price / 2 : price;
            return new MerchantRecipe(new ItemStack(ZSSItems.treasure, 1, treasure.ordinal()), new ItemStack(Items.field_151166_bC, price));
        }
        return null;
    }

    public boolean isInterested(ItemTreasure.Treasures treasure, ItemStack stack) {
        return treasureTrades.containsKey((Object)treasure) && treasureVillager.get((Object)treasure).intValue() == this.villager.func_70946_n();
    }

    public void addJelly(EntityChu.ChuType type, int amount) {
        this.data.func_74768_a("jelliesReceived" + type.ordinal(), this.getJelliesReceived(type) + amount);
    }

    public int getJelliesReceived(EntityChu.ChuType type) {
        return this.data.func_74764_b("jelliesReceived" + type.ordinal()) ? this.data.func_74762_e("jelliesReceived" + type.ordinal()) : 0;
    }

    public boolean isChuTrader() {
        return !this.villager.func_70631_g_() && this.villager.func_70946_n() == TradeHandler.EnumVillager.LIBRARIAN.ordinal() && this.villager.func_94057_bL().contains("Doc");
    }

    public boolean canSellType(EntityChu.ChuType type, ItemStack stack) {
        int jellies;
        for (jellies = this.getJelliesReceived(type); jellies < 15 && stack.field_77994_a > 0; ++jellies) {
            --stack.field_77994_a;
        }
        this.data.func_74768_a("jelliesReceived" + type.ordinal(), jellies);
        return jellies >= 15;
    }

    private boolean isMating() {
        return this.matingTime > 0 && this.villager.func_70874_b() == 0 && this.areSufficientDoors();
    }

    public void setMating() {
        if (this.villager.func_70874_b() == 0 && !this.isMating()) {
            Entity e;
            this.village = this.villager.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.villager.field_70165_t), MathHelper.func_76128_c((double)this.villager.field_70163_u), MathHelper.func_76128_c((double)this.villager.field_70161_v), 0);
            if (this.areSufficientDoors() && (e = this.villager.field_70170_p.func_72857_a(EntityVillager.class, this.villager.field_70121_D.func_72314_b(8.0, 3.0, 8.0), (Entity)this.villager)) != null && ((EntityVillager)e).func_70874_b() == 0) {
                this.mate = (EntityVillager)e;
                this.matingTime = 300;
                this.villager.func_70947_e(true);
            }
        }
    }

    private void updateMating() {
        if (this.isMating()) {
            --this.matingTime;
            this.villager.func_70671_ap().func_75651_a((Entity)this.mate, 10.0f, 30.0f);
            if (this.villager.func_70068_e((Entity)this.mate) > 2.25) {
                this.villager.func_70661_as().func_75497_a((Entity)this.mate, 0.25);
            } else if (this.matingTime == 0 && this.mate.func_70941_o()) {
                this.giveBirth();
                this.resetMating();
            }
            if (this.villager.func_70681_au().nextInt(35) == 0) {
                this.villager.field_70170_p.func_72960_a((Entity)this.villager, (byte)12);
            }
        }
    }

    private boolean areSufficientDoors() {
        return this.village != null ? this.village.func_75562_e() < this.village.func_75567_c() : false;
    }

    private void resetMating() {
        this.villager.func_70947_e(false);
        this.mate = null;
    }

    private void giveBirth() {
        EntityVillager baby = this.villager.func_90011_a((EntityAgeable)this.mate);
        this.mate.func_70873_a(6000);
        this.villager.func_70873_a(6000);
        baby.func_70873_a(-24000);
        baby.func_70012_b(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, 0.0f, 0.0f);
        this.villager.field_70170_p.func_72838_d((Entity)baby);
        this.villager.field_70170_p.func_72960_a((Entity)baby, (byte)12);
    }

    public void onUpdate() {
        this.updateMating();
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a(SAVE_KEY, (NBTBase)this.data);
        compound.func_74768_a("desiredMask", this.desiredMask);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.data = compound.func_74764_b(SAVE_KEY) ? compound.func_74775_l(SAVE_KEY) : new NBTTagCompound();
        this.desiredMask = compound.func_74762_e("desiredMask");
    }

    private static final void addTreasureTrade(ItemTreasure.Treasures treasure, TradeHandler.EnumVillager villager, ItemStack required, ItemStack output) {
        treasureVillager.put(treasure, villager != null ? Integer.valueOf(villager.ordinal()) : null);
        treasureTrades.put(treasure, new MerchantRecipe(new ItemStack(ZSSItems.treasure, 1, treasure.ordinal()), required, output));
    }

    public static void initTrades() {
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.EVIL_CRYSTAL, TradeHandler.EnumVillager.PRIEST, new ItemStack(ZSSItems.arrowLight, 16), new ItemStack(ZSSItems.crystalSpirit));
    }
}

