/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import zeldaswordskills.entity.ai.IMagicUser;

public class EntityAIRangedMagic
extends EntityAIBase {
    private final EntityLiving entity;
    private final IMagicUser caster;
    private int castingTimer;
    private final int minCastInterval;
    private final int maxCastInterval;
    private int attackTimer;
    private final double minDistance;
    private final double minDistanceSq;
    private EntityLivingBase attackTarget;
    private int unseenTimer;
    private static final int MAX_TIME_UNSEEN = 10;

    public <T extends EntityLiving> EntityAIRangedMagic(T entity, int minCastInterval, int maxCastInterval, double distance) {
        this.entity = entity;
        this.caster = (IMagicUser)entity;
        this.minCastInterval = minCastInterval;
        this.maxCastInterval = maxCastInterval;
        this.minDistance = distance;
        this.minDistanceSq = distance * distance;
        this.func_75248_a(15);
    }

    public void interruptCasting() {
        this.func_75251_c();
    }

    public boolean func_75253_b() {
        if (this.attackTarget == null) {
            return false;
        }
        if (this.castingTimer < 1) {
            return false;
        }
        if (!this.entity.func_70635_at().func_75522_a((Entity)this.attackTarget) && ++this.unseenTimer > 10) {
            this.unseenTimer = 0;
            return false;
        }
        if (!this.caster.canContinueCasting()) {
            return false;
        }
        return this.entity.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v) < this.minDistanceSq;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.entity.func_70638_az();
        if (target == null) {
            return false;
        }
        this.attackTarget = target;
        double d = this.entity.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
        boolean flag = this.entity.func_70635_at().func_75522_a((Entity)this.attackTarget);
        if (!flag) {
            this.interruptCasting();
            return false;
        }
        if (this.castingTimer == 0) {
            this.entity.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.attackTimer == 0) {
                if (d > this.minDistanceSq || !flag) {
                    return false;
                }
                this.castingTimer = this.caster.beginSpellCasting(this.attackTarget);
                return this.castingTimer > 0;
            }
            if (this.attackTimer < 0) {
                float f = (float)((double)MathHelper.func_76133_a((double)d) / this.minDistance);
                this.attackTimer = MathHelper.func_76141_d((float)(f * (float)(this.maxCastInterval - this.minCastInterval) + (float)this.minCastInterval));
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.caster.stopCasting();
        this.attackTarget = null;
        this.castingTimer = 0;
        this.unseenTimer = 0;
    }

    public void func_75246_d() {
        if (this.castingTimer > 0) {
            --this.castingTimer;
            this.entity.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (this.castingTimer == 0) {
                double d = this.entity.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
                float f = (float)((double)MathHelper.func_76133_a((double)d) / this.minDistance);
                float f1 = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                this.caster.castRangedSpell(this.attackTarget, f1);
                this.attackTimer = MathHelper.func_76141_d((float)(f * (float)(this.maxCastInterval - this.minCastInterval) + (float)this.minCastInterval));
            }
        }
    }
}

