/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.damage.IDamageAoE;
import zeldaswordskills.api.entity.IEntityBackslice;
import zeldaswordskills.api.entity.IEntityEvil;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.api.entity.IParryModifier;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ai.EntityAIPowerAttack;
import zeldaswordskills.entity.ai.IPowerAttacker;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.Parry;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class EntityDarknut
extends EntityMob
implements IEntityBackslice,
IEntityEvil,
IEntityLootable,
IParryModifier,
IPowerAttacker,
IEntityVariant {
    private static final UUID armorKnockbackModifierUUID = UUID.fromString("71AF0F88-82E5-49DE-B9CC-844048E33D69");
    private static final AttributeModifier armorKnockbackModifier = new AttributeModifier(armorKnockbackModifierUUID, "Armor Knockback Resistance", 1.0, 0).func_111168_a(false);
    private static final UUID armorMoveBonusUUID = UUID.fromString("B6C8CCB6-AE7B-4F14-908A-2F41BDB4D720");
    private static final AttributeModifier armorMoveBonus = new AttributeModifier(armorMoveBonusUUID, "Armor Movement Bonus", 0.35, 1).func_111168_a(false);
    private final EntityAIPowerAttack powerAttackAI = this.getNewPowerAttackAI();
    private static final byte ATTACK_FLAG = 5;
    private static final byte POWER_UP_FLAG = 6;
    private static final byte POWER_ATTACK_FLAG = 7;
    private static final byte PARRY_FLAG = 8;
    private static final byte SPIN_FLAG = 9;
    private static final int TYPE_INDEX = 16;
    private static final int ARMOR_INDEX = 17;
    private static final int CAPE_INDEX = 18;
    @SideOnly(value=Side.CLIENT)
    public int attackTimer;
    @SideOnly(value=Side.CLIENT)
    public int chargeTimer;
    @SideOnly(value=Side.CLIENT)
    public boolean isPowerAttack;
    public int parryTimer;
    private int recentHitTimer;
    private int recentHits;
    private int spinAttackTimer;
    private List<EntityLivingBase> targets;

    public static String[] getDefaultBiomes() {
        return BiomeType.getBiomeArray(null, BiomeType.ARID, BiomeType.BEACH, BiomeType.FIERY, BiomeType.MOUNTAIN, BiomeType.PLAINS);
    }

    public EntityDarknut(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.func_70105_a(1.0f, 3.0f);
        this.field_70728_aV = 12;
    }

    protected EntityAIPowerAttack getNewPowerAttackAI() {
        return new EntityAIPowerAttack(this, 4.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.225);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    public int getType() {
        return this.field_70180_af.func_75683_a(16);
    }

    @Override
    public EntityDarknut setType(int type) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)type));
        this.setWearingCape(type > 0 ? (byte)60 : 0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(type > 0 ? 100.0 : 50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(type > 0 ? 7.0 : 5.0);
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = type > 0 ? 20 : 12;
        return this;
    }

    protected float getArmorDamage() {
        return this.field_70180_af.func_111145_d(17);
    }

    protected void setArmorDamage(float value) {
        this.field_70180_af.func_75692_b(17, (Object)Float.valueOf(value));
    }

    public boolean isArmored() {
        return this.getArmorDamage() > 0.0f;
    }

    public boolean isSpinning() {
        return this.spinAttackTimer > 0;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected String func_70639_aQ() {
        return "zeldaswordskills:armor_move";
    }

    protected String func_70621_aR() {
        return "zeldaswordskills:armor_hit";
    }

    protected String func_70673_aS() {
        return "zeldaswordskills:armor_die";
    }

    protected void func_82164_bB() {
        this.func_70062_b(0, new ItemStack(ZSSItems.swordDarknut));
        this.func_70062_b(3, new ItemStack((Item)Items.field_151030_Z));
        this.applyArmorAttributeModifiers(true);
    }

    private void applyArmorAttributeModifiers(boolean wearingArmor) {
        IAttributeInstance moveAttribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        moveAttribute.func_111124_b(armorMoveBonus);
        IAttributeInstance knockbackAttribute = this.func_110148_a(SharedMonsterAttributes.field_111266_c);
        knockbackAttribute.func_111124_b(armorKnockbackModifier);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.powerAttackAI);
        if (wearingArmor) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.powerAttackAI);
            knockbackAttribute.func_111121_a(armorKnockbackModifier);
        } else {
            moveAttribute.func_111121_a(armorMoveBonus);
        }
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + 2 * this.field_70170_p.field_73013_u.func_151525_a());
    }

    public boolean isWearingCape() {
        return this.field_70180_af.func_75683_a(18) > 0;
    }

    protected void setWearingCape(byte ticksRequired) {
        this.field_70180_af.func_75692_b(18, (Object)ticksRequired);
    }

    private void damageCape() {
        byte b = this.field_70180_af.func_75683_a(18);
        if (b > 0) {
            this.setWearingCape((byte)(b - 1));
            if (b == 1) {
                this.func_70066_B();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean isPlayer = source.func_76346_g() instanceof EntityPlayer;
        if (this.func_85032_ar() || this.isSpinning()) {
            return false;
        }
        if (source == DamageSource.field_76368_d && this.field_70173_aa > 10) {
            this.breakEnclosingBlocks();
        } else {
            if (source.func_76363_c() || isPlayer && ZSSPlayerSkills.get((EntityPlayer)source.func_76346_g()).isSkillActive(SkillBase.armorBreak)) {
                if (this.parryAttack(source)) {
                    return false;
                }
                return super.func_70097_a(source, amount);
            }
            if (source.func_76346_g() == null || source.func_82725_o()) {
                if (this.isArmored() && (source == DamageSource.field_76367_g || source == DamageSource.field_82729_p)) {
                    return false;
                }
                return super.func_70097_a(source, amount);
            }
            if (this.isWearingCape()) {
                if (source.func_76347_k()) {
                    this.func_70015_d(3);
                }
                return false;
            }
            if (source.func_94541_c() && this.isArmored()) {
                if ((amount = this.damageDarknutArmor(amount * (1.25f - 0.25f * (float)this.field_70170_p.field_73013_u.func_151525_a()))) < 0.5f) {
                    return false;
                }
            } else if (!this.field_70170_p.field_72995_K) {
                if (this.isArmored()) {
                    if (TargetUtils.isTargetInFrontOf((Entity)this, source.func_76346_g(), 120.0f)) {
                        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                        return false;
                    }
                    if (isPlayer && ZSSPlayerSkills.get((EntityPlayer)source.func_76346_g()).isSkillActive(SkillBase.backSlice)) {
                        return super.func_70097_a(source, amount);
                    }
                    if (amount > (float)this.field_70170_p.field_73013_u.func_151525_a() * 2.0f) {
                        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:armorbreak", 0.4f, 0.5f);
                        this.damageDarknutArmor(amount * 0.5f);
                    }
                    return false;
                }
                if (this.parryAttack(source)) {
                    return false;
                }
                if (this.recentHitTimer > 0) {
                    if (++this.recentHits > 3 && this.field_70146_Z.nextFloat() < 0.15f * (float)this.recentHits) {
                        this.func_70642_aH();
                        this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:spinattack", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.5f);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)9);
                        this.spinAttackTimer = 12;
                        this.recentHits = 0;
                        this.targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(4.0, 0.0, 4.0));
                        if (this.targets.contains(this)) {
                            this.targets.remove(this);
                        }
                    }
                } else {
                    this.recentHits = 1;
                }
                this.recentHitTimer = 60;
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void breakEnclosingBlocks() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e()));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean flag = false;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = k + z;
                    Block block = this.field_70170_p.func_147439_a(dx, dy, dz);
                    float hardness = block.func_149712_f(this.field_70170_p, dx, dy, dz);
                    if (!block.func_149721_r() || !(hardness >= 0.0f) || !(hardness < 20.0f) || !block.canEntityDestroy((IBlockAccess)this.field_70170_p, dx, dy, dz, (Entity)this)) continue;
                    flag = true;
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_147480_a(dx, dy, dz, true);
                }
            }
        }
        if (flag) {
            this.func_71038_i();
            this.field_70724_aR = 20;
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
        }
    }

    protected boolean parryAttack(DamageSource source) {
        Entity entity = source.func_76346_g();
        if (entity == null || source.func_94541_c() || source instanceof IDamageAoE && ((IDamageAoE)source).isAoEDamage()) {
            return false;
        }
        if (TargetUtils.isTargetInFrontOf((Entity)this, entity, 90.0f) && this.field_70146_Z.nextFloat() < 0.5f - (float)this.parryTimer * 0.05f) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
            this.parryTimer = 10;
            super.func_71038_i();
            this.field_70724_aR = Math.max(this.field_70724_aR, 5);
            if (entity instanceof EntityLivingBase && !source.func_76352_a()) {
                EntityLivingBase attacker = (EntityLivingBase)entity;
                if (attacker.func_70694_bm() != null) {
                    WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                    float disarmChance = Parry.getDisarmModifier((EntityLivingBase)this, attacker);
                    if (this.field_70146_Z.nextFloat() < disarmChance) {
                        WorldUtils.dropHeldItem(attacker);
                    }
                }
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public float getOffensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.1f * (float)this.field_70170_p.field_73013_u.func_151525_a();
    }

    @Override
    public float getDefensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.1f * (float)this.field_70170_p.field_73013_u.func_151525_a();
    }

    protected float damageDarknutArmor(float amount) {
        float armorDamage = this.getArmorDamage();
        float f = amount - armorDamage;
        if ((armorDamage -= amount) < 0.1f) {
            armorDamage = 0.0f;
            this.onArmorDestroyed();
        }
        this.setArmorDamage(armorDamage);
        return f > 0.0f ? f : 0.0f;
    }

    protected void onArmorDestroyed() {
        if (this.getType() > 0) {
            this.func_70062_b(3, new ItemStack((Item)Items.field_151023_V));
        } else {
            this.func_70062_b(3, null);
        }
        this.applyArmorAttributeModifiers(false);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.field_70724_aR <= 0) {
            this.field_70724_aR = 20;
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            if (TargetUtils.isTargetInFrontOf((Entity)this, entity, 60.0f) && this.attackEntity(entity, 5)) {
                WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                return true;
            }
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
        }
        return false;
    }

    protected boolean attackEntity(Entity entity, int flag) {
        int k;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int n = k = flag == 7 || flag == 9 ? 1 : 0;
        if (entity instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            k += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (entity.func_70097_a(this.getDamageSource(flag), damage)) {
            int j;
            if (k > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)k * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)k * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(j * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLightArrowFatal() {
        return true;
    }

    @Override
    public float getLightArrowDamage(float amount) {
        return 0.0f;
    }

    protected DamageSource getDamageSource(int flag) {
        switch (flag) {
            case 7: {
                return DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h();
            }
        }
        return DamageSource.func_76358_a((EntityLivingBase)this);
    }

    @Override
    public boolean allowDamageMultiplier(EntityPlayer player) {
        return this.getArmorDamage() < 0.1f;
    }

    @Override
    public boolean allowDisarmorment(EntityPlayer player, float damage) {
        return this.getArmorDamage() < 0.1f;
    }

    @Override
    public float onBackSliced(EntityPlayer attacker, int level, float damage) {
        if (this.isArmored()) {
            this.damageDarknutArmor(this.getDamageArmorAmount());
            if (!this.isArmored()) {
                attacker.func_71029_a((StatBase)ZSSAchievements.orcaCanOpener);
            }
            return 0.0f;
        }
        return damage;
    }

    protected float getDamageArmorAmount() {
        return this.getArmorDamage();
    }

    @Override
    public void beginPowerAttack() {
        this.field_70724_aR = this.getChargeTime();
        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
    }

    @Override
    public void cancelPowerAttack() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
    }

    @Override
    public int getChargeTime() {
        return 28 - this.field_70170_p.field_73013_u.func_151525_a() * 5;
    }

    @Override
    public void performPowerAttack(EntityLivingBase target) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.field_70724_aR = 20;
        if (TargetUtils.isTargetInFrontOf((Entity)this, (Entity)target, 60.0f) && this.attackEntity((Entity)target, 7)) {
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:armorbreak", 0.4f, 0.5f);
        } else {
            this.onAttackMissed();
        }
    }

    @Override
    public void onAttackMissed() {
        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
    }

    public void func_71038_i() {
    }

    protected void func_70619_bc() {
        if (this.spinAttackTimer > 0) {
            ++this.field_70708_bq;
        } else {
            super.func_70619_bc();
        }
    }

    public void func_70636_d() {
        if (this.isWearingCape() && this.func_70027_ad()) {
            this.damageCape();
        }
        super.func_70636_d();
        if (this.parryTimer > 0) {
            --this.parryTimer;
        }
        if (this.recentHitTimer > 0 && --this.recentHitTimer == 0) {
            this.recentHits = 0;
        }
        if (this.spinAttackTimer > 0) {
            --this.spinAttackTimer;
            if (this.func_70089_S()) {
                this.field_70177_z += 30.0f;
                while (this.field_70177_z > 360.0f) {
                    this.field_70177_z -= 360.0f;
                }
                while (this.field_70177_z < -360.0f) {
                    this.field_70177_z += 360.0f;
                }
                if (!this.field_70170_p.field_72995_K) {
                    List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)this, 5, 1.0);
                    for (EntityLivingBase target : list) {
                        if (this.targets == null || !this.targets.contains(target)) continue;
                        this.attackEntity((Entity)target, 9);
                        this.targets.remove(target);
                    }
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.attackTimer > 0) {
                --this.attackTimer;
            } else if (this.attackTimer < 0) {
                ++this.attackTimer;
            }
            if (this.chargeTimer > 0) {
                --this.chargeTimer;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte flag) {
        switch (flag) {
            case 5: {
                this.isPowerAttack = false;
                if (this.attackTimer != 0) break;
                this.attackTimer = this.field_70146_Z.nextFloat() < 0.5f ? 10 : -10;
                break;
            }
            case 8: {
                this.parryTimer = 10;
                super.func_71038_i();
                break;
            }
            case 6: {
                this.chargeTimer = this.chargeTimer > 0 ? 0 : this.getChargeTime();
                break;
            }
            case 7: {
                this.isPowerAttack = true;
                this.attackTimer = 7;
                this.chargeTimer = 0;
                break;
            }
            case 9: {
                this.spinAttackTimer = 12;
                break;
            }
            default: {
                super.func_70103_a(flag);
            }
        }
    }

    public void func_70062_b(int slot, ItemStack stack) {
        super.func_70062_b(slot, stack);
        if (!this.field_70170_p.field_72995_K && slot == 3 && stack == null && this.getArmorDamage() > 0.0f) {
            this.applyArmorAttributeModifiers(false);
            this.setArmorDamage(0.0f);
        }
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        int n = this.field_70146_Z.nextInt(Math.max(2, 3 + lootingLevel));
        switch (n) {
            case 0: {
                this.func_70099_a(new ItemStack(Items.field_151145_ak), 0.0f);
                break;
            }
            case 1: {
                this.func_70099_a(new ItemStack(Items.field_151044_h), 0.0f);
                break;
            }
            default: {
                this.func_70099_a(new ItemStack(Items.field_151042_j), 0.0f);
            }
        }
    }

    protected void func_70600_l(int rarity) {
        switch (rarity) {
            case 1: {
                this.func_70099_a(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.KNIGHTS_CREST.ordinal()), 0.0f);
                break;
            }
            default: {
                this.func_70099_a(new ItemStack(Items.field_151159_an), 0.0f);
            }
        }
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return this.func_71124_b(3) == null ? 0.25f : 0.0f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.KNIGHTS_CREST.ordinal());
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        if (wasItemStolen) {
            player.func_71029_a((StatBase)ZSSAchievements.orcaDeknighted);
        }
        return wasItemStolen;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return false;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_82737_E() > (long)Config.getTimeToSpawnDarknut();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.func_82164_bB();
        if (this.field_70146_Z.nextFloat() < 0.05f * (float)this.field_70170_p.field_73013_u.func_151525_a()) {
            this.setType(1);
        }
        return data;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("ArmorHealth", this.getArmorDamage());
        compound.func_74774_a("DarknutType", this.field_70180_af.func_75683_a(16));
        compound.func_74774_a("CapeHealth", this.field_70180_af.func_75683_a(18));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setArmorDamage(compound.func_74760_g("ArmorHealth"));
        this.applyArmorAttributeModifiers(this.isArmored());
        this.field_70180_af.func_75692_b(16, (Object)compound.func_74771_c("DarknutType"));
        this.field_70180_af.func_75692_b(18, (Object)compound.func_74771_c("CapeHealth"));
    }
}

