/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.ai.EntityAIDynamicRangedAction;
import zeldaswordskills.api.entity.ai.EntityAction;
import zeldaswordskills.api.entity.ai.IEntityDynamicAI;
import zeldaswordskills.entity.mobs.EntityDekuBaba;
import zeldaswordskills.entity.mobs.EntityDekuBase;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.WorldUtils;

public class EntityDekuFire
extends EntityDekuBaba
implements IEntityAdditionalSpawnData,
IRangedAttackMob {
    public static final EntityAction ACTION_SPIT;
    public static final int GLAND_DURATION = 20;
    protected static final byte GLAND_FLAG;
    private boolean has_gland = true;
    public int gland_timer;

    public static String[] getDefaultBiomes() {
        return BiomeType.getBiomeArray(new String[]{"hell"}, BiomeType.FIERY, BiomeType.JUNGLE, BiomeType.PLAINS);
    }

    public EntityDekuFire(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    public boolean hasGland() {
        return this.has_gland;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    @Override
    protected void addAITasks() {
        super.addAITasks();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIDynamicRangedAction(this, ACTION_SPIT, 4.0f, 40.0f, 20, 60, 0.0f, true).setDifficultyScaled());
    }

    @Override
    public float getActionSpeed(int action_id) {
        int i = this.getDifficultyModifier() - 2;
        if (action_id == EntityDekuFire.ACTION_SPIT.id) {
            return 0.6f + (float)i * 0.1f;
        }
        return super.getActionSpeed(action_id);
    }

    @Override
    public boolean canExecute(int action_id, IEntityDynamicAI ai) {
        if (action_id == EntityDekuFire.ACTION_SPIT.id && !this.hasGland()) {
            return false;
        }
        return super.canExecute(action_id, ai);
    }

    @Override
    public void performAction(int action_id, IEntityDynamicAI ai) {
        Entity target = this.getCurrentTarget();
        if (!this.isConfused()) {
            if (action_id == EntityDekuFire.ACTION_SPIT.id) {
                if (target instanceof EntityLivingBase) {
                    this.func_82196_d((EntityLivingBase)target, 1.0f);
                }
            } else {
                super.performAction(action_id, ai);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float rangeRatio) {
        int difficulty = this.field_70170_p.field_73013_u.func_151525_a();
        EntityMagicSpell spell = new EntityMagicSpell(this.field_70170_p, (EntityLivingBase)this, target, 0.375f + 0.125f * (float)difficulty, 14 - difficulty * 4);
        spell.setGravityVelocity(0.01f);
        float d = 1.5f;
        Vec3 vec3 = this.func_70676_i(1.0f);
        spell.field_70165_t = this.field_70165_t + vec3.field_72450_a * (double)d;
        spell.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        spell.field_70161_v = this.field_70161_v + vec3.field_72449_c * (double)d;
        spell.setArea(0.4f + 0.2f * (float)difficulty);
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        spell.setDamage(damage);
        spell.setReflectChance(1.0f);
        spell.disableGriefing();
        spell.disableTrailingParticles();
        if (!this.field_70170_p.field_72995_K) {
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:spit", 0.4f, 0.7f);
            this.field_70170_p.func_72838_d((Entity)spell);
        }
    }

    @Override
    public boolean isAttack(int action_id) {
        return action_id == EntityDekuFire.ACTION_SPIT.id || super.isAttack(action_id);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.gland_timer != 0) {
            this.gland_timer += this.gland_timer < 0 ? 1 : -1;
            if (this.gland_timer == 0) {
                this.has_gland = false;
            }
        }
    }

    @Override
    protected float getSlashDamage(DamageSource source, float amount) {
        float damage = super.getSlashDamage(source, amount);
        if (this.has_gland && this.isSlashing(source)) {
            damage *= 0.25f;
        }
        return damage;
    }

    @Override
    protected void onProneAttack(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.isSlashing(source)) {
            this.has_gland = false;
            this.field_70170_p.func_72960_a((Entity)this, GLAND_FLAG);
        }
        super.onProneAttack(source, amount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte flag) {
        if (flag == GLAND_FLAG) {
            this.gland_timer = this.field_70146_Z.nextFloat() < 0.5f ? 20 : -20;
        } else {
            super.func_70103_a(flag);
        }
    }

    @Override
    public void func_70109_d(NBTTagCompound compound) {
        super.func_70109_d(compound);
        compound.func_74757_a("has_gland", this.has_gland);
    }

    @Override
    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.has_gland = compound.func_74767_n("has_gland");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.has_gland);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.has_gland = buffer.readBoolean();
    }

    static {
        byte by = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by + 1);
        ACTION_SPIT = new EntityAction(by, 16, 7);
        EntityDekuBaba.registerAction(ACTION_SPIT);
        byte by2 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by2 + 1);
        GLAND_FLAG = by2;
    }
}

