/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ai.EntityAILevitate;
import zeldaswordskills.entity.ai.EntityAIRangedMagic;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.SkillBase;

public class EntityGrandWizzrobe
extends EntityWizzrobe
implements IBossDisplayData {
    private int transformTimer;

    public EntityGrandWizzrobe(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAILevitate((EntityLivingBase)this, 2.5));
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.func_110163_bv();
        this.setType(this.field_70146_Z.nextInt(EntityWizzrobe.WizzrobeType.values().length));
        this.func_70105_a(1.0f, 3.0f);
        this.field_70728_aV = 50;
    }

    @Override
    protected EntityAITeleport getNewTeleportAI() {
        return new EntityAITeleport((EntityCreature)this, 16.0, 60, false, true, true, true, true);
    }

    @Override
    protected EntityAIRangedMagic getMagicAI() {
        return new EntityAIRangedMagic(this, 10, 40, 24.0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
    }

    @Override
    protected void applyTypeTraits() {
        super.applyTypeTraits();
        ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70658_aO() {
        return super.func_70658_aO() + this.field_70170_p.field_73013_u.func_151525_a() * 4;
    }

    @Override
    protected float getTelevadeChance() {
        return 1.0f;
    }

    @Override
    protected int getBaseCastingTime() {
        return 60;
    }

    @Override
    protected float getBaseSpellDamage() {
        return 8.0f;
    }

    @Override
    protected float getSpellAoE() {
        return 2.5f;
    }

    @Override
    protected float getReflectChance() {
        return 1.0f;
    }

    @Override
    protected float getMinInterruptDamage() {
        return 8.0f;
    }

    @Override
    protected float getMaxInterruptDamage() {
        return 32.0f;
    }

    @Override
    public int beginSpellCasting(EntityLivingBase target) {
        if (this.transformTimer > 0) {
            return 0;
        }
        return super.beginSpellCasting(target);
    }

    @Override
    public void castPassiveSpell() {
    }

    @Override
    public void castRangedSpell(EntityLivingBase target, float range) {
        super.castRangedSpell(target, range);
        this.transformTimer = 10;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.transformTimer > 0 && --this.transformTimer == 0 && !this.field_70170_p.field_72995_K) {
            this.setType(this.field_70146_Z.nextInt(EntityWizzrobe.WizzrobeType.values().length));
        }
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        super.func_70628_a(recentlyHit, lootingLevel);
        this.func_70099_a(new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.bonusHeart.getId()), 0.0f);
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal());
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return wasItemStolen;
    }
}

