/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.api.entity.MagicType;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ai.EntityAINearestAttackableTargetNight;
import zeldaswordskills.entity.ai.EntityAIRangedMagic;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.ai.IEntityTeleport;
import zeldaswordskills.entity.ai.IMagicUser;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.WorldUtils;

public class EntityWizzrobe
extends EntityMob
implements IEntityLootable,
IEntityTeleport,
IEntityVariant,
IMagicUser {
    protected static final int TYPE_INDEX = 16;
    protected static final int CASTING_TIME = 17;
    protected static final int MAX_CAST_TIME = 18;
    protected final EntityAIRangedMagic magicAI = this.getMagicAI();
    protected final EntityAITeleport teleportAI = this.getNewTeleportAI();
    private int noTargetTime;

    public static String[] getDefaultBiomes() {
        ArrayList biomes = Lists.newArrayList((Object[])new BiomeType[]{BiomeType.ARID, BiomeType.JUNGLE, BiomeType.PLAINS, BiomeType.RIVER, BiomeType.TAIGA});
        for (WizzrobeType type : WizzrobeType.values()) {
            biomes.add(type.favoredBiome);
        }
        return BiomeType.getBiomeArray(null, biomes.toArray(new BiomeType[biomes.size()]));
    }

    public EntityWizzrobe(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.magicAI);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.teleportAI);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTargetNight((EntityCreature)this, EntityPlayer.class, 0, true, 0.5f));
        this.field_70728_aV = 8;
        this.func_70105_a(0.6f, 1.8f);
        this.setType(WizzrobeType.WIND_WIZ);
    }

    @Override
    public EntityAITeleport getTeleportAI() {
        return this.teleportAI;
    }

    protected EntityAITeleport getNewTeleportAI() {
        return new EntityAITeleport((EntityCreature)this, 16.0, 60, true, true, true, true, true);
    }

    protected EntityAIRangedMagic getMagicAI() {
        return new EntityAIRangedMagic(this, 20, 60, 16.0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)((byte)WizzrobeType.WIND_WIZ.ordinal()));
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public MagicType getMagicType() {
        return this.getWizzrobeType().magicType;
    }

    public WizzrobeType getWizzrobeType() {
        return WizzrobeType.values()[this.field_70180_af.func_75683_a(16) % WizzrobeType.values().length];
    }

    public void setType(WizzrobeType type) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)type.ordinal()));
        this.applyTypeTraits();
    }

    @Override
    public EntityWizzrobe setType(int type) {
        this.setType(WizzrobeType.values()[type % WizzrobeType.values().length]);
        return this;
    }

    private void setTypeOnSpawn() {
        if (Config.areMobVariantsAllowed() && this.field_70146_Z.nextFloat() < Config.getMobVariantChance()) {
            this.setType(this.field_70146_Z.nextInt(WizzrobeType.values().length));
        } else {
            BiomeGenBase biome = this.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            BiomeType biomeType = BiomeType.getBiomeTypeFor(biome);
            for (WizzrobeType t : WizzrobeType.values()) {
                if (t.favoredBiome != biomeType) continue;
                this.setType(t);
                return;
            }
            if (biomeType != null) {
                switch (biomeType) {
                    case ARID: {
                        this.setType(this.field_70146_Z.nextFloat() < 0.5f ? WizzrobeType.LIGHTNING_WIZ : WizzrobeType.FIRE_WIZ);
                        break;
                    }
                    case RIVER: 
                    case JUNGLE: {
                        this.setType(this.field_70146_Z.nextFloat() < 0.5f ? WizzrobeType.WIND_WIZ : WizzrobeType.LIGHTNING_WIZ);
                        break;
                    }
                    case TAIGA: {
                        this.setType(this.field_70146_Z.nextFloat() < 0.5f ? WizzrobeType.WIND_WIZ : WizzrobeType.ICE_WIZ);
                        break;
                    }
                }
            }
        }
    }

    protected void applyTypeTraits() {
        ZSSEntityInfo info = ZSSEntityInfo.get((EntityLivingBase)this);
        info.removeAllBuffs();
        info.applyBuff(Buff.RESIST_MAGIC, Integer.MAX_VALUE, 50);
        info.applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 50);
        switch (this.getMagicType()) {
            case FIRE: {
                info.applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 50);
                info.applyBuff(Buff.WEAKNESS_COLD, Integer.MAX_VALUE, 100);
                break;
            }
            case ICE: {
                info.applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 50);
                info.applyBuff(Buff.WEAKNESS_FIRE, Integer.MAX_VALUE, 100);
                break;
            }
            case LIGHTNING: {
                info.applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 50);
                break;
            }
            case WIND: {
                break;
            }
        }
    }

    protected int getBaseCastingTime() {
        return 80;
    }

    public int getCurrentCastingTime() {
        return this.field_70180_af.func_75679_c(17);
    }

    private void setCurrentCastingTime(int time) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(17, (Object)Math.max(0, time));
        }
    }

    public int getMaxCastingTime() {
        return this.field_70180_af.func_75679_c(18);
    }

    private void setMaxCastingTime(int time) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(18, (Object)Math.max(0, time));
        }
    }

    public final void setTeleBounds(AxisAlignedBB newBounds) {
        this.teleportAI.setTeleBounds(newBounds);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70652_k(Entity target) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            boolean wasReflected = false;
            if (source.func_76364_f() instanceof EntityMagicSpell) {
                EntityMagicSpell spell = (EntityMagicSpell)source.func_76364_f();
                wasReflected = spell.getEntityData().func_74767_n("isReflected");
                if (spell.func_85052_h() == this && !wasReflected) {
                    return false;
                }
            }
            if (!wasReflected && this.canTelevade(source) && this.teleportAI.teleportRandomly()) {
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (this.getCurrentCastingTime() > 0 && !this.func_85032_ar() && amount >= this.getMinInterruptDamage()) {
            float interruptChance = 1.0f - (this.getMaxInterruptDamage() - amount) / this.getMaxInterruptDamage();
            if (this.field_70146_Z.nextFloat() < interruptChance) {
                this.magicAI.interruptCasting();
                this.teleportAI.scheduleNextTeleport(2);
            }
        }
        super.func_70665_d(source, amount);
    }

    protected Entity func_70782_k() {
        return this.func_70013_c(1.0f) < 0.5f ? this.field_70170_p.func_72856_b((Entity)this, 32.0) : null;
    }

    protected float getBaseSpellDamage() {
        return 4.0f;
    }

    protected float getSpellAoE() {
        return 1.25f;
    }

    protected float getReflectChance() {
        return -1.0f;
    }

    protected float getMinInterruptDamage() {
        return 4.0f;
    }

    protected float getMaxInterruptDamage() {
        return 16.0f;
    }

    private boolean canTelevade(DamageSource source) {
        if (this.getCurrentCastingTime() > 0 || !this.canEvadeSource(source)) {
            return false;
        }
        return this.teleportAI.canTeleport() || !this.teleportAI.isTeleporting() && this.field_70146_Z.nextFloat() < this.getTelevadeChance();
    }

    protected boolean canEvadeSource(DamageSource source) {
        return source.func_76346_g() != null;
    }

    protected float getTelevadeChance() {
        return 0.5f;
    }

    @Override
    public boolean canContinueCasting() {
        ZSSEntityInfo info = ZSSEntityInfo.get((EntityLivingBase)this);
        if (info.isBuffActive(Buff.STUN)) {
            if (this.field_70170_p.field_73012_v.nextInt(50) > info.getBuffAmplifier(Buff.STUN)) {
                info.removeBuff(Buff.STUN);
            }
            return false;
        }
        return true;
    }

    @Override
    public int beginSpellCasting(EntityLivingBase target) {
        if (target == null) {
            return 0;
        }
        int castTime = this.getBaseCastingTime() - this.field_70170_p.field_73013_u.func_151525_a() * 10;
        castTime += (this.field_70146_Z.nextInt(castTime) - this.field_70146_Z.nextInt(castTime)) / 2;
        this.setMaxCastingTime(castTime);
        this.setCurrentCastingTime(castTime);
        return castTime;
    }

    @Override
    public void castPassiveSpell() {
    }

    @Override
    public void castRangedSpell(EntityLivingBase target, float range) {
        float difficulty = this.field_70170_p.field_73013_u.func_151525_a();
        EntityMagicSpell spell = new EntityMagicSpell(this.field_70170_p, (EntityLivingBase)this, target, 0.8f + 0.25f * difficulty, 14 - this.field_70170_p.field_73013_u.func_151525_a() * 4);
        spell.setType(this.getMagicType());
        spell.setArea(this.getSpellAoE());
        spell.setDamageBypassesArmor();
        spell.setDamage(this.getBaseSpellDamage() * difficulty);
        spell.setReflectChance(this.getReflectChance());
        WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:whoosh", 0.4f, 0.5f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)spell);
        }
        this.teleportAI.scheduleNextTeleport(this.field_70146_Z.nextInt(5) + this.field_70146_Z.nextInt(5) + 6);
    }

    @Override
    public void stopCasting() {
        this.setCurrentCastingTime(0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        int castTime = this.getCurrentCastingTime();
        if (!this.field_70170_p.field_72995_K && castTime > 0) {
            this.setCurrentCastingTime(--castTime);
            MagicType type = this.getMagicType();
            if (castTime % type.getSoundFrequency() == 0) {
                this.field_70170_p.func_72956_a((Entity)this, type.getMovingSound(), type.getSoundVolume(this.field_70146_Z) * 0.5f, type.getSoundPitch(this.field_70146_Z));
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa % 20 == 0 && !this.func_70814_o()) {
            this.func_70623_bb();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.teleportAI.invalidateBounds(256.0);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.func_70027_ad() && this.getMagicType() == MagicType.FIRE) {
            this.func_70066_B();
        }
        if (this.teleportAI.getTeleBounds() == null && this.func_70777_m() == null && ++this.noTargetTime > 400) {
            this.noTargetTime = 0;
            Entity player = this.func_70782_k();
            if (player instanceof EntityPlayer && !this.field_70170_p.field_72995_K && this.func_70685_l(player) && !((EntityPlayer)player).field_71075_bZ.field_75102_a) {
                this.func_70784_b(player);
                this.teleportAI.setTeleporting();
                for (int i = 0; i < 64 && !EntityAITeleport.teleportToEntity(this.field_70170_p, (EntityLivingBase)this, player, null, this.teleportAI.isGrounded); ++i) {
                }
            }
        }
    }

    protected void func_70069_a(float distance) {
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    protected void func_70600_l(int rarity) {
        ItemStack drop = this.getRareDrop(rarity, 4);
        if (drop != null) {
            this.func_70099_a(drop, 0.0f);
        }
    }

    private ItemStack getRareDrop(int rarity, int modifier) {
        if (rarity > 0) {
            return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal());
        }
        if (this.field_70146_Z.nextInt(8) == 0) {
            ItemStack book = new ItemStack(Items.field_151122_aG);
            EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)book, (int)(this.field_70146_Z.nextInt(8) + this.field_70146_Z.nextInt(8) + modifier));
            return book;
        }
        switch (this.getWizzrobeType()) {
            case FIRE_WIZ: {
                return new ItemStack(ZSSItems.arrowFire);
            }
            case ICE_WIZ: {
                return new ItemStack(ZSSItems.arrowIce);
            }
            case LIGHTNING_WIZ: {
                return new ItemStack(ZSSItems.arrowLight);
            }
        }
        return null;
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return 0.2f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        if (this.field_70146_Z.nextInt(10 - whip.ordinal()) == 0) {
            return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal());
        }
        return this.getRareDrop(0, 3 * (whip.ordinal() + 1));
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return true;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return true;
    }

    public boolean func_70601_bi() {
        return !this.field_70170_p.func_72935_r() && super.func_70601_bi() && this.field_70170_p.func_82737_E() > (long)Config.getTimeToSpawnWizzrobe();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.setTypeOnSpawn();
        return data;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("WizzrobeType", this.field_70180_af.func_75683_a(16));
        AxisAlignedBB box = this.teleportAI.getTeleBounds();
        if (box != null) {
            NBTTagCompound bounds = new NBTTagCompound();
            bounds.func_74780_a("minX", box.field_72340_a);
            bounds.func_74780_a("maxX", box.field_72336_d);
            bounds.func_74780_a("minY", box.field_72338_b);
            bounds.func_74780_a("maxY", box.field_72337_e);
            bounds.func_74780_a("minZ", box.field_72339_c);
            bounds.func_74780_a("maxZ", box.field_72334_f);
            compound.func_74782_a("teleBounds", (NBTBase)bounds);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_75692_b(16, (Object)compound.func_74771_c("WizzrobeType"));
        if (compound.func_74764_b("teleBounds")) {
            NBTTagCompound bounds = compound.func_74775_l("teleBounds");
            double minX = bounds.func_74769_h("minX");
            double maxX = bounds.func_74769_h("maxX");
            double minY = bounds.func_74769_h("minY");
            double maxY = bounds.func_74769_h("maxY");
            double minZ = bounds.func_74769_h("minZ");
            double maxZ = bounds.func_74769_h("maxZ");
            this.setTeleBounds(AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        }
    }

    public static enum WizzrobeType {
        FIRE_WIZ(MagicType.FIRE, BiomeType.FIERY),
        ICE_WIZ(MagicType.ICE, BiomeType.COLD),
        LIGHTNING_WIZ(MagicType.LIGHTNING, BiomeType.MOUNTAIN),
        WIND_WIZ(MagicType.WIND, BiomeType.FOREST);

        public final MagicType magicType;
        public final BiomeType favoredBiome;

        private WizzrobeType(MagicType type, BiomeType favoredBiome) {
            this.magicType = type;
            this.favoredBiome = favoredBiome;
        }
    }
}

