/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import zeldaswordskills.ref.Config;

public abstract class EntityNpcBase
extends EntityCreature
implements INpc {
    private int randomTickDivider;
    public Village villageObj;

    public EntityNpcBase(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_110163_bv();
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    protected abstract String getNameTagOnSpawn();

    private void setNameOnSpawn() {
        String name = this.getNameTagOnSpawn();
        if (name != null && name.length() > 0) {
            this.func_94058_c(name);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean func_110164_bC() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_85032_ar() {
        return Config.areNpcsInvulnerable();
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        if (--this.randomTickDivider <= 0) {
            this.field_70170_p.field_72982_D.func_75551_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.func_75577_a();
                this.func_110171_b(chunkcoordinates.field_71574_a, chunkcoordinates.field_71572_b, chunkcoordinates.field_71573_c, (int)((float)this.villageObj.func_75568_b() * 0.6f));
            }
            this.randomUpdateTick();
        }
        super.func_70629_bd();
    }

    protected void randomUpdateTick() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte flag) {
        switch (flag) {
            case 12: {
                this.generateRandomParticles("heart");
                break;
            }
            case 13: {
                this.generateRandomParticles("angryVillager");
                break;
            }
            case 14: {
                this.generateRandomParticles("happyVillager");
                break;
            }
            default: {
                super.func_70103_a(flag);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void generateRandomParticles(String particle) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    public void func_70604_c(EntityLivingBase entity) {
        super.func_70604_c(entity);
        if (this.villageObj != null && entity != null) {
            this.villageObj.func_75575_a(entity);
            if (entity instanceof EntityPlayer) {
                int rep = this.func_70631_g_() ? -3 : -1;
                this.villageObj.func_82688_a(entity.func_70005_c_(), rep);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.setNameOnSpawn();
        return data;
    }
}

