/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.api.entity.ISongTeacher;
import zeldaswordskills.entity.npc.EntityNpcBase;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.entity.player.quests.IQuest;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestMaskSales;
import zeldaswordskills.entity.player.quests.QuestMaskShop;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.SyncQuestPacket;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedChatDialogue;

public class EntityNpcMaskTrader
extends EntityNpcBase
implements INpcVillager,
ISongTeacher {
    private EntityPlayer customer;

    public EntityNpcMaskTrader(World world) {
        super(world);
    }

    public EntityPlayer getCustomer() {
        return this.customer;
    }

    public void setCustomer(EntityPlayer player) {
        this.customer = player;
    }

    @Override
    protected String getNameTagOnSpawn() {
        return "Happy Mask Salesman";
    }

    @Override
    protected void randomUpdateTick() {
        if (this.customer != null) {
            if (this.customer.field_71070_bA instanceof Container && this.func_70068_e((Entity)this.customer) > 16.0) {
                this.func_70661_as().func_75499_g();
            } else {
                this.customer = null;
            }
        }
    }

    protected String func_70639_aQ() {
        return "mob.villager.haggle";
    }

    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.func_70089_S() || player.func_70093_af()) {
            return false;
        }
        if (this.getCustomer() != null) {
            if (!this.field_70170_p.field_72995_K) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.merchant.busy", new Object[0]);
            }
            return true;
        }
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemInstrument) {
            return true;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.checkShopStatus(player, false, false)) {
            return true;
        }
        ZSSQuests quests = ZSSQuests.get(player);
        IQuest quest = quests.get(QuestMaskSales.class);
        if (quest == null) {
            quest = new QuestMaskSales();
            quests.add(quest);
        }
        if (QuestBase.checkQuestProgress(player, quest, QuestBase.DEFAULT_QUEST_HANDLER, this)) {
            return true;
        }
        if (quest.isComplete(player)) {
            Item mask = quests.getBorrowedMask();
            if (mask != null && stack != null && stack.func_77973_b() == mask) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.returning", new Object[0]);
            } else if (mask != null) {
                new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.mask_salesman.borrowed.0", new Object[]{mask.func_77653_i(new ItemStack(mask))}), new ChatComponentTranslation("chat.zss.npc.mask_salesman.borrowed.1", new Object[0])});
            } else {
                this.func_70642_aH();
                this.setCustomer(player);
                player.openGui((Object)ZSSMain.instance, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
        }
        return true;
    }

    @Override
    public Event.Result canInteractConvert(EntityPlayer player, EntityVillager villager) {
        if (villager.getClass() != EntityVillager.class || villager.func_70631_g_()) {
            return Event.Result.DEFAULT;
        }
        if (!villager.field_70170_p.field_72995_K) {
            this.checkShopStatus(player, true, false);
        }
        return Event.Result.DENY;
    }

    public boolean checkShopStatus(EntityPlayer player, boolean isVillager, boolean leftClick) {
        IQuest quest = this.getMaskQuest(player);
        if (!isVillager && quest.isComplete(player)) {
            return false;
        }
        if (!isVillager && ZSSPlayerInfo.get(player).getCurrentMaskStage() > 0) {
            quest.forceComplete(player, new Object[0]);
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new SyncQuestPacket(quest), (EntityPlayerMP)player);
                quest = ZSSQuests.get(player).get(QuestMaskSales.class);
                if (quest != null) {
                    PacketDispatcher.sendTo(new SyncQuestPacket(quest), (EntityPlayerMP)player);
                }
            }
            return false;
        }
        if (leftClick) {
            if (quest.complete(player, new Object[0])) {
                if (player instanceof EntityPlayerMP) {
                    PacketDispatcher.sendTo(new SyncQuestPacket(quest), (EntityPlayerMP)player);
                }
                return true;
            }
            return false;
        }
        IChatComponent hint = quest.getHint(player, new Object[0]);
        if (hint != null) {
            player.func_145747_a(hint);
        }
        return true;
    }

    @Override
    public Event.Result canLeftClickConvert(EntityPlayer player, EntityVillager villager) {
        if (!villager.field_70170_p.field_72995_K && villager.getClass() == EntityVillager.class && !villager.func_70631_g_() && this.getMaskQuest(player).complete(player, new Object[0])) {
            return Event.Result.ALLOW;
        }
        return Event.Result.DEFAULT;
    }

    private IQuest getMaskQuest(EntityPlayer player) {
        IQuest quest = ZSSQuests.get(player).get(QuestMaskShop.class);
        if (quest == null) {
            quest = new QuestMaskShop();
            ZSSQuests.get(player).add(quest);
        }
        return quest;
    }

    @Override
    public void onConverted(EntityPlayer player) {
    }

    @Override
    public ISongTeacher.TeachingResult getTeachingResult(ItemStack stack, EntityPlayer player) {
        if (!this.func_70089_S() || player.func_70093_af() || this.checkShopStatus(player, false, false)) {
            return null;
        }
        String deny = "chat.zss.npc.mask_salesman.ocarina.begin";
        ZSSQuests quests = ZSSQuests.get(player);
        if (!quests.hasCompleted(QuestMaskShop.class)) {
            deny = "chat.zss.npc.mask_salesman.ocarina.waiting";
        } else if (!quests.hasCompleted(QuestMaskSales.class)) {
            deny = "chat.zss.npc.mask_salesman.ocarina." + (quests.hasBegun(QuestMaskSales.class) ? "sell" : "help");
        } else {
            if (ZSSPlayerSongs.get(player).isSongKnown(ZeldaSongs.songHealing)) {
                return new ISongTeacher.TeachingResult(ZeldaSongs.songHealing, true, true);
            }
            if (((ItemInstrument)stack.func_77973_b()).getInstrument(stack) == ItemInstrument.Instrument.OCARINA_TIME) {
                if (!player.field_70170_p.field_72995_K) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.ocarina.complete", new Object[0]);
                }
                return new ISongTeacher.TeachingResult(ZeldaSongs.songHealing, false, true);
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            PlayerUtils.sendTranslatedChat(player, deny, new Object[0]);
        }
        return null;
    }
}

