/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.api.entity.IParryModifier;
import zeldaswordskills.entity.npc.EntityNpcBase;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;

public class EntityNpcOrca
extends EntityNpcBase
implements INpcVillager,
IParryModifier {
    private static final int MATCH_PLAYER_ID = 18;
    private static final int MATCH_INTERVAL = 3000;
    private long nextMatch;
    private int chatTimer;
    private int hitCounter;
    private boolean parryFlag;

    public EntityNpcOrca(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 0.6, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public Entity getMatchOpponent() {
        return this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(18));
    }

    private void setMatchOpponent(Entity entity) {
        this.field_70180_af.func_75692_b(18, (Object)(entity == null ? -1 : entity.func_145782_y()));
    }

    @Override
    protected String getNameTagOnSpawn() {
        return "Orca";
    }

    protected String func_70639_aQ() {
        return "mob.villager.haggle";
    }

    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    @Override
    public boolean func_85032_ar() {
        return false;
    }

    public void func_70069_a(float distance) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            Entity opponent = this.getMatchOpponent();
            if (this.field_70170_p.func_82737_E() < this.nextMatch) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.resting", true);
                return false;
            }
            if (opponent != null && opponent != player) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.in_match", true);
                return false;
            }
            if (source.func_76364_f() != player && !source.func_76355_l().equals("indirectSword") && !source.func_76355_l().equals("indirectCombo")) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.melee_only", false);
                return false;
            }
            if (player.func_110143_aJ() < 2.0f) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.low_health", true);
                return false;
            }
            if (this.func_70694_bm() == null) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.unarmed." + this.field_70170_p.field_73012_v.nextInt(3), true);
                this.func_70062_b(0, new ItemStack(Items.field_151041_m));
                return false;
            }
            if (!PlayerUtils.isHoldingWeapon(player)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.player_no_weapon", true);
                return false;
            }
            if (ZSSPlayerSkills.get(player).isSkillActive(SkillBase.armorBreak)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.armor_break", false);
            } else if (ZSSPlayerSkills.get(player).isSkillActive(SkillBase.endingBlow)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.ending_blow", false);
            } else if (ZSSPlayerSkills.get(player).isSkillActive(SkillBase.risingCut)) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.rising_cut", false);
            } else if (source.func_76355_l().equals("indirectSword") || source.func_76355_l().equals("indirectCombo")) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.ranged_sword", false);
            } else if (source.func_76355_l().equals("nonSword")) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.non_sword", false);
            } else {
                ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
                if (skills.getTargetingSkill() == null) {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.unskilled." + this.field_70170_p.field_73012_v.nextInt(3), false);
                } else if (skills.getTargetingSkill().getCurrentTarget() == this) {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.hit." + this.field_70170_p.field_73012_v.nextInt(4), false);
                } else {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.damage.wrong_target", false);
                }
            }
        }
        return super.func_70097_a(source, damage);
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            amount = DirtyEntityAccessor.getModifiedDamage((EntityLivingBase)this, source, amount);
            ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)source, (float)amount);
            this.hitCounter = 0;
        } else {
            super.func_70665_d(source, amount);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_110143_aJ() < 2.0f) {
            this.func_70604_c(null);
            this.sendTranslatedChat((EntityPlayer)entity, "chat.zss.npc.orca.match.victory." + this.field_70170_p.field_73012_v.nextInt(4), true);
        } else {
            if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f)) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    boolean isBlocking = PlayerUtils.isBlocking(player);
                    if (!isBlocking && ++this.hitCounter > 2) {
                        this.func_70604_c(null);
                        this.sendTranslatedChat(player, "chat.zss.npc.orca.match.victory." + this.field_70170_p.field_73012_v.nextInt(4), true);
                    } else {
                        this.func_70604_c((EntityLivingBase)player);
                        if (isBlocking) {
                            this.sendTranslatedChat(player, "chat.zss.npc.orca.match.attack.blocked." + this.field_70170_p.field_73012_v.nextInt(2), false);
                        } else {
                            this.sendTranslatedChat(player, "chat.zss.npc.orca.match.attack." + this.field_70170_p.field_73012_v.nextInt(4), false);
                        }
                    }
                    ICombo combo = ZSSPlayerSkills.get(player).getComboSkill();
                    if (!isBlocking && combo != null && combo.isComboInProgress()) {
                        combo.getCombo().endCombo(player);
                    }
                }
                int knockback = 0;
                if (entity instanceof EntityLivingBase && (knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity))) < 1 && entity instanceof EntityPlayer) {
                    knockback = 1;
                }
                if (knockback > 0) {
                    float f = (float)knockback * 0.5f;
                    double dx = -MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * f;
                    double dz = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * f;
                    entity.func_70024_g(dx, 0.1, dz);
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
                return true;
            }
            if (entity instanceof EntityPlayer && ZSSPlayerSkills.get((EntityPlayer)entity).isSkillActive(SkillBase.dodge)) {
                this.sendTranslatedChat((EntityPlayer)entity, "chat.zss.npc.orca.match.attack.dodged." + this.field_70170_p.field_73012_v.nextInt(2), false);
            }
        }
        return false;
    }

    @Override
    public void func_70604_c(EntityLivingBase entity) {
        EntityLivingBase prevTarget = this.func_70638_az();
        Village tmp = this.villageObj;
        this.villageObj = null;
        super.func_70604_c(entity);
        this.func_70624_b(entity);
        this.field_70717_bb = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        this.setMatchOpponent((Entity)this.field_70717_bb);
        this.villageObj = tmp;
        if (entity == null && prevTarget instanceof EntityPlayer) {
            this.nextMatch = this.field_70170_p.func_82737_E() + 3000L;
            if (this.field_70173_aa - this.func_142015_aE() > 99) {
                this.sendTranslatedChat((EntityPlayer)prevTarget, "chat.zss.npc.orca.match.timeout." + this.field_70170_p.field_73012_v.nextInt(3), true);
            }
        }
    }

    public void func_70636_d() {
        this.func_82168_bl();
        if (this.chatTimer > 0) {
            --this.chatTimer;
        }
        if (this.func_70638_az() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_70638_az();
            ICombo combo = ZSSPlayerSkills.get(player).getComboSkill();
            if (this.parryFlag) {
                this.parryFlag = false;
                if (this.func_70694_bm() == null) {
                    this.func_70604_c(null);
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.defeat.disarmed." + this.field_70170_p.field_73012_v.nextInt(3), true);
                } else {
                    this.sendTranslatedChat(player, "chat.zss.npc.orca.match.disarm_attempt." + this.field_70170_p.field_73012_v.nextInt(3), false);
                }
            } else if (combo != null && combo.isComboInProgress() && combo.getCombo().getConsecutiveHits() > 9) {
                this.func_70604_c(null);
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.defeat.combo." + this.field_70170_p.field_73012_v.nextInt(3), true);
            } else if (this.func_70694_bm() == null) {
                this.func_70604_c(null);
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.defeat.disarmed." + this.field_70170_p.field_73012_v.nextInt(3), true);
            } else if (this.field_70718_bc < 60 && !PlayerUtils.isHoldingWeapon(player)) {
                this.func_70604_c(null);
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.quit." + this.field_70170_p.field_73012_v.nextInt(4), true);
            } else if (this.field_70718_bc < 10) {
                this.sendTranslatedChat(player, "chat.zss.npc.orca.match.player_idle." + this.field_70170_p.field_73012_v.nextInt(3), false);
                this.field_70718_bc = 60;
            }
        }
        super.func_70636_d();
    }

    private void sendTranslatedChat(EntityPlayer player, String chat, boolean alwaysSend) {
        if (!this.field_70170_p.field_72995_K && (alwaysSend || this.field_70146_Z.nextInt(Math.max(1, this.chatTimer)) == 0)) {
            PlayerUtils.sendTranslatedChat(player, chat, new Object[0]);
            this.chatTimer = this.field_70170_p.field_73012_v.nextInt(20) + this.field_70170_p.field_73012_v.nextInt(20) + 20;
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        Entity opponent = this.getMatchOpponent();
        if (opponent != null) {
            if (opponent != player) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.orca.match.in_match", new Object[0]);
            }
            return false;
        }
        if (!player.field_70170_p.field_72995_K) {
            ItemStack stack = player.func_70694_bm();
            if (ZSSPlayerSkills.get(player).completedCrests()) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.orca.master." + player.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
            } else if (stack != null && stack.func_77973_b() instanceof ItemTreasure && stack.func_77960_j() == ItemTreasure.Treasures.KNIGHTS_CREST.ordinal()) {
                ZSSPlayerSkills.get(player).giveCrest();
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.orca.idle." + this.field_70146_Z.nextInt(5), new Object[0]);
            }
        }
        return true;
    }

    @Override
    public Event.Result canInteractConvert(EntityPlayer player, EntityVillager villager) {
        return Event.Result.DEFAULT;
    }

    @Override
    public Event.Result canLeftClickConvert(EntityPlayer player, EntityVillager villager) {
        if (!villager.field_70170_p.field_72995_K && villager.getClass() == EntityVillager.class && !villager.func_70631_g_()) {
            ItemStack stack = player.func_70694_bm();
            return stack != null && stack.func_77973_b() == ZSSItems.treasure && ItemTreasure.Treasures.byDamage(stack.func_77960_j()) == ItemTreasure.Treasures.KNIGHTS_CREST ? Event.Result.ALLOW : Event.Result.DEFAULT;
        }
        return Event.Result.DEFAULT;
    }

    @Override
    public void onConverted(EntityPlayer player) {
        PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
        ZSSPlayerSkills.get(player).giveCrest();
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.func_70062_b(0, new ItemStack(Items.field_151041_m));
        return data;
    }

    @Override
    public float getOffensiveModifier(EntityLivingBase entity, ItemStack stack) {
        this.parryFlag = true;
        return 0.5f;
    }

    @Override
    public float getDefensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74772_a("nextMatch", this.nextMatch);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.nextMatch = compound.func_74763_f("nextMatch");
    }
}

