/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.api.entity.ISongTeacher;
import zeldaswordskills.entity.npc.EntityNpcMerchantBase;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.entity.player.quests.IQuest;
import zeldaswordskills.entity.player.quests.IQuestHandler;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestLightArrows;
import zeldaswordskills.entity.player.quests.QuestMasterSword;
import zeldaswordskills.entity.player.quests.QuestPendants;
import zeldaswordskills.entity.player.quests.QuestZeldaTalk;
import zeldaswordskills.entity.player.quests.QuestZeldasLetter;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlayRecordPacket;
import zeldaswordskills.network.client.SyncQuestPacket;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class EntityNpcZelda
extends EntityNpcMerchantBase
implements INpcVillager,
IQuestHandler,
ISongTeacher {
    private static final ImmutableSet<Class<? extends IQuest>> QUEST_LIST = new ImmutableSet.Builder().add(QuestZeldaTalk.class).add(QuestPendants.class).add(QuestZeldasLetter.class).add(QuestMasterSword.class).add(QuestLightArrows.class).build();
    private static final MerchantRecipe lightArrows = new MerchantRecipe(new ItemStack(Items.field_151166_bC, 8), null, new ItemStack(ZSSItems.arrowLight));
    private int conversionTime;
    private UUID ocarinaOwnerId;
    private int[] songPos;

    public EntityNpcZelda(World world) {
        super(world);
    }

    @Override
    protected String getNameTagOnSpawn() {
        return "Princess Zelda";
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    @Override
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        MerchantRecipeList list = super.func_70934_b(player);
        if (list != null) {
            MerchantRecipeHelper.removeTrade(list, lightArrows, false, true);
            if (ZSSQuests.get(player).hasCompleted(QuestLightArrows.class)) {
                list.add(0, (Object)new MerchantRecipe(lightArrows.func_77394_a(), lightArrows.func_77396_b(), lightArrows.func_77397_d()));
            }
        }
        return list;
    }

    @Override
    protected void populateTradingList() {
        if (this.trades == null) {
            this.trades = new MerchantRecipeList();
        }
        this.updateTradingList();
    }

    @Override
    protected void updateTradingList() {
        if (this.trades != null && this.trades.isEmpty()) {
            this.trades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 2), new ItemStack(Items.field_151174_bG, 3)));
        }
    }

    @Override
    public void onQuestBegun(IQuest quest, EntityPlayer player) {
        if (quest instanceof QuestZeldaTalk) {
            this.onConverted(player);
        }
    }

    @Override
    public void onQuestChanged(IQuest quest, EntityPlayer player) {
    }

    @Override
    public void onQuestCompleted(IQuest quest, EntityPlayer player) {
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (!this.func_70089_S() || player.func_70093_af()) {
            return false;
        }
        if (this.func_70931_l_() != null) {
            if (!this.field_70170_p.field_72995_K) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.merchant.busy", new Object[0]);
            }
            return true;
        }
        if (this.conversionTime > 0) {
            return true;
        }
        ZSSQuests quests = ZSSQuests.get(player);
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemInstrument && (this.field_70170_p.field_72995_K || quests.hasBegun(QuestZeldaTalk.class))) {
            return true;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (quests.get(QuestZeldaTalk.class) == null) {
            quests.add(new QuestZeldaTalk());
        }
        for (Class clazz : QUEST_LIST) {
            IQuest quest = quests.get(clazz);
            if (quest == null || !QuestBase.checkQuestProgress(player, quest, this, new Object[0])) continue;
            return true;
        }
        this.updateTradingList();
        this.displayTradingGuiFor(player);
        return true;
    }

    @Override
    public Event.Result canInteractConvert(EntityPlayer player, EntityVillager villager) {
        IChatComponent hint;
        ItemStack stack;
        if (villager.getClass() != EntityVillager.class || villager.func_70631_g_()) {
            return Event.Result.DEFAULT;
        }
        ZSSQuests quests = ZSSQuests.get(player);
        QuestZeldaTalk quest = (QuestZeldaTalk)quests.get(QuestZeldaTalk.class);
        if (quest == null) {
            quest = new QuestZeldaTalk();
            quests.add(quest);
        }
        if ((stack = player.func_70694_bm()) != null && stack.func_77973_b() instanceof ItemInstrument && ((ItemInstrument)stack.func_77973_b()).getInstrument(stack) == ItemInstrument.Instrument.OCARINA_FAIRY) {
            if (player.field_70170_p.field_72995_K) {
                ZSSPlayerSongs.get((EntityPlayer)player).preventSongGui = true;
                return Event.Result.DENY;
            }
            if (quest.hasBegun(player)) {
                this.conversionTime = -1;
                return Event.Result.ALLOW;
            }
            if (quest.begin(player, new Object[0])) {
                return Event.Result.ALLOW;
            }
        }
        if (!quest.isComplete(player) && (hint = quest.getHint(player, new Object[0])) != null) {
            player.func_145747_a(hint);
            return Event.Result.DENY;
        }
        return Event.Result.DEFAULT;
    }

    @Override
    public Event.Result canLeftClickConvert(EntityPlayer player, EntityVillager villager) {
        return Event.Result.DEFAULT;
    }

    @Override
    public void onConverted(EntityPlayer player) {
        if (this.conversionTime < 0) {
            this.conversionTime = 0;
        } else {
            this.func_70932_a_(player);
            this.ocarinaOwnerId = player.func_110124_au();
            this.conversionTime = ZeldaSongs.songTime.getMinDuration() / 2;
            this.songPos = new int[]{MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)};
            PacketDispatcher.sendToAllAround(new PlayRecordPacket(ZeldaSongs.songTime.getSoundString(), this.songPos[0], this.songPos[1], this.songPos[2]), (Entity)this, 64.0);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.conversionTime > 0) {
            --this.conversionTime;
            if (this.conversionTime == 0) {
                EntityPlayer player;
                if (this.songPos != null) {
                    PacketDispatcher.sendToAllAround(new PlayRecordPacket(null, this.songPos[0], this.songPos[1], this.songPos[2]), (Entity)this, 64.0);
                    this.songPos = null;
                }
                if ((player = this.func_70931_l_()) == null) {
                    player = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                }
                if (!this.field_70170_p.field_72995_K && player != null) {
                    boolean isOwner;
                    boolean bl = isOwner = this.ocarinaOwnerId != null && player.func_110124_au().compareTo(this.ocarinaOwnerId) == 0;
                    if (player.func_70068_e((Entity)this) < 64.0) {
                        if (isOwner) {
                            IQuest quest = ZSSQuests.get(player).get(QuestZeldaTalk.class);
                            if (quest != null && quest.canComplete(player)) {
                                quest.complete(player, true);
                                PacketDispatcher.sendTo(new SyncQuestPacket(quest), (EntityPlayerMP)player);
                                this.ocarinaOwnerId = null;
                            }
                        } else {
                            PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.ocarina.wrong_player", new Object[0]);
                        }
                    } else if (isOwner) {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.ocarina.too_far", new Object[0]);
                    }
                }
                this.func_70932_a_(null);
            }
        }
    }

    @Override
    public ISongTeacher.TeachingResult getTeachingResult(ItemStack stack, EntityPlayer player) {
        if (!this.func_70089_S() || player.func_70093_af()) {
            return null;
        }
        String deny = null;
        ZSSQuests quests = ZSSQuests.get(player);
        if (!quests.hasCompleted(QuestZeldaTalk.class)) {
            return null;
        }
        if (!quests.hasBegun(QuestMasterSword.class)) {
            deny = "chat.zss.npc.zelda.song.not_ready";
        } else if (!quests.hasCompleted(QuestMasterSword.class)) {
            deny = "chat.zss.npc.zelda.master_sword.hint." + this.field_70146_Z.nextInt(3);
        } else if (((ItemInstrument)stack.func_77973_b()).getInstrument(stack).getPower() < 5) {
            deny = "chat.zss.npc.zelda.song.weak";
        }
        if (deny != null) {
            if (!player.field_70170_p.field_72995_K) {
                PlayerUtils.sendTranslatedChat(player, deny, new Object[0]);
            }
            return null;
        }
        return new ISongTeacher.TeachingResult(ZeldaSongs.songTime, true, true);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("conversionTime", this.conversionTime);
        if (this.ocarinaOwnerId != null) {
            compound.func_74778_a("OcarinaOwnerId", this.ocarinaOwnerId.toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.conversionTime = compound.func_74762_e("conversionTime");
        if (compound.func_150297_b("OcarinaOwnerId", 8)) {
            this.ocarinaOwnerId = UUID.fromString(compound.func_74779_i("OcarinaOwnerId"));
        }
    }
}

