/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.entity.npc.EntityNpcMaskTrader;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestMaskShop;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public final class QuestMaskSales
extends QuestBase {
    public static final ImmutableSet<Item> MASKS = new ImmutableSet.Builder().add((Object)ZSSItems.maskKeaton).add((Object)ZSSItems.maskSkull).add((Object)ZSSItems.maskSpooky).add((Object)ZSSItems.maskScents).add((Object)ZSSItems.maskCouples).add((Object)ZSSItems.maskBunny).build();
    private static final int NUM_STAGES = 3;
    private int currentStage;

    public QuestMaskSales() {
    }

    public QuestMaskSales(int stage) {
        this.set(64);
        this.currentStage = Math.min(MASKS.size() * 3, Math.max(0, stage));
        if (this.currentStage >= MASKS.size() * 3) {
            this.set(128);
        }
    }

    public static Item getMask(int i) {
        if (i < 0 || i >= MASKS.size()) {
            return null;
        }
        return (Item)MASKS.asList().get(i);
    }

    public Item getCurrentMask() {
        return QuestMaskSales.getMask(this.currentStage / 3);
    }

    public boolean hasSold(Item mask) {
        ImmutableList list = MASKS.asList();
        for (int i = 0; i < list.size(); ++i) {
            if (mask != list.get(i)) continue;
            return this.currentStage >= i * 3 + 2;
        }
        return false;
    }

    @Override
    public boolean canBegin(EntityPlayer player) {
        return super.canBegin(player) && ZSSQuests.get(player).hasCompleted(QuestMaskShop.class);
    }

    @Override
    protected boolean onBegin(EntityPlayer player, Object ... data) {
        if (data == null || data.length < 1 || !(data[0] instanceof EntityNpcMaskTrader)) {
            return false;
        }
        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.begin.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.begin.1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.begin.2", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.begin.3", new Object[0])});
        new TimedAddItem(player, new ItemStack(QuestMaskSales.getMask(0)), 4000);
        this.currentStage = 1;
        return true;
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return super.canComplete(player) && this.currentStage >= MASKS.size() * 3;
    }

    @Override
    protected boolean onComplete(EntityPlayer player, Object ... data) {
        if (data == null || data.length < 1 || !(data[0] instanceof EntityNpcMaskTrader)) {
            return false;
        }
        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.complete.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.complete.1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.complete.2", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.complete.3", new Object[0])});
        new TimedAddItem(player, new ItemStack(ZSSItems.maskTruth), 4000);
        ZSSQuests.get(player).setBorrowedMask(ZSSItems.maskTruth);
        player.func_71029_a((StatBase)ZSSAchievements.maskShop);
        return true;
    }

    @Override
    public void forceComplete(EntityPlayer player, Object ... data) {
        this.currentStage = MASKS.size() * 3;
        this.set(128);
        player.func_71029_a((StatBase)ZSSAchievements.maskShop);
    }

    @Override
    public boolean update(EntityPlayer player, Object ... data) {
        Item mask = this.getCurrentMask();
        if (data == null || data.length < 1) {
            return false;
        }
        if (data[0] instanceof EntityNpcMaskTrader) {
            switch (this.currentStage % 3) {
                case 0: {
                    new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.next.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.next.1", new Object[0])});
                    if (mask != null) {
                        new TimedAddItem(player, new ItemStack(mask), 2000);
                    }
                    ++this.currentStage;
                    return true;
                }
                case 1: {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.sales.pep." + player.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
                    return false;
                }
                case 2: {
                    int price;
                    int n = price = mask instanceof ItemMask ? ((ItemMask)mask).getBuyPrice() : 16;
                    if (PlayerUtils.consumeInventoryItem(player, Items.field_151166_bC, price)) {
                        PlayerUtils.playSound(player, "zeldaswordskills:cash_sale", 1.0f, 1.0f);
                        ++this.currentStage;
                        if (!this.complete(player, new Object[0])) {
                            PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.sales.paid", new Object[0]);
                        }
                    } else {
                        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.penniless.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.penniless.1", new Object[]{price})});
                    }
                    return true;
                }
            }
        } else if (data[0] instanceof ItemMask) {
            ItemMask sell = (ItemMask)data[0];
            if (this.hasSold((Item)sell)) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.sales.repeat." + (data.length > 1 ? "pushy." : "") + player.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
            } else if (sell == mask && this.currentStage % 3 == 1) {
                ++this.currentStage;
                player.func_70062_b(0, new ItemStack(Items.field_151166_bC, ((ItemMask)mask).getSellPrice()));
                PlayerUtils.playSound(player, "zeldaswordskills:cash_sale", 1.0f, 1.0f);
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.sales.sold." + player.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
                player.func_71029_a((StatBase)ZSSAchievements.maskSold);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.sales.later." + player.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public IChatComponent getHint(EntityPlayer player, Object ... data) {
        return null;
    }

    @Override
    public boolean requiresSync() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("currentStage", this.currentStage);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.currentStage = compound.func_74762_e("currentStage");
    }
}

