/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestPendants;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedChatDialogue;

public final class QuestZeldaTalk
extends QuestBase {
    private ItemStack ocarina;

    private boolean isFairyOcarina(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemInstrument && ((ItemInstrument)stack.func_77973_b()).getInstrument(stack) == ItemInstrument.Instrument.OCARINA_FAIRY;
    }

    @Override
    protected boolean onBegin(EntityPlayer player, Object ... data) {
        ItemStack stack = player.func_70694_bm();
        if (this.isFairyOcarina(stack)) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.ocarina.give", new Object[0]);
            this.ocarina = stack.func_77946_l();
            this.ocarina.field_77994_a = 1;
            --stack.field_77994_a;
            this.set(64);
            return true;
        }
        return false;
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return super.canComplete(player) && this.ocarina != null;
    }

    @Override
    protected boolean onComplete(EntityPlayer player, Object ... data) {
        PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
        if (player.func_70694_bm() == null) {
            player.func_70062_b(0, this.ocarina);
        } else {
            PlayerUtils.addItemToInventory(player, this.ocarina);
        }
        String chat = data != null && data.length > 0 && data[0] instanceof Boolean && (Boolean)data[0] != false ? "played" : "return";
        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.zelda.ocarina." + chat + ".0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.ocarina." + chat + ".1", new Object[0])});
        this.ocarina = null;
        ZSSQuests.get(player).add(new QuestPendants());
        return true;
    }

    @Override
    public void forceComplete(EntityPlayer player, Object ... data) {
        this.ocarina = null;
        this.set(128);
        ZSSQuests.get(player).add(new QuestPendants());
    }

    @Override
    public boolean update(EntityPlayer player, Object ... data) {
        return false;
    }

    @Override
    public IChatComponent getHint(EntityPlayer player, Object ... data) {
        if (!this.hasBegun(player) && rand.nextInt(8) < 3) {
            return new ChatComponentTranslation("chat.zss.npc.zelda.ocarina.hint." + rand.nextInt(4), new Object[0]);
        }
        return null;
    }

    @Override
    public boolean requiresSync() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.ocarina != null) {
            compound.func_74782_a("ocarina", (NBTBase)this.ocarina.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_150297_b("ocarina", 10)) {
            this.ocarina = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("OcarinaStack"));
        }
    }
}

