/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.INpc;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import zeldaswordskills.api.entity.NpcHelper;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.ai.IEntityTeleport;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.LeapingBlow;
import zeldaswordskills.util.PlayerUtils;

public class ZSSEntityEvents {
    @SubscribeEvent(receiveCanceled=true)
    public void onFall(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            ZSSPlayerSkills skills = info.getPlayerSkills();
            if (skills.isSkillActive(SkillBase.leapingBlow)) {
                ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(player, event.distance);
            }
            if (!event.isCanceled() && info.reduceFallAmount > 0.0f) {
                event.distance -= info.reduceFallAmount;
                info.reduceFallAmount = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onCreativeFall(PlayerFlyableFallEvent event) {
        ZSSPlayerSkills skills = ZSSPlayerSkills.get(event.entityPlayer);
        if (skills.isSkillActive(SkillBase.leapingBlow)) {
            ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(event.entityPlayer, event.distance);
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        ItemStack helm;
        if (event.entityLiving.func_70694_bm() != null && event.entityLiving.func_70694_bm().func_77973_b() == ZSSItems.rocsFeather) {
            event.entityLiving.field_70181_x = event.entityLiving.field_70181_x + (event.entityLiving.func_70051_ag() ? 0.3 : 0.15);
        }
        if (event.entityLiving.func_71124_b(1) != null && event.entityLiving.func_71124_b(1).func_77973_b() == ZSSItems.bootsPegasus) {
            event.entityLiving.field_70181_x += 0.15;
            if (event.entity instanceof EntityPlayer) {
                ZSSPlayerInfo.get((EntityPlayer)((EntityPlayer)event.entity)).reduceFallAmount += 1.0f;
            }
        }
        if ((helm = event.entityLiving.func_71124_b(4)) != null) {
            if (helm.func_77973_b() == ZSSItems.maskBunny) {
                event.entityLiving.field_70181_x += 0.3;
                if (event.entity instanceof EntityPlayer) {
                    ZSSPlayerInfo.get((EntityPlayer)((EntityPlayer)event.entity)).reduceFallAmount += 5.0f;
                }
            } else if (helm.func_77973_b() == ZSSItems.maskDeku) {
                event.entityLiving.field_70181_x += 0.3;
            }
        }
    }

    @SubscribeEvent
    public void onInteract(EntityInteractEvent event) {
        ItemStack helm;
        ItemStack stack = event.entityPlayer.func_70694_bm();
        if (event.target instanceof EntityVillager && Event.Result.DEFAULT != NpcHelper.convertVillager(event.entityPlayer, (EntityVillager)event.target, true)) {
            event.setCanceled(true);
        }
        if (!event.isCanceled() && stack != null && stack.func_77973_b() instanceof IRightClickEntity) {
            event.setCanceled(((IRightClickEntity)stack.func_77973_b()).onRightClickEntity(stack, event.entityPlayer, event.target));
        }
        if (!event.isCanceled() && event.target instanceof INpc && (helm = event.entityPlayer.func_82169_q(3)) != null && helm.func_77973_b() instanceof ItemMask) {
            event.setCanceled(((ItemMask)helm.func_77973_b()).onInteract(helm, event.entityPlayer, event.target));
        }
        if (!event.isCanceled() && stack != null && stack.func_77973_b() == Items.field_151069_bo && event.target.getClass() == EntityCow.class) {
            event.setCanceled(ZSSPlayerSongs.get(event.entityPlayer).milkLonLonCow(event.entityPlayer, (EntityCow)event.target));
        }
        if (!event.isCanceled() && event.target.getClass() == EntityVillager.class && "Cursed Man".equals(((EntityVillager)event.target).func_94057_bL())) {
            EntityVillager villager = (EntityVillager)event.target;
            if (stack == null || stack.func_77973_b() != ZSSItems.skulltulaToken && stack.func_77973_b() != Items.field_151057_cb) {
                int tokens = ZSSPlayerInfo.get(event.entityPlayer).getSkulltulaTokens();
                if (!villager.field_70170_p.field_72995_K) {
                    if (villager.func_70631_g_()) {
                        PlayerUtils.sendTranslatedChat(event.entityPlayer, "chat.zss.npc.cursed_man.child", new Object[0]);
                    } else if (tokens > 0) {
                        PlayerUtils.sendTranslatedChat(event.entityPlayer, "chat.zss.npc.cursed_man.amount", tokens);
                    } else {
                        PlayerUtils.sendTranslatedChat(event.entityPlayer, "chat.zss.npc.cursed_man." + event.entity.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerInfo.get(player).onUpdate();
            if (player.field_70181_x < -0.25) {
                boolean flag;
                boolean bl = flag = player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ZSSItems.rocsFeather;
                if (flag || player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() == ZSSItems.maskDeku) {
                    player.field_70181_x = -0.25;
                    player.field_70143_R = 0.0f;
                }
            }
        }
        if (event.entity instanceof EntityLivingBase) {
            ZSSEntityInfo.get((EntityLivingBase)event.entity).onUpdate();
        }
        if (event.entity instanceof EntityVillager) {
            ZSSVillagerInfo.get((EntityVillager)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        ZSSEntityInfo.get((EntityLivingBase)event.entityPlayer).copy(ZSSEntityInfo.get((EntityLivingBase)event.original));
        ZSSPlayerInfo.get(event.entityPlayer).copy(ZSSPlayerInfo.get(event.original));
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            ZSSEntityInfo.get((EntityLivingBase)((EntityPlayer)event.entity)).onJoinWorld();
            ZSSPlayerInfo.get((EntityPlayer)event.entity).onJoinWorld();
        }
        if (!event.entity.field_70170_p.field_72995_K) {
            if (event.entity.getClass() == EntityVillager.class) {
                EntityGoron.doVillagerSpawn((EntityVillager)event.entity, event.entity.field_70170_p);
            }
            if (!Config.areVanillaBuffsDisabled() && event.entity instanceof EntityLivingBase) {
                this.initBuffs((EntityLivingBase)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase && ZSSEntityInfo.get((EntityLivingBase)event.entity) == null) {
            ZSSEntityInfo.register((EntityLivingBase)event.entity);
        }
        if (event.entity instanceof EntityVillager && ZSSVillagerInfo.get((EntityVillager)event.entity) == null) {
            ZSSVillagerInfo.register((EntityVillager)event.entity);
        }
        if (event.entity instanceof EntityPlayer && ZSSPlayerInfo.get((EntityPlayer)event.entity) == null) {
            ZSSPlayerInfo.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void postTeleport(EntityAITeleport.PostEnderTeleport event) {
        EntityAITeleport.disruptTargeting(event.entityLiving);
        if (event.entity instanceof IEntityTeleport) {
            ((IEntityTeleport)event.entity).getTeleportAI().onPostTeleport(event.targetX, event.targetY, event.targetZ);
        }
    }

    private void initBuffs(EntityLivingBase entity) {
        if (!ZSSEntityInfo.get(entity).getActiveBuffs().isEmpty()) {
            return;
        }
        if (entity.func_70045_F()) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 75);
            ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_COLD, Integer.MAX_VALUE, 100);
        }
        if (entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            if (!entity.func_70045_F()) {
                ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_FIRE, Integer.MAX_VALUE, 50);
            }
            ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_HOLY, Integer.MAX_VALUE, 300);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 50);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 50);
        }
        if (entity instanceof EntityGolem) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 100);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
        }
        if (entity instanceof EntityWitch) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_MAGIC, Integer.MAX_VALUE, 75);
        }
        if (entity instanceof EntityWither) {
            ZSSEntityInfo.get(entity).removeBuff(Buff.WEAKNESS_COLD);
        }
    }
}

