/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IHandlePickup;
import zeldaswordskills.api.item.IHandleToss;
import zeldaswordskills.api.item.ILiftBlock;
import zeldaswordskills.api.item.ISmashBlock;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.mobs.EntityDarknut;
import zeldaswordskills.entity.mobs.EntityKeese;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ItemHeldBlock;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ZSSItemEvents {
    private static final Map<Class<? extends EntityLivingBase>, ItemStack> dropsList = new HashMap<Class<? extends EntityLivingBase>, ItemStack>();

    public ZSSItemEvents() {
        if (dropsList.isEmpty()) {
            ZSSItemEvents.init();
        }
    }

    private static void addDrop(Class<? extends EntityLivingBase> mobClass, SkillBase skill) {
        ItemStack stack = new ItemStack(ZSSItems.skillOrb, 1, (int)skill.getId());
        dropsList.put(mobClass, stack);
    }

    private static ItemStack getOrbDrop(EntityLivingBase mob, boolean isBoss) {
        if (dropsList.get(mob.getClass()) != null && mob.field_70170_p.field_73012_v.nextFloat() > Config.getChanceForRandomDrop()) {
            return dropsList.get(mob.getClass());
        }
        ItemStack orb = null;
        int id = mob.field_70170_p.field_73012_v.nextInt(SkillBase.getNumSkills());
        if (SkillBase.doesSkillExist(id) && SkillBase.getSkill(id).canDrop() && (dropsList.get(mob.getClass()) != null || isBoss || mob.field_70170_p.field_73012_v.nextFloat() < Config.getRandomMobDropChance())) {
            orb = id == SkillBase.bonusHeart.getId() ? new ItemStack(ZSSItems.heartPiece) : new ItemStack(ZSSItems.skillOrb, 1, id);
        }
        return orb;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            ItemStack orb;
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            EntityLivingBase mob = event.entityLiving;
            boolean isBoss = mob instanceof IBossDisplayData;
            boolean flag = ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.mortalDraw) == SkillBase.mortalDraw.getMaxLevel();
            ItemStack itemStack = orb = isBoss && !flag ? new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.mortalDraw.getId()) : ZSSItemEvents.getOrbDrop(mob, isBoss);
            if (orb != null && Config.areOrbDropsEnabled()) {
                ItemStack helm = player.func_82169_q(3);
                float f = helm != null && helm.func_77973_b() == ZSSItems.maskTruth ? 0.01f : 0.0f;
                float baseChance = Config.getDropChance(orb.func_77973_b() == ZSSItems.heartPiece ? SkillBase.bonusHeart.getId() : orb.func_77960_j());
                if (baseChance > 0.0f && (isBoss || mob.field_70170_p.field_73012_v.nextFloat() < baseChance + f + 0.005f * (float)event.lootingLevel)) {
                    event.drops.add(new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, orb.func_77946_l()));
                    mob.field_70170_p.func_72908_a(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, "zeldaswordskills:special_drop", 1.0f, 1.0f);
                    player.func_71029_a((StatBase)ZSSAchievements.skillGain);
                    if (isBoss) {
                        player.func_71029_a((StatBase)ZSSAchievements.skillMortal);
                    }
                }
            }
            if (mob instanceof EntityCreeper && mob.field_70170_p.field_73012_v.nextFloat() < Config.getCreeperDropChance()) {
                event.drops.add(new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, new ItemStack(ZSSItems.bomb)));
            }
            if (mob instanceof IMob && mob.field_70170_p.field_73012_v.nextInt(Config.getPowerDropRate()) == 0) {
                event.drops.add(new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, new ItemStack(ZSSItems.powerPiece)));
            }
            if (mob instanceof IMob) {
                int consumable_chance;
                float hp = mob.func_110138_aP();
                float chance = MathHelper.func_76131_a((float)((hp - 40.0f) / 100.0f), (float)0.0f, (float)0.25f);
                if (hp > 100.0f) {
                    chance = MathHelper.func_76131_a((float)(chance + (hp - 100.0f) / 2000.0f), (float)0.0f, (float)0.5f);
                }
                if (mob.field_70170_p.field_73012_v.nextFloat() < chance) {
                    event.drops.add(new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, new ItemStack(ZSSItems.magicJarBig)));
                }
                if ((consumable_chance = Config.getMobConsumableFrequency()) > 0 && mob.field_70170_p.field_73012_v.nextInt((event.drops.size() + 1) * (12 - consumable_chance)) == 0) {
                    ItemStack stack = new ItemStack(mob.field_70170_p.field_73012_v.nextInt(4) == 0 ? ZSSItems.magicJar : ZSSItems.smallHeart);
                    event.drops.add(new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, stack));
                }
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean left = event.left.func_77973_b() instanceof ItemEnchantedBook && event.right.func_77973_b().func_77619_b() < 1 && (Config.areUnenchantablesDisabled() || event.right.func_77973_b() instanceof IUnenchantable);
        boolean right = event.right.func_77973_b() instanceof ItemEnchantedBook && event.left.func_77973_b().func_77619_b() < 1 && (Config.areUnenchantablesDisabled() || event.left.func_77973_b() instanceof IUnenchantable);
        event.setCanceled(left || right);
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null) {
            if (event.block == Blocks.field_150346_d || event.block == Blocks.field_150349_c) {
                if (event.harvester.func_82169_q(3) != null && event.harvester.func_82169_q(3).func_77973_b() == ZSSItems.maskScents && event.world.field_73012_v.nextInt(32) == 0) {
                    event.drops.add(event.world.field_73012_v.nextInt(4) == 0 ? new ItemStack((Block)Blocks.field_150337_Q) : new ItemStack((Block)Blocks.field_150338_P));
                }
            } else if (event.block == Blocks.field_150329_H) {
                if (PlayerUtils.isSword(event.harvester.func_70694_bm()) && event.world.field_73012_v.nextFloat() < Config.getGrassDropChance()) {
                    event.drops.add(ZSSItems.getRandomGrassDrop(event.world.field_73012_v));
                }
            } else if (event.block == Blocks.field_150366_p && event.world.field_73012_v.nextFloat() < 0.005f * (float)event.fortuneLevel) {
                event.drops.add(new ItemStack(ZSSItems.masterOre));
                event.harvester.field_70170_p.func_72908_a(event.harvester.field_70165_t, event.harvester.field_70163_u, event.harvester.field_70161_v, "zeldaswordskills:special_drop", 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        EntityItem item = event.entityItem;
        ItemStack stack = item.func_92059_d();
        if (stack != null) {
            TileEntityDungeonCore core;
            if (stack.func_77973_b() instanceof IHandleToss) {
                ((IHandleToss)stack.func_77973_b()).onItemTossed(item, event.player);
            }
            if (!item.field_70128_L && (stack.func_77973_b() == Items.field_151166_bC || stack.func_77973_b() instanceof IFairyUpgrade && ((IFairyUpgrade)stack.func_77973_b()).hasFairyUpgrade(stack)) && (core = WorldUtils.getNearbyFairySpawner(item.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, true)) != null) {
                core.scheduleItemUpdate(event.player);
            }
        }
        event.setCanceled(item.field_70128_L);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.item.func_92059_d();
        EntityPlayer player = event.entityPlayer;
        if (stack != null && stack.func_77973_b() instanceof IHandlePickup) {
            int size = stack.field_77994_a;
            if (((IHandlePickup)stack.func_77973_b()).onPickupItem(stack, player)) {
                if (stack.field_77994_a < size) {
                    FMLCommonHandler.instance().firePlayerItemPickupEvent(player, event.item);
                    event.item.func_85030_a("random.pop", 0.2f, ((event.item.field_70170_p.field_73012_v.nextFloat() - event.item.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    player.func_71001_a((Entity)event.item, size - stack.field_77994_a);
                }
                if (stack.field_77994_a <= 0) {
                    event.item.func_70106_y();
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        ItemStack stack = event.entityPlayer.func_70694_bm();
        switch (event.action) {
            case LEFT_CLICK_BLOCK: {
                if (stack == null || !(stack.func_77973_b() instanceof ISmashBlock) || event.entityPlayer.field_70724_aR != 0 || !this.blockWasSmashed(event.entityPlayer.field_70170_p, event.entityPlayer, stack, event.x, event.y, event.z, event.face)) break;
                if (event.entityPlayer instanceof EntityPlayerMP) {
                    ZSSCombatEvents.setPlayerAttackTime(event.entityPlayer);
                    PacketDispatcher.sendTo(new UnpressKeyPacket(-100), (EntityPlayerMP)event.entityPlayer);
                }
                event.useBlock = Event.Result.DENY;
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                if (stack == null || !(stack.func_77973_b() instanceof ILiftBlock) || !this.blockWasLifted(event.entityPlayer.field_70170_p, event.entityPlayer, stack, event.x, event.y, event.z, event.face)) break;
                event.useBlock = Event.Result.DENY;
                break;
            }
        }
    }

    private boolean blockWasLifted(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        if (player.func_82247_a(x, y, z, side, stack) || block instanceof ILiftable) {
            float resistance;
            boolean isValidBlock;
            int meta = world.func_72805_g(x, y, z);
            boolean isLiftable = block instanceof ILiftable;
            boolean bl = isValidBlock = (block.func_149662_c() || block instanceof BlockBreakable) && Item.func_150898_a((Block)block) != null;
            BlockWeight weight = isLiftable ? ((ILiftable)block).getLiftWeight(player, stack, meta, side) : (Config.canLiftVanilla() ? null : BlockWeight.IMPOSSIBLE);
            float strength = ((ILiftBlock)stack.func_77973_b()).getLiftStrength((EntityPlayer)player, (ItemStack)stack, (Block)block, (int)meta).weight;
            float f = resistance = weight != null ? weight.weight : block.getExplosionResistance(null, world, x, y, z, (double)x, (double)y, (double)z) * 5.0f / 3.0f;
            if (isValidBlock && weight != BlockWeight.IMPOSSIBLE && strength >= resistance && (isLiftable || !block.hasTileEntity(meta))) {
                if (!world.field_72995_K) {
                    ItemStack returnStack = ((ILiftBlock)stack.func_77973_b()).onLiftBlock(player, stack, block, meta);
                    if (returnStack != null && returnStack.field_77994_a <= 0) {
                        returnStack = null;
                    }
                    ItemStack heldBlock = ItemHeldBlock.getBlockStack(block, meta, returnStack);
                    if (isLiftable) {
                        ((ILiftable)block).onLifted(world, player, heldBlock, x, y, z, meta);
                    }
                    player.func_70062_b(0, heldBlock);
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                    world.func_147468_f(x, y, z);
                }
                return true;
            }
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:grunt", 0.3f, 0.8f);
        }
        return false;
    }

    private boolean blockWasSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        boolean isSmashable = block instanceof ISmashable;
        Event.Result smashResult = Event.Result.DEFAULT;
        boolean wasDestroyed = false;
        if (player.func_82247_a(x, y, z, side, stack) || isSmashable) {
            int meta = world.func_72805_g(x, y, z);
            BlockWeight weight = isSmashable ? ((ISmashable)block).getSmashWeight(player, stack, meta, side) : (Config.canSmashVanilla() || this.isVanillaBlockSmashable(block) ? null : BlockWeight.IMPOSSIBLE);
            float strength = ((ISmashBlock)stack.func_77973_b()).getSmashStrength((EntityPlayer)player, (ItemStack)stack, (Block)block, (int)meta).weight;
            float resistance = weight != null ? weight.weight : block.getExplosionResistance(null, world, x, y, z, (double)x, (double)y, (double)z) * 5.0f / 3.0f;
            Event.Result result = smashResult = isSmashable ? ((ISmashable)block).onSmashed(world, player, stack, x, y, z, side) : smashResult;
            if (smashResult == Event.Result.DEFAULT) {
                boolean isValidBlock;
                boolean bl = isValidBlock = block.func_149662_c() || block instanceof BlockBreakable;
                if (isValidBlock && weight != BlockWeight.IMPOSSIBLE && strength >= resistance && (!block.hasTileEntity(meta) || isSmashable)) {
                    if (!(block instanceof BlockBreakable)) {
                        world.func_72956_a((Entity)player, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
                    }
                    if (!world.field_72995_K) {
                        world.func_147480_a(x, y, z, false);
                    }
                    wasDestroyed = true;
                }
            }
            ((ISmashBlock)stack.func_77973_b()).onBlockSmashed(player, stack, block, meta, smashResult == Event.Result.ALLOW || wasDestroyed);
        }
        return smashResult == Event.Result.ALLOW || wasDestroyed;
    }

    private boolean isVanillaBlockSmashable(Block block) {
        return block.func_149688_o() == Material.field_151592_s || block.func_149688_o() == Material.field_151588_w;
    }

    private static void init() {
        ZSSItemEvents.addDrop(EntityCreeper.class, SkillBase.armorBreak);
        ZSSItemEvents.addDrop(EntityIronGolem.class, SkillBase.armorBreak);
        ZSSItemEvents.addDrop(EntitySilverfish.class, SkillBase.dash);
        ZSSItemEvents.addDrop(EntityHorse.class, SkillBase.dash);
        ZSSItemEvents.addDrop(EntityEnderman.class, SkillBase.dodge);
        ZSSItemEvents.addDrop(EntityKeese.class, SkillBase.dodge);
        ZSSItemEvents.addDrop(EntitySpider.class, SkillBase.endingBlow);
        ZSSItemEvents.addDrop(EntityCaveSpider.class, SkillBase.leapingBlow);
        ZSSItemEvents.addDrop(EntityMagmaCube.class, SkillBase.leapingBlow);
        ZSSItemEvents.addDrop(EntityPigZombie.class, SkillBase.parry);
        ZSSItemEvents.addDrop(EntityOcelot.class, SkillBase.parry);
        ZSSItemEvents.addDrop(EntityOctorok.class, SkillBase.risingCut);
        ZSSItemEvents.addDrop(EntityBlaze.class, SkillBase.spinAttack);
        ZSSItemEvents.addDrop(EntityDarknut.class, SkillBase.spinAttack);
        ZSSItemEvents.addDrop(EntityZombie.class, SkillBase.swordBasic);
        ZSSItemEvents.addDrop(EntitySkeleton.class, SkillBase.swordBasic);
        ZSSItemEvents.addDrop(EntityGhast.class, SkillBase.swordBeam);
        ZSSItemEvents.addDrop(EntityWitch.class, SkillBase.swordBeam);
        ZSSItemEvents.addDrop(EntityWizzrobe.class, SkillBase.swordBreak);
    }
}

