/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.InLiquidPacket;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemArmorBoots
extends ItemArmor
implements IUnenchantable {
    private final String resourceLocation;

    public ItemArmorBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
        super(material, renderIndex, 3);
        this.resourceLocation = resourceLocation;
        this.func_77656_e(0);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityVillager && !player.field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() == 3 && trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 16));
                if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.1", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        if (!info.getFlag((byte)1)) {
            info.setWearingBoots(stack);
        }
    }

    public final void applyModifiers(ItemStack stack, EntityPlayer player) {
        this.removeModifiers(stack, player);
        this.applyCustomModifiers(stack, player);
    }

    protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
    }

    public void removeModifiers(ItemStack stack, EntityPlayer player) {
    }

    public static boolean reverseMaterialAcceleration(World world, AxisAlignedBB aabb, Material material, Entity entity) {
        int j1;
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        if (!world.func_72904_c(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0)))) {
            return false;
        }
        boolean flag = false;
        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d0;
                    Block block = world.func_147439_a(k1, l1, i2);
                    if (block == null || block.func_149688_o() != material || !((double)l >= (d0 = (double)((float)(l1 + 1) - BlockLiquid.func_149801_b((int)world.func_72805_g(k1, l1, i2)))))) continue;
                    flag = true;
                    block.func_149640_a(world, k1, l1, i2, entity, vec3);
                }
            }
        }
        if (vec3.func_72433_c() > 0.0 && entity.func_96092_aw()) {
            vec3 = vec3.func_72432_b();
            double d1 = 0.014;
            entity.field_70159_w -= vec3.field_72450_a * d1;
            entity.field_70181_x -= vec3.field_72448_b * d1;
            entity.field_70179_y -= vec3.field_72449_c * d1;
            entity.field_70159_w *= 0.85;
            entity.field_70181_x *= 0.85;
            entity.field_70179_y *= 0.85;
        }
        return flag;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.resourceLocation;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip.zss." + this.func_77658_a().substring(9) + ".desc.0")));
    }

    public static class ItemRubberBoots
    extends ItemArmorBoots {
        public ItemRubberBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 50);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.RESIST_SHOCK);
        }
    }

    public static class ItemPegasusBoots
    extends ItemArmorBoots {
        private static final UUID pegasusBootsMoveBonusUUID = UUID.fromString("36A0FC05-50EB-460B-8961-615633A6D813");
        private static final AttributeModifier pegasusBootsMoveBonus = new AttributeModifier(pegasusBootsMoveBonusUUID, "Pegasus Boots Speed Bonus", 0.3, 2).func_111168_a(false);

        public ItemPegasusBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(pegasusBootsMoveBonus);
            ZSSPlayerInfo.get(player).setFlag((byte)8, true);
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.EVADE_UP, Integer.MAX_VALUE, 25);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(pegasusBootsMoveBonus);
            ZSSPlayerInfo.get(player).setFlag((byte)8, false);
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.EVADE_UP);
        }
    }

    public static class ItemHoverBoots
    extends ItemArmorBoots {
        public ItemHoverBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            boolean flag;
            super.onArmorTick(world, player, stack);
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            int i = MathHelper.func_76128_c((double)player.field_70165_t);
            int j = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)player.field_70161_v);
            Block block = world.func_147439_a(i, j - 1, k);
            boolean bl = flag = !block.func_149688_o().func_76230_c() || block.field_149765_K > 0.6f || block instanceof BlockSoulSand;
            if (flag && player.func_70051_ag() && player.field_70181_x < 0.0 && ++info.hoverTime < 40) {
                player.field_70163_u += -player.field_70181_x;
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                if (info.hoverTime % 3 == 0) {
                    world.func_72869_a("explode", player.field_70165_t, player.field_70163_u - 2.0, player.field_70161_v, -player.field_70159_w, player.field_70181_x, -player.field_70179_y);
                }
            } else if (info.hoverTime > 0) {
                info.hoverTime = 0;
                player.func_70031_b(false);
                if (world.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d()) {
                    KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151463_i(), (boolean)false);
                }
            }
        }
    }

    public static class ItemHeavyBoots
    extends ItemArmorBoots {
        private static final UUID heavyBootsKnockbackModifierUUID = UUID.fromString("71AF0F88-82E5-49DE-B9CC-844048E33D69");
        private static final AttributeModifier heavyBootsKnockbackModifier = new AttributeModifier(heavyBootsKnockbackModifierUUID, "Heavy Boots Knockback Resistance", 1.0, 0).func_111168_a(false);
        private static final UUID heavyBootsMovePenaltyUUID = UUID.fromString("B6C8CCB6-AE7B-4F14-908A-2F41BDB4D720");
        private static final AttributeModifier heavyBootsMovePenalty = new AttributeModifier(heavyBootsMovePenaltyUUID, "Heavy Boots Movement penalty", -0.6, 1).func_111168_a(false);

        public ItemHeavyBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            super.onArmorTick(world, player, stack);
            ItemArmorBoots.reverseMaterialAcceleration(world, player.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)player);
            if (!world.field_72995_K) {
                Material m1;
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)player.field_70165_t);
                Material m = world.func_147439_a(i, j = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)player.field_70161_v)).func_149688_o();
                if (m.func_76224_d()) {
                    PacketDispatcher.sendTo(new InLiquidPacket(m == Material.field_151587_i), (EntityPlayerMP)player);
                }
                if (((m1 = world.func_147439_a(i, j - 1, k).func_149688_o()) == Material.field_151592_s || m1 == Material.field_151588_w) && world.func_82737_E() % 2L == 0L && (!player.func_70093_af() && world.field_73012_v.nextFloat() < 0.15f || world.field_73012_v.nextFloat() < 0.01f)) {
                    world.func_147480_a(i, j - 1, k, false);
                }
            }
        }

        @Override
        protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(heavyBootsKnockbackModifier);
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(heavyBootsMovePenalty);
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.EVADE_DOWN, Integer.MAX_VALUE, 50);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(heavyBootsKnockbackModifier);
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(heavyBootsMovePenalty);
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.EVADE_DOWN);
        }
    }
}

