/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.CustomEntityList;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.item.ItemCustomEgg;

public class ItemCustomVariantEgg
extends ItemCustomEgg {
    private final Class<? extends Entity> classToSpawn;
    private final String entityName;

    public ItemCustomVariantEgg(Class<? extends Entity> classToSpawn, String entityName) {
        this.classToSpawn = classToSpawn;
        this.entityName = entityName;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String s = ("" + StatCollector.func_74838_a((String)"item.zss.spawn_egg.name")).trim();
        if (this.entityName != null) {
            s = s + " " + StatCollector.func_74838_a((String)("entity.zeldaswordskills." + this.entityName + ".name." + stack.func_77960_j()));
        }
        return s;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        List<Integer> colors = CustomEntityList.entityEggs.get(this.classToSpawn);
        int colorIndex = stack.func_77960_j() * 2;
        return colors != null && colors.size() > colorIndex + 1 ? colors.get(renderPass == 0 ? colorIndex : colorIndex + 1) : 0xFFFFFF;
    }

    @Override
    public Entity spawnCreature(World world, int subtype, double x, double y, double z) {
        Entity entity = null;
        if (CustomEntityList.entityEggs.containsKey(this.classToSpawn) && (entity = CustomEntityList.createEntity(this.classToSpawn, world)) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_110161_a((IEntityLivingData)null);
            if (entity instanceof IEntityVariant) {
                ((IEntityVariant)entity).setType(subtype);
            }
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        List<Integer> colors = CustomEntityList.entityEggs.get(this.classToSpawn);
        if (colors == null || colors.isEmpty()) {
            ZSSMain.logger.error("Custom entity egg has an empty color list");
            return;
        }
        if (colors.size() % 2 != 0) {
            ZSSMain.logger.error("Custom entity egg has an odd number of colors");
        }
        for (int i = 0; i < colors.size() / 2; ++i) {
            itemList.add(new ItemStack(item, 1, i));
        }
    }
}

