/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IZoomHelper;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.npc.EntityNpcMaskTrader;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.quests.IQuest;
import zeldaswordskills.entity.player.quests.QuestMaskSales;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.SyncQuestPacket;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedChatDialogue;

public class ItemMask
extends ItemArmor
implements IUnenchantable,
IZoomHelper {
    protected PotionEffect tickingEffect = null;
    private int buyPrice;
    private int sellPrice;

    public ItemMask(ItemArmor.ArmorMaterial material, int renderIndex) {
        super(material, renderIndex, 0);
        this.func_77656_e(0);
        this.func_77637_a(ZSSCreativeTabs.tabMasks);
    }

    public ItemMask setPrice(int buy, int sell) {
        this.buyPrice = buy;
        this.sellPrice = sell;
        return this;
    }

    public int getBuyPrice() {
        return this.buyPrice > 0 ? this.buyPrice : 16;
    }

    public int getSellPrice() {
        return this.sellPrice > 0 ? this.sellPrice : 16;
    }

    public ItemMask setEffect(PotionEffect effect) {
        this.tickingEffect = effect;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMagnificationFactor() {
        return 0.0f;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        if (!info.getFlag((byte)2)) {
            info.setWearingHelm(stack);
        }
        if (this.tickingEffect != null && world.func_82737_E() % 50L == 0L) {
            player.func_70690_d(new PotionEffect(this.tickingEffect));
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return String.format("%s:textures/armor/%s_layer_%d.png", "zeldaswordskills", this.func_77658_a().substring(9), slot == 2 ? 2 : 1);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (entity instanceof EntityNpcMaskTrader && ZSSQuests.get(player).hasCompleted(QuestMaskSales.class)) {
            if (this == ZSSQuests.get(player).getBorrowedMask()) {
                player.func_70062_b(0, null);
                ZSSQuests.get(player).setBorrowedMask(null);
                PlayerUtils.playSound(player, "random.pop", 1.0f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.returned", new Object[0]);
            }
        } else if (entity instanceof EntityVillager) {
            IQuest quest = ZSSQuests.get(player).get(QuestMaskSales.class);
            EntityVillager villager = (EntityVillager)entity;
            if (quest != null && ZSSVillagerInfo.get(villager).getMaskDesired() == this) {
                if (quest.update(player, this, true) && quest.requiresSync() && player instanceof EntityPlayerMP) {
                    PacketDispatcher.sendTo(new SyncQuestPacket(quest), (EntityPlayerMP)player);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.mask.refuse." + player.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
            }
        }
        return true;
    }

    public boolean onInteract(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            if (entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                if (entity.getClass() == EntityVillager.class && this == ZSSVillagerInfo.get(villager).getMaskDesired()) {
                    QuestMaskSales quest = (QuestMaskSales)ZSSQuests.get(player).get(QuestMaskSales.class);
                    if (!quest.hasSold((Item)this)) {
                        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.buyer.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.mask_salesman.sales.buyer.1", new Object[]{this.getSellPrice()})});
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.mask_salesman.sales.repeat." + player.field_70170_p.field_73012_v.nextInt(4), new Object[0]);
                    }
                } else {
                    int p = villager.func_70946_n();
                    String s = p < 0 || p > TradeHandler.EnumVillager.values().length ? "custom" : String.valueOf(p);
                    PlayerUtils.sendTranslatedChat(player, "chat." + this.func_77658_a().substring(5) + "." + s, new Object[0]);
                }
            } else if (entity instanceof EntityNpcMaskTrader) {
                PlayerUtils.sendTranslatedChat(player, "chat." + this.func_77658_a().substring(5) + ".salesman", new Object[0]);
            } else if (entity instanceof INpc) {
                PlayerUtils.sendTranslatedChat(player, "chat." + this.func_77658_a().substring(5) + ".custom", new Object[0]);
            } else {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
    }

    public final void applyModifiers(ItemStack stack, EntityPlayer player) {
        this.removeModifiers(stack, player);
        if (this.tickingEffect != null) {
            player.func_70690_d(new PotionEffect(this.tickingEffect));
        }
        this.applyCustomModifiers(stack, player);
    }

    protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
    }

    public void removeModifiers(ItemStack stack, EntityPlayer player) {
    }

    public void explode(EntityPlayer player, ItemStack stack, World world, double x, double y, double z) {
    }

    public static class ItemMaskMajora
    extends ItemMask {
        public ItemMaskMajora(ItemArmor.ArmorMaterial material, int renderIndex) {
            super(material, renderIndex);
        }

        @Override
        public void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.ATTACK_UP, Integer.MAX_VALUE, 100);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.ATTACK_UP);
        }
    }

    public static class ItemMaskHawkeye
    extends ItemMask {
        public ItemMaskHawkeye(ItemArmor.ArmorMaterial material, int renderIndex) {
            super(material, renderIndex);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getMagnificationFactor() {
            return 3.0f;
        }
    }

    public static class ItemMaskGoron
    extends ItemMask {
        public ItemMaskGoron(ItemArmor.ArmorMaterial material, int renderIndex) {
            super(material, renderIndex);
        }

        @Override
        public void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 100);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.RESIST_FIRE);
        }
    }

    public static class ItemMaskGiants
    extends ItemMask {
        public ItemMaskGiants(ItemArmor.ArmorMaterial material, int renderIndex) {
            super(material, renderIndex);
        }

        @Override
        public void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            DirtyEntityAccessor.setSize((Entity)player, player.field_70130_N * 3.0f, player.field_70131_O * 3.0f);
            if (player.field_70170_p.field_72995_K) {
                player.field_70138_W += 1.0f;
            }
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            if (player.getEntityData().func_74764_b("origWidth")) {
                DirtyEntityAccessor.restoreOriginalSize((Entity)player);
                if (player.field_70170_p.field_72995_K) {
                    player.field_70138_W -= 1.0f;
                }
            }
        }
    }

    public static class ItemMaskCouples
    extends ItemMask {
        public ItemMaskCouples(ItemArmor.ArmorMaterial material, int renderIndex) {
            super(material, renderIndex);
        }

        @Override
        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            super.onArmorTick(world, player, stack);
            if (world.func_82737_E() % 64L == 0L) {
                List villagers = world.func_72872_a(EntityVillager.class, player.field_70121_D.func_72314_b(8.0, 3.0, 8.0));
                for (EntityVillager villager : villagers) {
                    if (!(world.field_73012_v.nextFloat() < 0.5f)) continue;
                    ZSSVillagerInfo.get(villager).setMating();
                }
            }
        }
    }

    public static class ItemMaskBunny
    extends ItemMask {
        private static final UUID bunnyHoodMoveBonusUUID = UUID.fromString("8412C9F7-9645-4C24-8FD1-6EFB8282E822");
        private static final AttributeModifier bunnyHoodMoveBonus = new AttributeModifier(bunnyHoodMoveBonusUUID, "Bunny Hood Speed Bonus", 0.3, 2).func_111168_a(false);

        public ItemMaskBunny(ItemArmor.ArmorMaterial material, int renderIndex) {
            super(material, renderIndex);
        }

        @Override
        public void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(bunnyHoodMoveBonus);
            ZSSPlayerInfo.get(player).setFlag((byte)8, true);
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.EVADE_UP, Integer.MAX_VALUE, 25);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(bunnyHoodMoveBonus);
            ZSSPlayerInfo.get(player).setFlag((byte)8, true);
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.EVADE_UP);
        }
    }

    public static class ItemMaskBlast
    extends ItemMask {
        public ItemMaskBlast(ItemArmor.ArmorMaterial material, int renderIndex) {
            super(material, renderIndex);
        }

        @Override
        public void explode(EntityPlayer player, ItemStack stack, World world, double x, double y, double z) {
            if (player.field_71075_bZ.field_75098_d || !this.isCooling(world, stack)) {
                CustomExplosion.createExplosion(new EntityBomb(world), world, x, y, z, 3.0f, 10.0f, false);
                this.setNextUse(world, stack, 40);
            } else {
                world.func_72908_a(x, y, z, "random.click", 0.3f, 0.6f);
            }
        }

        private boolean isCooling(World world, ItemStack stack) {
            return stack.func_77942_o() && world.func_82737_E() < (long)stack.func_77978_p().func_74762_e("nextUse");
        }

        private void setNextUse(World world, ItemStack stack, int time) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74772_a("nextUse", world.func_82737_E() + (long)time);
        }
    }
}

