/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IZoom;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntitySeedShot;
import zeldaswordskills.item.ICyclableItem;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemSlingshot
extends Item
implements ICyclableItem,
IFairyUpgrade,
IUnenchantable,
IZoom {
    protected final int seedsFired;
    protected final float spread;
    private static final Map<Item, EntitySeedShot.SeedType> seedToType = new HashMap<Item, EntitySeedShot.SeedType>();
    private static final Map<EntitySeedShot.SeedType, Item> typeToSeed = new EnumMap<EntitySeedShot.SeedType, Item>(EntitySeedShot.SeedType.class);

    public static void initializeSeeds() {
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.BOMB, ZSSItems.bombFlowerSeed);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.COCOA, Items.field_151100_aR);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.DEKU, ZSSItems.dekuNut);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.GRASS, Items.field_151014_N);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.MELON, Items.field_151081_bc);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.NETHERWART, Items.field_151075_bm);
        ItemSlingshot.addSeedMapping(EntitySeedShot.SeedType.PUMPKIN, Items.field_151080_bb);
    }

    private static void addSeedMapping(EntitySeedShot.SeedType type, Item item) {
        seedToType.put(item, type);
        typeToSeed.put(type, item);
    }

    public ItemSlingshot() {
        this(1, 0.0f);
    }

    public ItemSlingshot(int seedsFired, float spread) {
        this.seedsFired = seedsFired;
        this.spread = spread;
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public Mode getMode(EntityPlayer player) {
        return Mode.values()[ZSSPlayerInfo.get((EntityPlayer)player).slingshotMode % Mode.values().length];
    }

    private void setMode(EntityPlayer player, Mode mode) {
        ZSSPlayerInfo.get((EntityPlayer)player).slingshotMode = mode.ordinal();
    }

    @Override
    public void nextItemMode(ItemStack stack, EntityPlayer player) {
        if (!player.func_71039_bw()) {
            this.setMode(player, this.getMode(player).next());
        }
    }

    @Override
    public void prevItemMode(ItemStack stack, EntityPlayer player) {
        if (!player.func_71039_bw()) {
            this.setMode(player, this.getMode(player).prev());
        }
    }

    @Override
    public int getCurrentMode(ItemStack stack, EntityPlayer player) {
        return this.getMode(player).ordinal();
    }

    @Override
    public void setCurrentMode(ItemStack stack, EntityPlayer player, int mode) {
        this.setMode(player, Mode.values()[mode % Mode.values().length]);
    }

    @Override
    public ItemStack getRenderStackForMode(ItemStack stack, EntityPlayer player) {
        ItemStack ret = this.getMode(player).getSeedStack();
        if (ret != null) {
            ret.field_77994_a = 0;
            for (ItemStack inv : player.field_71071_by.field_70462_a) {
                if (inv == null || inv.func_77973_b() != ret.func_77973_b() || inv.func_77960_j() != ret.func_77960_j()) continue;
                ret.field_77994_a += inv.field_77994_a;
                if (ret.field_77994_a <= 98) continue;
                ret.field_77994_a = 99;
                break;
            }
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMaxZoomTime() {
        return 20.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getZoomFactor() {
        return 0.15f;
    }

    public int func_77619_b() {
        return 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.hasSeeds(player)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int ticksUsed) {
        int charge = this.func_77626_a(stack) - ticksUsed;
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        EntitySeedShot.SeedType type = this.getSeedType(player);
        if (f < 0.3f || type == EntitySeedShot.SeedType.NONE) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        for (int i = 0; i < this.seedsFired; ++i) {
            EntitySeedShot seedShot = new EntitySeedShot(world, (EntityLivingBase)player, f, i + 1, this.spread).setType(type);
            if (f == 1.0f) {
                seedShot.setIsCritical(true);
            }
            float factor = this.seedsFired == 1 ? 2.2f : (this.seedsFired < 4 ? 1.4f : 1.0f);
            float damage = type.getDamage();
            int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
            if (k > 0) {
                damage += (float)k * 0.25f + 0.25f;
            }
            seedShot.setDamage(damage * factor);
            int l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
            seedShot.setKnockback(l > 0 ? l : (type == EntitySeedShot.SeedType.MELON ? 1 : 0));
            if (type == EntitySeedShot.SeedType.NETHERWART || EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                seedShot.func_70015_d(100);
            }
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)seedShot);
        }
        world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        if (!player.field_71075_bZ.field_75098_d) {
            Item seed;
            PlayerUtils.consumeInventoryItem(player, seed, (seed = typeToSeed.get((Object)type)) == Items.field_151100_aR ? 3 : 0, 1);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 6 + 2 * this.seedsFired));
                if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.0", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    protected boolean hasSeeds(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.getSeedType(player) != EntitySeedShot.SeedType.NONE;
    }

    protected EntitySeedShot.SeedType getSeedType(EntityPlayer player) {
        EntitySeedShot.SeedType selected = this.getMode(player).type;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            EntitySeedShot.SeedType type;
            if (stack == null || !seedToType.containsKey(stack.func_77973_b()) || (type = seedToType.get(stack.func_77973_b())) == EntitySeedShot.SeedType.COCOA && stack.func_77960_j() != 3 || selected != null && type != selected) continue;
            return type;
        }
        return player.field_71075_bZ.field_75098_d ? (selected == null ? EntitySeedShot.SeedType.GRASS : selected) : EntitySeedShot.SeedType.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        ItemStack mode;
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.slingshot.desc.0"));
        if (this.seedsFired > 1) {
            list.add(EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"tooltip.zss.slingshot.desc.1", (Object[])new Object[]{this.seedsFired}));
        }
        if ((mode = this.getMode(player).getSeedStack()) != null) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tooltip.zss.mode", (Object[])new Object[]{mode.func_82833_r()}));
        }
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        ItemStack stack = item.func_92059_d();
        if (stack.func_77973_b() == ZSSItems.slingshot && core.consumeRupees(Config.getSlingshotCostOne())) {
            item.func_70106_y();
            player.func_71029_a((StatBase)ZSSAchievements.fairySlingshot);
            WorldUtils.spawnItemWithRandom(core.func_145831_w(), new ItemStack(ZSSItems.scattershot), core.field_145851_c, core.field_145848_d + 2, core.field_145849_e);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else if (stack.func_77973_b() == ZSSItems.scattershot && core.consumeRupees(Config.getSlingshotCostTwo())) {
            item.func_70106_y();
            player.func_71029_a((StatBase)ZSSAchievements.fairySupershot);
            WorldUtils.spawnItemWithRandom(core.func_145831_w(), new ItemStack(ZSSItems.supershot), core.field_145851_c, core.field_145848_d + 2, core.field_145849_e);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            this.addFairyEnchantments(stack, player, core);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return true;
    }

    private void addFairyEnchantments(ItemStack stack, EntityPlayer player, TileEntityDungeonCore core) {
        int newLvl;
        byte hearts = ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.bonusHeart);
        int divisor = this.seedsFired == 1 ? 5 : (this.seedsFired < 4 ? 7 : 10);
        int lvl = newLvl = Math.min(hearts / divisor, Enchantment.field_77345_t.func_77325_b());
        boolean flag = false;
        boolean playSound = false;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("ench")) {
            NBTTagList enchList = (NBTTagList)stack.func_77978_p().func_74781_a("ench");
            for (int i = 0; i < enchList.func_74745_c(); ++i) {
                NBTTagCompound compound = enchList.func_150305_b(i);
                if (compound.func_74765_d("id") != Enchantment.field_77345_t.field_77352_x) continue;
                short oldLvl = compound.func_74765_d("lvl");
                for (lvl = newLvl - oldLvl; lvl > 0 && core.consumeRupees(divisor * 2); --lvl) {
                }
                if ((newLvl -= lvl) > oldLvl) {
                    enchList.func_74744_a(i);
                    stack.func_77966_a(Enchantment.field_77345_t, newLvl);
                    playSound = true;
                }
                flag = true;
                break;
            }
        }
        if (!flag) {
            while (lvl > 0 && core.consumeRupees(divisor * 2)) {
                --lvl;
            }
            if ((newLvl -= lvl) > 0) {
                playSound = true;
                stack.func_77966_a(Enchantment.field_77345_t, newLvl);
            }
        }
        if (playSound) {
            player.func_71029_a((StatBase)ZSSAchievements.fairyEnchantment);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_blessing", 1.0f, 1.0f);
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    public static enum Mode {
        DEFAULT(null),
        DEKU(EntitySeedShot.SeedType.DEKU),
        BOMB(EntitySeedShot.SeedType.BOMB),
        COCOA(EntitySeedShot.SeedType.COCOA),
        GRASS(EntitySeedShot.SeedType.GRASS),
        MELON(EntitySeedShot.SeedType.MELON),
        PUMPKIN(EntitySeedShot.SeedType.PUMPKIN),
        NETHERWART(EntitySeedShot.SeedType.NETHERWART);

        private ItemStack seedStack;
        private final EntitySeedShot.SeedType type;

        private Mode(EntitySeedShot.SeedType type) {
            this.type = type;
        }

        public ItemStack getSeedStack() {
            Item item;
            if (this.type != null && (item = (Item)typeToSeed.get((Object)this.type)) != null) {
                this.seedStack = new ItemStack(item, 1, item == Items.field_151100_aR ? 3 : 0);
            }
            return this.seedStack;
        }

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode prev() {
            return Mode.values()[((this.ordinal() == 0 ? Mode.values().length : this.ordinal()) - 1) % Mode.values().length];
        }
    }
}

