/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemWhip
extends Item
implements IFairyUpgrade {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemWhip() {
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
    }

    public IWhipBlock.WhipType getType(ItemStack stack) {
        return this.getType(stack.func_77960_j());
    }

    public IWhipBlock.WhipType getType(int damage) {
        return damage > -1 ? IWhipBlock.WhipType.values()[damage % IWhipBlock.WhipType.values().length] : IWhipBlock.WhipType.WHIP_SHORT;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 32000;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        EntityWhip whip = new EntityWhip(player.field_70170_p, (EntityLivingBase)player);
        whip.setThrower(player);
        whip.setType(this.getType(stack));
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72838_d((Entity)whip);
            player.field_70170_p.func_72956_a((Entity)player, "zeldaswordskills:whip", 0.4f, 1.0f);
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity.getClass() == EntityVillager.class) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() == TradeHandler.EnumVillager.BUTCHER.ordinal() && trades != null) {
                switch (this.getType(stack)) {
                    case WHIP_SHORT: {
                        MerchantRecipe trade = new MerchantRecipe(new ItemStack((Item)this, 1, IWhipBlock.WhipType.WHIP_SHORT.ordinal()), new ItemStack(Items.field_151166_bC, 64), new ItemStack((Item)this, 1, IWhipBlock.WhipType.WHIP_LONG.ordinal()));
                        if (MerchantRecipeHelper.addUniqueTrade(trades, trade)) {
                            PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.upgrade.new", new Object[0]);
                            break;
                        }
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.upgrade.old", new Object[0]);
                        break;
                    }
                    case WHIP_LONG: {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.long", new Object[0]);
                        break;
                    }
                    case WHIP_MAGIC: {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.magic", new Object[0]);
                    }
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.sorry", new Object[0]);
            }
        } else if (!player.field_70170_p.field_72995_K && entity instanceof INpc) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.whip.sorry", new Object[0]);
        }
        return true;
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        if (this.getType(item.func_92059_d()) == IWhipBlock.WhipType.WHIP_LONG && core.consumeRupees(320)) {
            item.func_70106_y();
            WorldUtils.spawnItemWithRandom(core.func_145831_w(), new ItemStack(ZSSItems.whip, 1, IWhipBlock.WhipType.WHIP_MAGIC.ordinal()), core.field_145851_c, core.field_145848_d + 2, core.field_145849_e);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this.getType(stack) != IWhipBlock.WhipType.WHIP_MAGIC;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + stack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < IWhipBlock.WhipType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int type) {
        switch (this.getType(type)) {
            case WHIP_MAGIC: {
                return this.iconArray[1];
            }
        }
        return this.iconArray[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconArray = new IIcon[2];
        this.iconArray[0] = register.func_94245_a("zeldaswordskills:whip");
        this.iconArray[1] = register.func_94245_a("zeldaswordskills:whip_magic");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip.zss.whip.desc." + this.getType(stack).ordinal())));
    }
}

