/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.RecipeSorter;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.MagicType;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.client.render.item.RenderBigItem;
import zeldaswordskills.client.render.item.RenderHeldItemBlock;
import zeldaswordskills.client.render.item.RenderItemBomb;
import zeldaswordskills.client.render.item.RenderItemBombBag;
import zeldaswordskills.client.render.item.RenderItemCustomBow;
import zeldaswordskills.client.render.item.RenderItemDungeonBlock;
import zeldaswordskills.client.render.item.RenderItemShield;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.mobs.EntityDarknut;
import zeldaswordskills.entity.mobs.EntityKeese;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntitySeedShot;
import zeldaswordskills.entity.projectile.EntityThrowingRock;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemArmorBoots;
import zeldaswordskills.item.ItemArmorTunic;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ItemBombFlowerSeed;
import zeldaswordskills.item.ItemBoomerang;
import zeldaswordskills.item.ItemBrokenSword;
import zeldaswordskills.item.ItemBuilderSeed;
import zeldaswordskills.item.ItemChuJelly;
import zeldaswordskills.item.ItemCustomEgg;
import zeldaswordskills.item.ItemCustomVariantEgg;
import zeldaswordskills.item.ItemDekuLeaf;
import zeldaswordskills.item.ItemDoorBoss;
import zeldaswordskills.item.ItemDoorLocked;
import zeldaswordskills.item.ItemDrinkable;
import zeldaswordskills.item.ItemFairyBottle;
import zeldaswordskills.item.ItemHammer;
import zeldaswordskills.item.ItemHeldBlock;
import zeldaswordskills.item.ItemHeroBow;
import zeldaswordskills.item.ItemHookShot;
import zeldaswordskills.item.ItemHookShotUpgrade;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.item.ItemKeyBig;
import zeldaswordskills.item.ItemLonLonMilk;
import zeldaswordskills.item.ItemMagicMirror;
import zeldaswordskills.item.ItemMagicRod;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ItemMaskZora;
import zeldaswordskills.item.ItemMasterOre;
import zeldaswordskills.item.ItemMedallion;
import zeldaswordskills.item.ItemMiscZSS;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ItemPickupOnly;
import zeldaswordskills.item.ItemPowerGauntlets;
import zeldaswordskills.item.ItemSkillOrb;
import zeldaswordskills.item.ItemSlingshot;
import zeldaswordskills.item.ItemSpiritCrystal;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ItemWhip;
import zeldaswordskills.item.ItemZeldaArrow;
import zeldaswordskills.item.ItemZeldaPotion;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.item.crafting.RecipeCombineBombBag;
import zeldaswordskills.item.dispenser.BehaviorDispenseCustomMobEgg;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.world.gen.structure.LinksHouse;

public class ZSSItems {
    private static final Map<Item, Integer> itemList = new HashMap<Item, Integer>(256);
    private static int sortId = 0;
    private static final List<Item> addonItems = new ArrayList<Item>();
    private static Comparator<Item> itemComparator = new Comparator<Item>(){

        @Override
        public int compare(Item a, Item b) {
            if (itemList.containsKey(a) && itemList.containsKey(b)) {
                return (Integer)itemList.get(a) - (Integer)itemList.get(b);
            }
            ZSSMain.logger.warn("A mod item " + a.func_77658_a() + " or " + b.func_77658_a() + " is missing a comparator mapping");
            return GameData.getItemRegistry().getId((Object)a) - GameData.getItemRegistry().getId((Object)b);
        }
    };
    public static Comparator<ItemStack> itemstackComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack a, ItemStack b) {
            if (a.func_77973_b() == b.func_77973_b()) {
                if (a.func_77973_b() == skillOrb && (a.func_77960_j() == SkillBase.bonusHeart.getId() || b.func_77960_j() == SkillBase.bonusHeart.getId())) {
                    return a.func_77960_j() == SkillBase.bonusHeart.getId() ? 127 : -128;
                }
                return a.func_77960_j() - b.func_77960_j();
            }
            return itemComparator.compare(a.func_77973_b(), b.func_77973_b());
        }
    };
    private static boolean enableGrassArrowDrop;
    private static boolean enableGrassBombDrop;
    private static boolean enableGrassEmeraldDrop;
    private static boolean enableBombLoot;
    private static boolean enableBombBagLoot;
    private static boolean enableHeartLoot;
    private static boolean allowGoldSmelting;
    private static boolean enableCraftingHammer;
    private static boolean enableCraftingHookshot;
    private static boolean enableCraftingMudora;
    private static boolean enableCraftingThrowingRock;
    private static final List<ItemStack> grassDrops;
    public static final ItemArmor.ArmorMaterial WOOD;
    public static Item skillWiper;
    public static Item skillOrb;
    public static Item heartPiece;
    public static Item keyBig;
    public static Item keySmall;
    public static Item keySkeleton;
    public static Item bomb;
    public static Item bombBag;
    public static Item magicMirror;
    public static Item crystalSpirit;
    public static Item crystalDin;
    public static Item crystalFarore;
    public static Item crystalNayru;
    public static Item medallion;
    public static Item dekuLeaf;
    public static Item dekuNut;
    public static Item bombFlowerSeed;
    public static Item gauntletsSilver;
    public static Item gauntletsGolden;
    public static Item hookshot;
    public static Item hookshotAddon;
    public static Item whip;
    public static Item rodFire;
    public static Item rodIce;
    public static Item rodTornado;
    public static Item fairyBottle;
    public static Item potionRed;
    public static Item potionGreen;
    public static Item potionBlue;
    public static Item potionYellow;
    public static Item potionPurple;
    public static Item lonlonMilk;
    public static Item lonlonSpecial;
    public static Item magicJar;
    public static Item magicJarBig;
    public static Item magicContainer;
    public static Item rocsFeather;
    public static Item instrument;
    public static Item bookMudora;
    public static Item pendant;
    public static Item masterOre;
    public static Item jellyChu;
    public static Item treasure;
    public static Item skulltulaToken;
    public static Item linksHouse;
    public static Item doorLocked;
    public static Item doorLockedSmall;
    public static Item heldBlock;
    public static Item powerPiece;
    public static Item smallHeart;
    public static Item throwingRock;
    public static Item tunicHeroHelm;
    public static Item tunicHeroChest;
    public static Item tunicHeroLegs;
    public static Item tunicHeroBoots;
    public static Item tunicGoronHelm;
    public static Item tunicGoronChest;
    public static Item tunicGoronLegs;
    public static Item tunicZoraHelm;
    public static Item tunicZoraChest;
    public static Item tunicZoraLegs;
    public static Item tunicZoraBoots;
    public static Item bootsHeavy;
    public static Item bootsHover;
    public static Item bootsPegasus;
    public static Item bootsRubber;
    public static Item shieldDeku;
    public static Item shieldHylian;
    public static Item shieldMirror;
    public static Item swordBroken;
    public static Item swordKokiri;
    public static Item swordOrdon;
    public static Item swordGiant;
    public static Item swordBiggoron;
    public static Item swordMaster;
    public static Item swordTempered;
    public static Item swordGolden;
    public static Item swordMasterTrue;
    public static Item swordDarknut;
    public static Item hammer;
    public static Item hammerSkull;
    public static Item hammerMegaton;
    public static Item boomerang;
    public static Item boomerangMagic;
    public static Item slingshot;
    public static Item scattershot;
    public static Item supershot;
    public static Item heroBow;
    public static Item arrowBomb;
    public static Item arrowBombWater;
    public static Item arrowBombFire;
    public static Item arrowFire;
    public static Item arrowIce;
    public static Item arrowLight;
    public static Item maskBlast;
    public static Item maskBunny;
    public static Item maskCouples;
    public static Item maskGerudo;
    public static Item maskGiants;
    public static Item maskGibdo;
    public static Item maskHawkeye;
    public static Item maskKeaton;
    public static Item maskScents;
    public static Item maskSkull;
    public static Item maskSpooky;
    public static Item maskStone;
    public static Item maskTruth;
    public static Item maskDeku;
    public static Item maskGoron;
    public static Item maskZora;
    public static Item maskFierce;
    public static Item maskMajora;
    public static Item eggSpawner;
    public static Item eggChu;
    public static Item eggDarknut;
    public static Item eggKeese;
    public static Item eggOctorok;
    public static Item eggWizzrobe;

    public static void initConfig(Configuration config) {
        enableGrassArrowDrop = config.get("Drops", "Enable arrow drops from grass (must use sword)", true).getBoolean(true);
        enableGrassBombDrop = config.get("Drops", "Enable bomb drops from grass (must use sword)", false).getBoolean(false);
        enableGrassEmeraldDrop = config.get("Drops", "Enable emerald drops from grass (must use sword)", true).getBoolean(true);
        enableBombLoot = config.get("Loot", "Enable bombs in vanilla chests", false).getBoolean(false);
        enableBombBagLoot = config.get("Loot", "Enable bomb bags in vanilla chests", false).getBoolean(false);
        enableHeartLoot = config.get("Loot", "Enable heart pieces in vanilla chests", false).getBoolean(false);
        allowGoldSmelting = config.get("Recipes", "Smelt all those disarmed pigmen swords into gold ingots", false).getBoolean(false);
        enableCraftingHammer = config.get("Recipes", "Enable crafting of the Wooden Hammer used to bypass wooden pegs", true).getBoolean(true);
        enableCraftingHookshot = config.get("Recipes", "Enable application of hookshot upgrades via crafting", false).getBoolean(false);
        enableCraftingMudora = config.get("Recipes", "Enable crafting recipe to make copies of the Book of Mudora", true).getBoolean(true);
        enableCraftingThrowingRock = config.get("Recipes", "Enable crafting throwing rocks from cobblestone and back", false).getBoolean(false);
    }

    public static void preInit() {
        ZSSItems.initItems();
        ZSSItems.registerItems();
        ItemChuJelly.initializeJellies();
        ItemHeroBow.initializeArrows();
        ItemSlingshot.initializeSeeds();
        ZSSItems.addDispenserBehaviors();
    }

    public static void init() {
        ZSSItems.registerRecipes();
    }

    public static void onServerStarting() {
        ZSSItems.addGrassDrops();
        ZSSItems.addVanillaDungeonLoot();
        TradeHandler.registerTrades();
        for (Item item : addonItems) {
            ZSSItems.registerItemComparatorMapping(item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)bomb, (IItemRenderer)new RenderItemBomb());
        MinecraftForgeClient.registerItemRenderer((Item)bombBag, (IItemRenderer)new RenderItemBombBag());
        MinecraftForgeClient.registerItemRenderer((Item)hammer, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)hammerMegaton, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)hammerSkull, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)swordBiggoron, (IItemRenderer)new RenderBigItem(0.75f));
        MinecraftForgeClient.registerItemRenderer((Item)swordGiant, (IItemRenderer)new RenderBigItem(0.75f));
        MinecraftForgeClient.registerItemRenderer((Item)swordDarknut, (IItemRenderer)new RenderBigItem(0.9f));
        MinecraftForgeClient.registerItemRenderer((Item)heroBow, (IItemRenderer)new RenderItemCustomBow());
        MinecraftForgeClient.registerItemRenderer((Item)shieldDeku, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)shieldHylian, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)shieldMirror, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)heldBlock, (IItemRenderer)new RenderHeldItemBlock());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ZSSBlocks.dungeonCore), (IItemRenderer)new RenderItemDungeonBlock());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ZSSBlocks.dungeonStone), (IItemRenderer)new RenderItemDungeonBlock());
    }

    private static void addGrassDrops() {
        for (int i = 0; i < 10; ++i) {
            grassDrops.add(new ItemStack(smallHeart));
            if (enableGrassArrowDrop && i % 3 == 2) {
                grassDrops.add(new ItemStack(Items.field_151032_g));
            }
            if (i % 3 != 0) continue;
            grassDrops.add(new ItemStack(dekuNut));
        }
        if (enableGrassBombDrop) {
            grassDrops.add(new ItemStack(bomb));
        }
        if (enableGrassEmeraldDrop) {
            grassDrops.add(new ItemStack(Items.field_151166_bC));
        }
    }

    public static ItemStack getRandomGrassDrop(Random rand) {
        return grassDrops.get(rand.nextInt(grassDrops.size())).func_77946_l();
    }

    public static boolean grantBonusGear(EntityPlayer player) {
        if (!Config.enableStartingGear) {
            return false;
        }
        if (Config.enableLinksHouse) {
            player.field_71071_by.func_70441_a(new ItemStack(linksHouse));
        } else {
            if (Config.enableSword) {
                player.field_71071_by.func_70441_a(new ItemStack(swordKokiri));
            }
            if (Config.enableOrb) {
                player.field_71071_by.func_70441_a(new ItemStack(skillOrb, 1, (int)SkillBase.swordBasic.getId()));
            }
        }
        if (Config.enableFullSet) {
            ItemStack[] set = new ItemStack[]{new ItemStack(tunicHeroBoots), new ItemStack(tunicHeroLegs), new ItemStack(tunicHeroChest), new ItemStack(tunicHeroHelm)};
            for (int i = 0; i < set.length; ++i) {
                if (Config.enableAutoEquip && player.func_82169_q(i) == null) {
                    player.func_70062_b(i + 1, set[i]);
                    continue;
                }
                player.field_71071_by.func_70441_a(set[i]);
            }
        } else if (Config.enableTunic) {
            if (Config.enableAutoEquip && player.func_82169_q(3) == null) {
                player.func_70062_b(3, new ItemStack(tunicHeroChest));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(tunicHeroChest));
            }
        }
        if (Config.enableNavi) {
            ItemStack navi = new ItemStack(fairyBottle);
            navi.func_151001_c("Navi");
            player.field_71071_by.func_70441_a(navi);
        }
        return true;
    }

    private static void initItems() {
        skillOrb = new ItemSkillOrb().func_77655_b("zss.skillorb");
        heartPiece = new ItemMiscZSS(12).func_77655_b("zss.heartpiece").func_77637_a(ZSSCreativeTabs.tabSkills);
        skillWiper = new ItemMiscZSS(0){

            public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
                if (!world.field_72995_K) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.skill.reset", new Object[0]);
                    ZSSPlayerSkills.get(player).resetSkills();
                }
                return stack;
            }
        }.func_77655_b("zss.skill_wiper").func_77637_a(ZSSCreativeTabs.tabSkills);
        tunicHeroHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.hero_tunic_helm");
        tunicHeroChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).func_77655_b("zss.hero_tunic_chest");
        tunicHeroLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.hero_tunic_legs");
        tunicHeroBoots = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 3).func_77655_b("zss.hero_tunic_boots");
        tunicGoronHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.goron_tunic_helm");
        tunicGoronChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).func_77655_b("zss.goron_tunic_chest");
        tunicGoronLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.goron_tunic_legs");
        tunicZoraHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0){

            @SideOnly(value=Side.CLIENT)
            public void func_150895_a(Item item, CreativeTabs tab, List list) {
                ItemStack helm = new ItemStack(item);
                helm.func_77966_a(Enchantment.field_77340_h, 3);
                list.add(helm);
            }

            public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rnd, WeightedRandomChestContent original) {
                ItemStack helm = new ItemStack((Item)this);
                helm.func_77966_a(Enchantment.field_77340_h, 3);
                original.field_76297_b = helm;
                return original;
            }
        }.func_77655_b("zss.zora_tunic_helm");
        tunicZoraChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).setEffect(new PotionEffect(Potion.field_76427_o.func_76396_c(), 90, 0)).func_77655_b("zss.zora_tunic_chest");
        tunicZoraLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.zora_tunic_legs");
        tunicZoraBoots = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 3){

            @Override
            public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)player.field_70165_t);
                Material m = world.func_147439_a(i, (j = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b)) + 1, k = MathHelper.func_76128_c((double)player.field_70161_v)).func_149688_o();
                if (m.func_76224_d() && m != Material.field_151587_i && !player.field_70122_E && !player.field_71075_bZ.field_75100_b) {
                    if (player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y < 1.65) {
                        player.field_70159_w *= 1.115;
                        player.field_70179_y *= 1.115;
                    }
                } else if (!m.func_76224_d() && player.field_70122_E && !player.field_71075_bZ.field_75100_b) {
                    player.field_70159_w *= 0.125;
                    player.field_70179_y *= 0.125;
                    if (player.func_70051_ag()) {
                        player.func_70031_b(false);
                    }
                }
            }
        }.func_77655_b("zss.zora_tunic_boots");
        bootsHeavy = new ItemArmorBoots.ItemHeavyBoots(ItemArmor.ArmorMaterial.IRON, ZSSMain.proxy.addArmor("boots"), "minecraft:textures/models/armor/iron_layer_1.png").func_77655_b("zss.boots_heavy");
        bootsHover = new ItemArmorBoots.ItemHoverBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots"), "zeldaswordskills:textures/armor/mask_hawkeye_layer_1.png").func_77655_b("zss.boots_hover");
        bootsPegasus = new ItemArmorBoots.ItemPegasusBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots"), "zeldaswordskills:textures/armor/hero_tunic_layer_1.png").func_77655_b("zss.boots_pegasus");
        bootsRubber = new ItemArmorBoots.ItemRubberBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots"), "zeldaswordskills:textures/armor/boots_rubber_layer_1.png").func_77655_b("zss.boots_rubber");
        shieldDeku = new ItemZeldaShield(Item.ToolMaterial.WOOD, 0.25f, 30, 3.0f, 5.0f).func_77655_b("zss.shield_deku");
        shieldHylian = new ItemZeldaShield(Item.ToolMaterial.IRON, 0.5f, 18, 5.0f, 3.5f).func_77655_b("zss.shield_hylian");
        shieldMirror = new ItemZeldaShield(Item.ToolMaterial.EMERALD, 0.75f, 24, 4.0f, 4.0f).func_77655_b("zss.shield_mirror");
        swordKokiri = new ItemZeldaSword(Item.ToolMaterial.IRON, -1.0f).func_77655_b("zss.sword_kokiri").func_77656_e(256);
        swordOrdon = new ItemZeldaSword(Item.ToolMaterial.IRON, 1.0f).func_77655_b("zss.sword_ordon").func_77656_e(512);
        swordGiant = new ItemZeldaSword(Item.ToolMaterial.IRON, 6.0f, true).func_77655_b("zss.sword_giant").func_77656_e(32);
        swordBiggoron = new ItemZeldaSword(Item.ToolMaterial.IRON, 6.0f, true).setNoItemOnBreak().func_77655_b("zss.sword_biggoron").func_77656_e(0);
        swordMaster = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 2.0f).setMasterSword().func_77655_b("zss.sword_master").func_77656_e(0);
        swordTempered = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 4.0f).setMasterSword().func_77655_b("zss.sword_tempered").func_77656_e(0);
        swordGolden = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 6.0f).setMasterSword().func_77655_b("zss.sword_golden").func_77656_e(0);
        swordMasterTrue = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 8.0f).setMasterSword().func_77655_b("zss.sword_master_true").func_77656_e(0);
        swordBroken = new ItemBrokenSword().func_77655_b("zss.sword_broken");
        swordDarknut = new ItemZeldaSword(Item.ToolMaterial.IRON, 1.0f, true, 20, 0.5f).func_77655_b("zss.sword_darknut").func_77656_e(768);
        hammer = new ItemHammer(BlockWeight.VERY_LIGHT, 8.0f, 50.0f).func_77655_b("zss.hammer");
        hammerSkull = new ItemHammer(BlockWeight.MEDIUM, 12.0f, 50.0f).func_77655_b("zss.hammer_skull");
        hammerMegaton = new ItemHammer(BlockWeight.VERY_HEAVY, 16.0f, 50.0f).func_77655_b("zss.hammer_megaton");
        boomerang = new ItemBoomerang(4.0f, 12).func_77655_b("zss.boomerang");
        boomerangMagic = new ItemBoomerang(6.0f, 24).setCaptureAll().func_77655_b("zss.boomerang_magic");
        heroBow = new ItemHeroBow().func_77655_b("zss.bow_hero");
        arrowBomb = new ItemZeldaArrow("arrow_bomb");
        arrowBombFire = new ItemZeldaArrow("arrow_bomb_fire");
        arrowBombWater = new ItemZeldaArrow("arrow_bomb_water");
        arrowFire = new ItemZeldaArrow.ItemMagicArrow("arrow_fire", 2.5f);
        arrowIce = new ItemZeldaArrow.ItemMagicArrow("arrow_ice", 2.5f);
        arrowLight = new ItemZeldaArrow.ItemMagicArrow("arrow_light", 5.0f);
        slingshot = new ItemSlingshot().func_77655_b("zss.slingshot");
        scattershot = new ItemSlingshot(3, 30.0f).func_77655_b("zss.scattershot");
        supershot = new ItemSlingshot(5, 15.0f).func_77655_b("zss.supershot");
        doorLocked = new ItemDoorBoss().func_77655_b("zss.doorlocked");
        doorLockedSmall = new ItemDoorLocked(ZSSBlocks.doorLockedSmall).func_77655_b("zss.door_locked_small");
        keyBig = new ItemKeyBig().func_77655_b("zss.keybig").func_77664_n();
        keySmall = new ItemMiscZSS(6).func_77655_b("zss.keysmall").func_77664_n().func_77637_a(ZSSCreativeTabs.tabKeys);
        keySkeleton = new ItemMiscZSS(32).func_77655_b("zss.keyskeleton").func_77664_n().func_77625_d(1).func_77656_e(Config.getNumSkelKeyUses()).func_77637_a(ZSSCreativeTabs.tabKeys);
        hookshot = new ItemHookShot().func_77655_b("zss.hookshot");
        hookshotAddon = new ItemHookShotUpgrade().func_77655_b("zss.hookshot.upgrade");
        bombBag = new ItemBombBag().func_77655_b("zss.bombbag");
        bomb = new ItemBomb().func_77655_b("zss.bomb");
        crystalDin = new ItemSpiritCrystal(1, 8, 16).func_77655_b("zss.spirit_crystal_din");
        crystalFarore = new ItemSpiritCrystal(2, 8, 70).func_77655_b("zss.spirit_crystal_farore");
        crystalNayru = new ItemSpiritCrystal(4, 16, 0).func_77655_b("zss.spirit_crystal_nayru");
        gauntletsSilver = new ItemPowerGauntlets(BlockWeight.MEDIUM).func_77655_b("zss.gauntlets_silver");
        gauntletsGolden = new ItemPowerGauntlets(BlockWeight.VERY_HEAVY).func_77655_b("zss.gauntlets_golden");
        magicMirror = new ItemMagicMirror().func_77655_b("zss.magicmirror");
        fairyBottle = new ItemFairyBottle().func_77655_b("zss.fairybottle");
        potionRed = new ItemZeldaPotion("potion_red", 20.0f, 0.0f);
        potionGreen = new ItemZeldaPotion("potion_green", 0.0f, 100.0f);
        potionBlue = new ItemZeldaPotion("potion_blue", 40.0f, 100.0f);
        potionYellow = new ItemZeldaPotion("potion_yellow").setBuffEffect(Buff.RESIST_SHOCK, 6000, 100, 1.0f);
        potionPurple = new ItemDrinkable.ItemPotionPurple("potion_purple", 20, 40.0f);
        lonlonMilk = new ItemLonLonMilk("lon_lon_milk", 2, 10.0f);
        lonlonSpecial = new ItemDrinkable.ItemLonLonSpecial("lon_lon_special");
        magicJar = new ItemPickupOnly.ItemMagicJar("magic_jar", 10);
        magicJarBig = new ItemPickupOnly.ItemMagicJar("magic_jar_big", 250);
        magicContainer = new ItemDrinkable("magic_container"){

            @Override
            public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
                ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
                float max = info.getMaxMagic();
                if (max < (float)Config.getMaxMagicPoints() || info.getCurrentMagic() < max) {
                    info.setMaxMagic(max + 50.0f);
                    info.setCurrentMagic(info.getMaxMagic());
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                return super.func_77654_b(stack, world, player);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
                list.add(StatCollector.func_74838_a((String)"tooltip.zss.magic_container.desc.0"));
                list.add(StatCollector.func_74838_a((String)"tooltip.zss.magic_container.desc.1"));
            }
        }.func_77637_a(ZSSCreativeTabs.tabTools);
        rodFire = new ItemMagicRod(MagicType.FIRE, 8.0f, 10.0f).func_77655_b("zss.rod_fire");
        rodIce = new ItemMagicRod(MagicType.ICE, 6.0f, 10.0f).func_77655_b("zss.rod_ice");
        rodTornado = new ItemMagicRod(MagicType.WIND, 4.0f, 10.0f).func_77655_b("zss.rod_tornado");
        whip = new ItemWhip().func_77655_b("zss.whip");
        maskBlast = new ItemMask.ItemMaskBlast(ItemArmor.ArmorMaterial.IRON, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_blast");
        maskBunny = new ItemMask.ItemMaskBunny(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(1, 64).func_77655_b("zss.mask_bunny");
        maskCouples = new ItemMask.ItemMaskCouples(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(40, 32).func_77655_b("zss.mask_couples");
        maskGerudo = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_gerudo");
        maskGiants = new ItemMask.ItemMaskGiants(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_giants");
        maskGibdo = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_gibdo");
        maskHawkeye = new ItemMask.ItemMaskHawkeye(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_hawkeye");
        maskKeaton = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(8, 16).func_77655_b("zss.mask_keaton");
        maskScents = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(32, 32).func_77655_b("zss.mask_scents");
        maskSkull = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(20, 10).func_77655_b("zss.mask_skull");
        maskSpooky = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(16, 8).func_77655_b("zss.mask_spooky");
        maskStone = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setEffect(new PotionEffect(Potion.field_76441_p.func_76396_c(), 100, 0)).func_77655_b("zss.mask_stone");
        maskTruth = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_truth");
        maskDeku = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_deku");
        maskGoron = new ItemMask.ItemMaskGoron(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_goron");
        maskZora = new ItemMaskZora(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_zora");
        maskFierce = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_fierce");
        maskMajora = new ItemMask.ItemMaskMajora(WOOD, ZSSMain.proxy.addArmor("mask")).setEffect(new PotionEffect(Potion.field_82731_v.func_76396_c(), 100, 1)).func_77655_b("zss.mask_majora");
        pendant = new ItemPendant().func_77655_b("zss.pendant");
        crystalSpirit = new ItemMiscZSS(0).func_77655_b("zss.spirit_crystal_empty").func_77625_d(1).func_77637_a(ZSSCreativeTabs.tabTools);
        masterOre = new ItemMasterOre(24).func_77655_b("zss.masterore");
        rocsFeather = new ItemMiscZSS(12).func_77655_b("zss.rocs_feather").func_77637_a(ZSSCreativeTabs.tabTools);
        dekuLeaf = new ItemDekuLeaf().func_77655_b("zss.deku_leaf");
        dekuNut = new ItemMiscZSS(2){

            public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
                EntitySeedShot seedShot = new EntitySeedShot(world, (EntityLivingBase)player, 0.5f, 1, 0.0f).setType(EntitySeedShot.SeedType.DEKU);
                seedShot.setDamage(2.5f);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)seedShot);
                }
                return stack;
            }
        }.func_77655_b("zss.deku_nut").func_77637_a(ZSSCreativeTabs.tabTools);
        jellyChu = new ItemChuJelly().func_77655_b("zss.jelly_chu");
        treasure = new ItemTreasure().func_77655_b("zss.treasure");
        skulltulaToken = new ItemMiscZSS(20){

            @Override
            protected void handleTrade(ItemStack stack, EntityPlayer player, EntityVillager villager) {
                ZSSVillagerInfo villagerInfo = ZSSVillagerInfo.get(villager);
                if (villager.getClass() == EntityVillager.class && "Cursed Man".equals(villager.func_94057_bL())) {
                    villagerInfo.handleSkulltulaTrade(stack, player);
                } else if (villager.func_70631_g_()) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.child", new Object[0]);
                } else if (villagerInfo.isHunter()) {
                    villagerInfo.addHunterTrade(player, new ItemStack((Item)this), this.sellPrice);
                } else {
                    int i = villager.func_70946_n();
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.skulltula_token.villager." + (i > 4 ? "custom" : Integer.valueOf(i)), new Object[0]);
                }
            }
        }.func_77655_b("zss.skulltula_token");
        linksHouse = new ItemBuilderSeed(LinksHouse.class, "chat.zss.links_house.fail", "deku_nut").func_77655_b("zss.links_house");
        instrument = new ItemInstrument();
        bombFlowerSeed = new ItemBombFlowerSeed().func_77655_b("zss.seed_bomb_flower");
        heldBlock = new ItemHeldBlock().func_77655_b("zss.held_block");
        powerPiece = new ItemPickupOnly("power_piece"){

            @Override
            public boolean onPickupItem(ItemStack stack, EntityPlayer player) {
                PlayerUtils.playSound(player, "zeldaswordskills:success_magic", 0.6f, 1.0f);
                ZSSEntityInfo buffs = ZSSEntityInfo.get((EntityLivingBase)player);
                buffs.applyBuff(Buff.ATTACK_UP, 600, 100);
                buffs.applyBuff(Buff.DEFENSE_UP, 600, 25);
                buffs.applyBuff(Buff.EVADE_UP, 600, 25);
                buffs.applyBuff(Buff.RESIST_STUN, 600, 100);
                --stack.field_77994_a;
                return true;
            }
        };
        smallHeart = new ItemPickupOnly("heart"){

            @Override
            public boolean onPickupItem(ItemStack stack, EntityPlayer player) {
                if (player.func_110143_aJ() < player.func_110138_aP() || Config.alwaysPickupHearts()) {
                    player.func_70691_i(1.0f);
                    --stack.field_77994_a;
                    return true;
                }
                return false;
            }
        };
        throwingRock = new Item(){

            public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityThrowingRock(world, (EntityLivingBase)player));
                }
                return stack;
            }
        }.func_77655_b("zss.throwing_rock").func_111206_d("zeldaswordskills:throwing_rock").func_77625_d(18);
        eggSpawner = new ItemCustomEgg().func_77655_b("zss.spawn_egg");
        eggChu = new ItemCustomVariantEgg(EntityChu.class, "chu").func_77655_b("zss.eggChu");
        eggDarknut = new ItemCustomVariantEgg(EntityDarknut.class, "darknut").func_77655_b("zss.eggDarknut");
        eggKeese = new ItemCustomVariantEgg(EntityKeese.class, "keese").func_77655_b("zss.eggKeese");
        eggOctorok = new ItemCustomVariantEgg(EntityOctorok.class, "octorok").func_77655_b("zss.eggOctorok");
        eggWizzrobe = new ItemCustomVariantEgg(EntityWizzrobe.class, "wizzrobe").func_77655_b("zss.eggWizzrobe");
        bookMudora = new Item().func_77655_b("zss.book_mudora").func_111206_d("zeldaswordskills:book_mudora").func_77656_e(0).func_77637_a(ZSSCreativeTabs.tabMisc);
        medallion = new ItemMedallion().func_77655_b("zss.medallion");
    }

    public static void addItemComparatorMapping(Item item) {
        addonItems.add(item);
    }

    private static void registerItemComparatorMapping(Item item) {
        if (itemList.containsKey(item)) {
            ZSSMain.logger.warn("Item already has a comparator mapping: " + (item == null ? "NULL" : item.func_77658_a()));
        } else {
            itemList.put(item, sortId++);
        }
    }

    public static void registerItemBlock(Item block) {
        if (block instanceof ItemBlock) {
            ZSSItems.registerItemComparatorMapping(block);
        } else {
            ZSSMain.logger.warn("Tried to register a non-ItemBlock item for " + (block == null ? "NULL" : block.func_77658_a()));
        }
    }

    private static void registerItems() {
        try {
            for (Field f : ZSSItems.class.getFields()) {
                Item item;
                if (!Item.class.isAssignableFrom(f.getType()) || (item = (Item)f.get(null)) == null) continue;
                ZSSItems.registerItemComparatorMapping(item);
                GameRegistry.registerItem((Item)item, (String)item.func_77658_a().replace("item.", "").trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerRecipes() {
        if (allowGoldSmelting) {
            FurnaceRecipes.func_77602_a().func_151396_a(Items.field_151010_B, new ItemStack(Items.field_151043_k), 0.0f);
        }
        if (enableCraftingHammer) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(hammer), (Object[])new Object[]{"lll", " s ", " s ", Character.valueOf('l'), Blocks.field_150364_r, Character.valueOf('s'), Items.field_151055_y});
            GameRegistry.addRecipe((ItemStack)new ItemStack(hammer), (Object[])new Object[]{"lll", " s ", " s ", Character.valueOf('l'), Blocks.field_150363_s, Character.valueOf('s'), Items.field_151055_y});
        }
        if (enableCraftingHookshot) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(hookshot, 1, IHookable.HookshotType.WOOD_SHOT_EXT.ordinal()), (Object[])new Object[]{new ItemStack(hookshot, 1, IHookable.HookshotType.WOOD_SHOT.ordinal()), new ItemStack(hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal())});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal()), (Object[])new Object[]{new ItemStack(hookshot, 1, IHookable.HookshotType.WOOD_SHOT.ordinal()), new ItemStack(hookshotAddon, 1, ItemHookShotUpgrade.AddonType.STONECLAW.ordinal())});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(hookshot, 1, IHookable.HookshotType.CLAW_SHOT_EXT.ordinal()), (Object[])new Object[]{new ItemStack(hookshot, 1, IHookable.HookshotType.WOOD_SHOT_EXT.ordinal()), new ItemStack(hookshotAddon, 1, ItemHookShotUpgrade.AddonType.STONECLAW.ordinal())});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(hookshot, 1, IHookable.HookshotType.CLAW_SHOT_EXT.ordinal()), (Object[])new Object[]{new ItemStack(hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal()), new ItemStack(hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal())});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(hookshot, 1, IHookable.HookshotType.MULTI_SHOT.ordinal()), (Object[])new Object[]{new ItemStack(hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal()), new ItemStack(hookshotAddon, 1, ItemHookShotUpgrade.AddonType.MULTI.ordinal())});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(hookshot, 1, IHookable.HookshotType.MULTI_SHOT_EXT.ordinal()), (Object[])new Object[]{new ItemStack(hookshot, 1, IHookable.HookshotType.CLAW_SHOT_EXT.ordinal()), new ItemStack(hookshotAddon, 1, ItemHookShotUpgrade.AddonType.MULTI.ordinal())});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(hookshot, 1, IHookable.HookshotType.MULTI_SHOT_EXT.ordinal()), (Object[])new Object[]{new ItemStack(hookshot, 1, IHookable.HookshotType.MULTI_SHOT.ordinal()), new ItemStack(hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal())});
        }
        if (enableCraftingMudora) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(bookMudora, 2), (Object[])new Object[]{bookMudora, Items.field_151122_aG, Items.field_151008_G, new ItemStack(Items.field_151100_aR, 1, 0)});
        }
        if (enableCraftingThrowingRock) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(throwingRock, 9), (Object[])new Object[]{Blocks.field_150347_e});
            GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150347_e), (Object[])new Object[]{"rrr", "rrr", "rrr", Character.valueOf('r'), throwingRock});
        }
        GameRegistry.addRecipe((IRecipe)new RecipeCombineBombBag());
        RecipeSorter.register((String)"zeldaswordskills:combinebombbag", RecipeCombineBombBag.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.pedestal, 3, 8), (Object[])new Object[]{"qqq", "qpq", "qqq", Character.valueOf('q'), Blocks.field_150371_ca, Character.valueOf('p'), new ItemStack(ZSSBlocks.pedestal, 1, 8)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.beamWooden), (Object[])new Object[]{"b", "b", "b", Character.valueOf('b'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.gossipStone), (Object[])new Object[]{" s ", "sos", " s ", Character.valueOf('s'), Blocks.field_150348_b, Character.valueOf('o'), new ItemStack(instrument, 1, ItemInstrument.Instrument.OCARINA_FAIRY.ordinal())});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.hookTarget), (Object[])new Object[]{" c ", "bab", " b ", Character.valueOf('a'), Items.field_151137_ax, Character.valueOf('b'), Blocks.field_150348_b, Character.valueOf('c'), Blocks.field_150411_aY});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.hookTargetAll), (Object[])new Object[]{"bcb", "cac", "bcb", Character.valueOf('a'), Items.field_151137_ax, Character.valueOf('b'), Blocks.field_150348_b, Character.valueOf('c'), Blocks.field_150411_aY});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(arrowBomb), (Object[])new Object[]{new ItemStack(bomb, 1, BombType.BOMB_STANDARD.ordinal()), Items.field_151032_g});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(arrowBombFire), (Object[])new Object[]{new ItemStack(bomb, 1, BombType.BOMB_FIRE.ordinal()), Items.field_151032_g});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(arrowBombWater), (Object[])new Object[]{new ItemStack(bomb, 1, BombType.BOMB_WATER.ordinal()), Items.field_151032_g});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.ceramicJar, 8), (Object[])new Object[]{"c c", "c c", " c ", Character.valueOf('c'), Items.field_151118_aC});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skillOrb, 1, (int)SkillBase.bonusHeart.getId()), (Object[])new Object[]{"HH", "HH", Character.valueOf('H'), heartPiece});
        GameRegistry.addRecipe((ItemStack)new ItemStack(instrument, 1, ItemInstrument.Instrument.OCARINA_FAIRY.ordinal()), (Object[])new Object[]{" c ", "crc", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('r'), Items.field_151120_aE});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicGoronLegs), (Object[])new Object[]{tunicHeroLegs, new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicGoronLegs), (Object[])new Object[]{tunicZoraLegs, new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicHeroLegs), (Object[])new Object[]{tunicGoronLegs, new ItemStack(Items.field_151100_aR, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicHeroLegs), (Object[])new Object[]{tunicZoraLegs, new ItemStack(Items.field_151100_aR, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicZoraLegs), (Object[])new Object[]{tunicGoronLegs, new ItemStack(Items.field_151100_aR, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicZoraLegs), (Object[])new Object[]{tunicHeroLegs, new ItemStack(Items.field_151100_aR, 1, 4)});
    }

    private static void addVanillaDungeonLoot() {
        if (enableBombLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(bomb, 1, BombType.BOMB_STANDARD.ordinal()), 1, 3, Config.getBombWeight()), true, true);
        }
        if (enableBombBagLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(bombBag), 1, 1, Config.getBombBagWeight()), true, false);
        }
        if (enableHeartLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillOrb, 1, (int)SkillBase.bonusHeart.getId()), 1, 1, Config.getHeartWeight()), false, false);
        }
    }

    private static void addLootToAll(WeightedRandomChestContent loot, boolean smith, boolean bonus) {
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(loot);
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(loot);
        if (smith) {
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(loot);
        }
        if (bonus) {
            ChestGenHooks.getInfo((String)"bonusChest").addItem(loot);
        }
    }

    private static void addDispenserBehaviors() {
        BlockDispenser.field_149943_a.func_82595_a((Object)eggSpawner, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggChu, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggDarknut, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggKeese, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggOctorok, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggWizzrobe, (Object)new BehaviorDispenseCustomMobEgg());
    }

    static {
        grassDrops = new ArrayList<ItemStack>();
        WOOD = EnumHelper.addArmorMaterial((String)"Wood", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)5);
    }
}

