/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.bidirectional;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.network.AbstractMessage;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.SongNote;

public class LearnSongPacket
extends AbstractMessage<LearnSongPacket> {
    private AbstractZeldaSong song;
    private List<SongNote> notes;
    private boolean remove;
    private boolean reset;

    public LearnSongPacket() {
    }

    public LearnSongPacket(AbstractZeldaSong song) {
        this(song, null);
    }

    public LearnSongPacket(AbstractZeldaSong song, List<SongNote> notes) {
        this.song = song;
        this.notes = notes;
    }

    public LearnSongPacket(AbstractZeldaSong song, boolean remove) {
        this.song = song;
        this.remove = remove;
    }

    public LearnSongPacket(boolean reset) {
        this.reset = reset;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        int n;
        this.reset = buffer.readBoolean();
        if (this.reset) {
            return;
        }
        this.remove = buffer.readBoolean();
        String s = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.song = ZeldaSongs.getSongByName(s);
        if (this.song == null) {
            ZSSMain.logger.error("Invalid song name '" + s + "' read from packet!");
        }
        this.notes = (n = buffer.readByte()) > 0 ? new ArrayList() : null;
        for (int i = 0; i < n; ++i) {
            this.notes.add(SongNote.values()[buffer.readByte() % SongNote.values().length]);
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeBoolean(this.reset);
        if (this.reset) {
            return;
        }
        buffer.writeBoolean(this.remove);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.song.getUnlocalizedName());
        int n = this.notes == null ? 0 : this.notes.size();
        buffer.writeByte((int)((byte)n));
        for (int i = 0; i < n; ++i) {
            buffer.writeByte((int)((byte)this.notes.get(i).ordinal()));
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if ((this.reset || this.remove) && side.isServer()) {
            ((EntityPlayerMP)player).field_71135_a.func_147360_c("Sent invalid packet to server!");
            return;
        }
        if (this.reset) {
            ZSSPlayerSongs.get(player).resetKnownSongs();
        } else if (this.song != null) {
            if (this.remove) {
                ZSSPlayerSongs.get(player).removeSong(this.song);
            } else {
                ZSSPlayerSongs.get(player).learnSong(this.song, this.notes);
            }
        }
    }
}

