/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.client;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import zeldaswordskills.network.AbstractMessage;
import zeldaswordskills.ref.Config;

public class SyncConfigPacket
extends AbstractMessage.AbstractClientMessage<SyncConfigPacket> {
    private boolean isValid;
    public boolean enableOffhandMaster;
    public boolean enableStunPlayer;
    public boolean enableSwingSpeed;
    public boolean enableVanillaLift;
    public boolean enableVanillaSmash;
    public boolean disableAllUnenchantables;
    public boolean enableHookableOnly;
    public boolean requireFullHealth;
    public boolean allMasterSwordsProvidePower;
    public boolean enableSecretStoneLift;
    public int baseSwingSpeed;
    public int bombFuseTime;
    public int hookshotRange;
    public int whipRange;

    public final boolean isMessageValid() {
        return this.isValid;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        short bits = buffer.readShort();
        this.enableOffhandMaster = (bits & 1) > 0;
        this.enableStunPlayer = (bits & 2) > 0;
        this.enableSwingSpeed = (bits & 4) > 0;
        this.enableVanillaLift = (bits & 8) > 0;
        this.enableVanillaSmash = (bits & 0x10) > 0;
        this.disableAllUnenchantables = (bits & 0x20) > 0;
        this.enableHookableOnly = (bits & 0x40) > 0;
        this.requireFullHealth = (bits & 0x80) > 0;
        this.allMasterSwordsProvidePower = (bits & 0x100) > 0;
        this.enableSecretStoneLift = (bits & 0x200) > 0;
        this.baseSwingSpeed = buffer.readInt();
        this.bombFuseTime = buffer.readInt();
        this.hookshotRange = buffer.readInt();
        this.whipRange = buffer.readInt();
        this.isValid = true;
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        short bits = 0;
        bits = (short)(bits | (Config.allowOffhandMaster() ? 1 : 0));
        bits = (short)(bits | (Config.canPlayersBeStunned() ? 2 : 0));
        bits = (short)(bits | (Config.affectAllSwings() ? 4 : 0));
        bits = (short)(bits | (Config.canLiftVanilla() ? 8 : 0));
        bits = (short)(bits | (Config.canSmashVanilla() ? 16 : 0));
        bits = (short)(bits | (Config.areUnenchantablesDisabled() ? 32 : 0));
        bits = (short)(bits | (Config.allowHookableOnly() ? 64 : 0));
        bits = (short)(bits | (Config.getHealthAllowance(1) == 0.0f ? 128 : 0));
        bits = (short)(bits | (Config.getMasterSwordsProvidePower() ? 256 : 0));
        bits = (short)(bits | (Config.canLiftSecretStone() ? 512 : 0));
        buffer.writeShort((int)bits);
        buffer.writeInt(Config.getBaseSwingSpeed());
        buffer.writeInt(Config.getBombFuseTime());
        buffer.writeInt(Config.getHookshotRange());
        buffer.writeInt(Config.getWhipRange());
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        Config.syncClientSettings(this);
    }
}

