/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills;

import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillPassive;

public class BonusHeart
extends SkillPassive {
    public static final int MAX_BONUS_HEARTS = 50;
    private static final UUID bonusHeartUUID = UUID.fromString("14ED99DA-D333-4621-90C8-81C968A082E3");
    private static final AttributeModifier bonusHeartModifier = new AttributeModifier(bonusHeartUUID, "ZSS Bonus Heart", 2.0, 0).func_111168_a(true);

    public BonusHeart(String name) {
        super(name);
    }

    private BonusHeart(BonusHeart skill) {
        super(skill);
    }

    @Override
    public BonusHeart newInstance() {
        return new BonusHeart(this);
    }

    @Override
    public byte getMaxLevel() {
        return (byte)(Config.getMaxBonusHearts() + (Config.isHardcoreZeldaFan() ? 7 : 0));
    }

    @Override
    public String getIconTexture() {
        return "zeldaswordskills:heart_container";
    }

    @Override
    public boolean isLoot() {
        return false;
    }

    @Override
    protected void levelUp(EntityPlayer player) {
        IAttributeInstance attributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (attributeinstance.func_111127_a(bonusHeartUUID) != null) {
            attributeinstance.func_111124_b(bonusHeartModifier);
        }
        AttributeModifier newModifier = new AttributeModifier(bonusHeartUUID, "Bonus Heart", (double)this.level * 2.0, 0).func_111168_a(true);
        attributeinstance.func_111121_a(newModifier);
        player.func_70691_i(player.func_110138_aP());
    }

    @Override
    public void validateSkill(EntityPlayer player) {
        float health = player.func_110143_aJ();
        this.levelUp(player);
        player.func_70606_j(health);
    }
}

