/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.IEntityBackslice;
import zeldaswordskills.client.ZSSClientEvents;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class BackSlice
extends SkillActive {
    private static Set<Class<? extends EntityLivingBase>> immuneEntities;
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int dodgeTimer = 0;
    private SkillActive targetingSkill;

    public BackSlice(String name) {
        super(name);
        BackSlice.init();
    }

    private BackSlice(BackSlice skill) {
        super(skill);
    }

    @Override
    public BackSlice newInstance() {
        return new BackSlice(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{360 - 2 * this.getAttackAngle()}));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.2f", Float.valueOf(BackSlice.getDisarmorChance(null, player.func_70694_bm(), this.level)))}));
        desc.add(this.getDamageDisplay(this.level * 10, true) + "%");
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public boolean isLoot() {
        return false;
    }

    private int getActiveTime() {
        return 15 + this.level;
    }

    private int getAttackAngle() {
        return 160 - this.level * 10;
    }

    private int getDodgeTime() {
        return 10 - this.level;
    }

    public static float getDisarmorChance(ItemStack armorStack, ItemStack weapon, int level) {
        float chance = (float)level * 0.05f;
        if (armorStack != null && armorStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)armorStack.func_77973_b();
            int i = armor.func_82812_d().func_78044_b(armor.field_77881_a);
            chance += (float)(5 - i) * 0.05f;
            i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)armorStack);
            if (i > 0) {
                chance -= (float)i * 0.05f;
            }
        }
        if (weapon != null) {
            int i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77338_j.field_77352_x, (ItemStack)weapon);
            if (i > 0) {
                chance += (float)i * 0.05f;
            }
        } else {
            chance -= 1.0f;
        }
        return chance;
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.1f * (float)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_70694_bm()) && ZSSPlayerSkills.get(player).isSkillActive(swordBasic);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        if (this.isActive()) {
            return key == ZSSKeyHandler.keys[2] || Config.allowVanillaControls && key == mc.field_71474_y.field_74312_F;
        }
        return key == mc.field_71474_y.field_74351_w || key == ZSSKeyHandler.keys[3] || key == ZSSKeyHandler.keys[4] || Config.allowVanillaControls && (key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (this.keyPressed != null && this.keyPressed.func_151470_d() && key == mc.field_71474_y.field_74351_w) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.field_71474_y.field_74351_w) {
                this.keyPressed = key;
            }
        } else if (this.isActive() && (key == mc.field_71474_y.field_74312_F || key == ZSSKeyHandler.keys[2])) {
            ZSSClientEvents.performComboAttack(mc, ZSSPlayerSkills.get(player).getTargetingSkill());
        }
        return false;
    }

    @Override
    public boolean onActivated(World world, EntityPlayer player) {
        this.dodgeTimer = this.getActiveTime();
        this.targetingSkill = ZSSPlayerSkills.get(player).getActiveSkill(swordBasic);
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.dodgeTimer = 0;
        this.targetingSkill = null;
        if (world.field_72995_K) {
            this.keyPressed = null;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0 && --this.ticksTilFail == 0) {
            this.keyPressed = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.dodgeTimer > this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (player.field_70122_E) {
            double speed;
            if (this.targetingSkill != null && this.targetingSkill.isActive()) {
                this.targetingSkill.onRenderTick(player, partialTickTime);
            }
            if ((speed = 1.0 + 10.0 * (player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e() - (double)0.1f)) > 1.0) {
                speed = 1.0;
            }
            double d = 0.15 * speed * speed;
            if (player.func_70090_H() || player.func_70058_J()) {
                d *= 0.15;
            }
            Vec3 vec3 = player.func_70040_Z();
            if (this.keyPressed == ZSSKeyHandler.keys[4] || this.keyPressed == Minecraft.func_71410_x().field_71474_y.field_74366_z) {
                player.func_70024_g(-vec3.field_72449_c * d, 0.0, vec3.field_72450_a * d);
            } else {
                player.func_70024_g(vec3.field_72449_c * d, 0.0, -vec3.field_72450_a * d);
            }
            player.func_70024_g(vec3.field_72450_a * d * 1.15, 0.0, vec3.field_72449_c * d * 1.15);
        }
        return false;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        ILockOnTarget targeting = ZSSPlayerSkills.get(player).getTargetingSkill();
        return this.dodgeTimer > this.getDodgeTime() && targeting != null && targeting.getCurrentTarget() == source.func_76346_g();
    }

    @Override
    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        ILockOnTarget targeting;
        if (this.isActive() && this.dodgeTimer <= this.getActiveTime() - 5 && (targeting = ZSSPlayerSkills.get(player).getTargetingSkill()) != null && targeting.getCurrentTarget() == entity && !TargetUtils.isTargetInFrontOf((Entity)entity, (Entity)player, this.getAttackAngle())) {
            ItemStack armor;
            boolean flag = false;
            boolean isIBackEntity = entity instanceof IEntityBackslice;
            if (isIBackEntity) {
                flag = ((IEntityBackslice)entity).allowDamageMultiplier(player);
            } else if (!BackSlice.isEntityImmune(entity)) {
                flag = true;
            }
            if (flag) {
                amount *= 1.0f + (float)this.level * 0.1f;
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:mortaldraw", 0.4f, 0.5f);
            }
            if (isIBackEntity) {
                amount = ((IEntityBackslice)entity).onBackSliced(player, this.level, amount);
            }
            boolean bl = flag = flag && (Config.canDisarmorPlayers() || !(entity instanceof EntityPlayer));
            if (flag && (!isIBackEntity || ((IEntityBackslice)entity).allowDisarmorment(player, amount)) && (armor = entity.func_71124_b(3)) != null && player.field_70170_p.field_73012_v.nextFloat() < BackSlice.getDisarmorChance(armor, player.func_70694_bm(), this.level)) {
                WorldUtils.spawnItemWithRandom(entity.field_70170_p, armor, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                entity.func_70062_b(3, null);
            }
        }
        this.deactivate(player);
        return amount;
    }

    private static boolean isEntityImmune(EntityLivingBase entity) {
        for (Class<? extends EntityLivingBase> clazz : immuneEntities) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    private static void init() {
        if (immuneEntities == null) {
            immuneEntities = new HashSet<Class<? extends EntityLivingBase>>();
            immuneEntities.add(EntityBlaze.class);
            immuneEntities.add(EntityChu.class);
            immuneEntities.add(EntitySnowman.class);
            immuneEntities.add(EntitySlime.class);
        }
    }
}

