/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;

public class Dodge
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int dodgeTimer = 0;
    private Entity entityDodged;

    public Dodge(String name) {
        super(name);
    }

    private Dodge(Dodge skill) {
        super(skill);
    }

    @Override
    public Dodge newInstance() {
        return new Dodge(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{(int)(this.getBaseDodgeChance(player) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{(this.getDodgeTime() + this.level - 5) * 2}));
        desc.add(this.getTimeLimitDisplay(this.getDodgeTime()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 0.05f;
    }

    private float getBaseDodgeChance(EntityPlayer player) {
        float evadeUp = (float)ZSSEntityInfo.get((EntityLivingBase)player).getBuffAmplifier(Buff.EVADE_UP) * 0.01f;
        float evadeDown = (float)ZSSEntityInfo.get((EntityLivingBase)player).getBuffAmplifier(Buff.EVADE_DOWN) * 0.01f;
        float speedBonus = 2.0f * (float)(player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e() - (double)0.1f);
        return (float)this.level * 0.1f + (evadeUp - evadeDown) + speedBonus;
    }

    private float getDodgeChance(EntityPlayer player) {
        return this.getBaseDodgeChance(player) + this.getTimeBonus();
    }

    private int getDodgeTime() {
        return 5 + this.level;
    }

    private float getTimeBonus() {
        return (float)(this.dodgeTimer + this.level - 5) * 0.02f;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && ZSSPlayerSkills.get(player).isSkillActive(swordBasic);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return Config.allowVanillaControls && (key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z) || key == ZSSKeyHandler.keys[3] || key == ZSSKeyHandler.keys[4];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (Config.requireDoubleTap) {
                if (this.ticksTilFail > 0 && key == this.keyPressed) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.keyPressed = key;
                this.ticksTilFail = 6;
            } else if (key == ZSSKeyHandler.keys[3] || key == ZSSKeyHandler.keys[4]) {
                PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onActivated(World world, EntityPlayer player) {
        this.dodgeTimer = this.getDodgeTime();
        this.entityDodged = null;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.dodgeTimer = 0;
        this.entityDodged = null;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.dodgeTimer > this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        double speed = 1.0 + 10.0 * (player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e() - (double)0.1f);
        if (speed > 1.0) {
            speed = 1.0;
        }
        double d = 0.15 * speed * speed;
        Vec3 vec3 = player.func_70040_Z();
        if (this.keyPressed == ZSSKeyHandler.keys[4] || this.keyPressed == Minecraft.func_71410_x().field_71474_y.field_74366_z) {
            player.func_70016_h(-vec3.field_72449_c * d, player.field_70181_x, vec3.field_72450_a * d);
        } else {
            player.func_70016_h(vec3.field_72449_c * d, player.field_70181_x, -vec3.field_72450_a * d);
        }
        return true;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        Entity attacker;
        if (this.dodgeTimer > this.level && (attacker = source.func_76346_g()) != null) {
            return attacker == this.entityDodged || this.dodgeAttack(player, attacker);
        }
        return false;
    }

    private boolean dodgeAttack(EntityPlayer player, Entity attacker) {
        if (player.field_70170_p.field_73012_v.nextFloat() < this.getDodgeChance(player)) {
            this.entityDodged = attacker;
            PlayerUtils.playRandomizedSound(player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            return true;
        }
        return false;
    }
}

