/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.IParryModifier;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class Parry
extends SkillActive {
    private int parryTimer;
    private int attacksParried;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public Parry(String name) {
        super(name);
    }

    private Parry(Parry skill) {
        super(skill);
    }

    @Override
    public Parry newInstance() {
        return new Parry(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{(int)(this.getDisarmChance(player, null) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{(int)(2.5f * (float)(this.getActiveTime() - this.getParryDelay()))}));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 3), (Object[])new Object[]{this.getMaxParries()}));
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getParryDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.parryTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 0.3f - 0.02f * (float)this.level;
    }

    private int getActiveTime() {
        return 6 + this.level;
    }

    private int getParryDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxParries() {
        return (1 + this.level) / 2;
    }

    public float getDisarmChance(EntityPlayer player, EntityLivingBase attacker) {
        float penalty = 0.15f * (float)this.attacksParried;
        float bonus = Config.getDisarmTimingBonus() * (float)(this.parryTimer > 0 ? this.parryTimer - this.getParryDelay() : 0);
        float modifier = Parry.getDisarmModifier((EntityLivingBase)player, attacker);
        return modifier - penalty + bonus;
    }

    public static float getDisarmModifier(EntityLivingBase defender, EntityLivingBase attacker) {
        ItemStack defStack = defender.func_70694_bm();
        ItemStack offStack = attacker != null ? attacker.func_70694_bm() : null;
        float modifier = 0.0f;
        if (defender instanceof EntityPlayer) {
            modifier += 0.1f * (float)ZSSPlayerSkills.get((EntityPlayer)defender).getSkillLevel(parry);
        }
        if (defender instanceof IParryModifier) {
            modifier += ((IParryModifier)defender).getDefensiveModifier(defender, defStack);
        }
        if (defStack != null && defStack.func_77973_b() instanceof IParryModifier) {
            modifier += ((IParryModifier)defStack.func_77973_b()).getDefensiveModifier(defender, defStack);
        }
        if (attacker instanceof EntityPlayer) {
            modifier -= Config.getDisarmPenalty() * (float)ZSSPlayerSkills.get((EntityPlayer)attacker).getSkillLevel(parry);
        }
        if (attacker instanceof IParryModifier) {
            modifier -= ((IParryModifier)attacker).getOffensiveModifier(attacker, offStack);
        }
        if (offStack != null && offStack.func_77973_b() instanceof IParryModifier) {
            modifier -= ((IParryModifier)offStack.func_77973_b()).getOffensiveModifier(attacker, offStack);
        }
        return modifier;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_70694_bm());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canUse(player) && !PlayerUtils.isBlocking(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == ZSSKeyHandler.keys[5] || Config.allowVanillaControls && key == mc.field_71474_y.field_74368_y;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (Config.requireDoubleTap) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.field_71474_y.field_74368_y) {
                PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.parryTimer = this.getActiveTime();
        this.attacksParried = 0;
        this.playMissSound = true;
        player.func_71038_i();
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.parryTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.parryTimer <= this.getParryDelay() && this.playMissSound) {
                this.playMissSound = false;
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            }
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            if (this.attacksParried < this.getMaxParries() && this.parryTimer > this.getParryDelay() && attacker.func_70694_bm() != null && PlayerUtils.isWeapon(player.func_70694_bm())) {
                if (player.field_70170_p.field_73012_v.nextFloat() < this.getDisarmChance(player, attacker)) {
                    WorldUtils.dropHeldItem(attacker);
                }
                ++this.attacksParried;
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                this.playMissSound = false;
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }
}

