/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.server.EndComboPacket;
import zeldaswordskills.network.server.TargetIdPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.Combo;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class SwordBasic
extends SkillActive
implements ICombo,
ILockOnTarget {
    private boolean isActive = false;
    private EntityLivingBase currentTarget = null;
    @SideOnly(value=Side.CLIENT)
    private EntityLivingBase prevTarget;
    private Combo combo = null;

    public SwordBasic(String name) {
        super(name);
    }

    private SwordBasic(SwordBasic skill) {
        super(skill);
    }

    @Override
    public SwordBasic newInstance() {
        return new SwordBasic(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{this.getMaxComboSize()}));
        desc.add(this.getTimeLimitDisplay(this.getComboTimeLimit()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.1f", Float.valueOf(0.5f * (float)this.level))}));
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return this.level > 0;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean hasAnimation() {
        return false;
    }

    @Override
    protected float getExhaustion() {
        return 0.0f;
    }

    @Override
    public byte getMaxLevel() {
        return 10;
    }

    private final int getComboTimeLimit() {
        return 20 + this.level * 2;
    }

    private final int getMaxComboSize() {
        return 2 + this.level;
    }

    private final int getRange() {
        return 6 + this.level;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        if (this.isActive) {
            this.onDeactivated(world, player);
        } else {
            this.isActive = true;
            if (!this.isComboInProgress()) {
                this.combo = null;
            }
            this.currentTarget = TargetUtils.acquireLookTarget((EntityLivingBase)player, this.getRange(), this.getRange(), true);
        }
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.isActive = false;
        this.currentTarget = null;
        if (world.field_72995_K) {
            this.prevTarget = null;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive() && player.field_70170_p.field_72995_K && (Minecraft.func_71410_x().field_71462_r != null || !this.updateTargets(player))) {
            this.deactivate(player);
        }
        if (this.isComboInProgress()) {
            this.combo.onUpdate(player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        float rYaw;
        double dx = player.field_70165_t - this.currentTarget.field_70165_t;
        double dz = player.field_70161_v - this.currentTarget.field_70161_v;
        double angle = Math.atan2(dz, dx) * 180.0 / Math.PI;
        double pitch = Math.atan2(player.field_70163_u - (this.currentTarget.field_70163_u + (double)(this.currentTarget.field_70131_O / 2.0f)), Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI;
        double distance = player.func_70032_d((Entity)this.currentTarget);
        for (rYaw = (float)(angle - (double)player.field_70177_z); rYaw > 180.0f; rYaw -= 360.0f) {
        }
        while (rYaw < -180.0f) {
            rYaw += 360.0f;
        }
        float rPitch = (float)pitch - (float)(10.0 / Math.sqrt(distance)) + (float)(distance * Math.PI / 90.0);
        player.func_70082_c(rYaw += 90.0f, -(rPitch - player.field_70125_A));
        return false;
    }

    @Override
    public final boolean isLockedOn() {
        return this.currentTarget != null;
    }

    public final EntityLivingBase getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public void setCurrentTarget(EntityPlayer player, Entity target) {
        if (target instanceof EntityLivingBase) {
            this.currentTarget = (EntityLivingBase)target;
        } else {
            this.deactivate(player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void getNextTarget(EntityPlayer player) {
        EntityLivingBase nextTarget = null;
        double dTarget = 0.0;
        List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, this.getRange(), this.getRange());
        for (EntityLivingBase entity : list) {
            if (entity == player || entity == this.currentTarget || entity == this.prevTarget || !this.isTargetValid(player, entity)) continue;
            if (nextTarget == null) {
                dTarget = player.func_70068_e((Entity)entity);
                nextTarget = entity;
                continue;
            }
            double distance = player.func_70068_e((Entity)entity);
            if (!(distance < dTarget)) continue;
            nextTarget = entity;
            dTarget = distance;
        }
        if (nextTarget != null) {
            this.prevTarget = this.currentTarget;
            this.currentTarget = nextTarget;
        } else {
            nextTarget = this.currentTarget;
            this.currentTarget = this.prevTarget;
            this.prevTarget = nextTarget;
        }
        PacketDispatcher.sendToServer(new TargetIdPacket(this));
    }

    @SideOnly(value=Side.CLIENT)
    private boolean updateTargets(EntityPlayer player) {
        if (!this.isTargetValid(player, this.prevTarget) || !TargetUtils.isTargetInSight((EntityLivingBase)player, (Entity)this.prevTarget)) {
            this.prevTarget = null;
        }
        if (!this.isTargetValid(player, this.currentTarget)) {
            this.currentTarget = null;
            if (Config.enableAutoTarget) {
                this.getNextTarget(player);
            }
        }
        return this.isTargetValid(player, this.currentTarget);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isTargetValid(EntityPlayer player, EntityLivingBase target) {
        return target != null && !target.field_70128_L && target.func_110143_aJ() > 0.0f && player.func_70032_d((Entity)target) < (float)this.getRange() && !target.func_82150_aj() && (Config.canTargetPlayers || !(target instanceof EntityPlayer));
    }

    @Override
    public final Combo getCombo() {
        return this.combo;
    }

    @Override
    public final void setCombo(Combo combo) {
        this.combo = combo;
    }

    @Override
    public final boolean isComboInProgress() {
        return this.combo != null && !this.combo.isFinished();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onAttack(EntityPlayer player) {
        boolean attackHit;
        Entity mouseOver = TargetUtils.getMouseOverEntity();
        boolean bl = attackHit = this.isLockedOn() && mouseOver != null && TargetUtils.canReachTarget(player, mouseOver);
        if (!attackHit) {
            PlayerUtils.playRandomizedSound(player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            if (this.isComboInProgress()) {
                PacketDispatcher.sendToServer(new EndComboPacket(this));
            }
        }
        return attackHit;
    }

    @Override
    public void onHurtTarget(EntityPlayer player, LivingHurtEvent event) {
        float damage;
        boolean addHitFlag = event.source.func_76355_l().equals("indirectCombo");
        if (event.source.func_76352_a() && !addHitFlag) {
            return;
        }
        if (this.combo == null || this.combo.isFinished()) {
            this.combo = new Combo(player, this, this.getMaxComboSize(), this.getComboTimeLimit());
        }
        if ((damage = DirtyEntityAccessor.getModifiedDamage(event.entityLiving, event.source, event.ammount)) > 0.0f) {
            boolean flag = event.source.field_76373_n.equals("iArmorBreak");
            if (flag || event.source.field_76373_n.equals("indirectSword")) {
                this.combo.addDamageOnly(player, damage, flag);
            } else {
                this.combo.add(player, (Entity)event.entityLiving, damage);
            }
        }
        if (addHitFlag || event.source.field_76373_n.equals("player")) {
            String sound = PlayerUtils.isSword(player.func_70694_bm()) ? "zeldaswordskills:swordcut" : "zeldaswordskills:hurtflesh";
            WorldUtils.playSoundAtEntity((Entity)player, sound, 0.4f, 0.5f);
        }
    }

    @Override
    public void onPlayerHurt(EntityPlayer player, LivingHurtEvent event) {
        if (this.isComboInProgress() && DirtyEntityAccessor.getModifiedDamage((EntityLivingBase)player, event.source, event.ammount) > 0.5f * (float)this.level) {
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:grunt", 0.3f, 0.8f);
            this.combo.endCombo(player);
        }
    }
}

