/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.UUID;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.shield.IShield;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.item.IWeapon;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;

public class PlayerUtils {
    public static final UUID itemDamageUUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    public static boolean isBlocking(EntityPlayer player) {
        if (player.func_70632_aY()) {
            return true;
        }
        if (ZSSMain.isBG2Enabled) {
            return ((IBattlePlayer)player).isBattlemode() && ((IBattlePlayer)player).isBlockingWithShield();
        }
        return false;
    }

    public static boolean isShield(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (ZSSMain.isBG2Enabled && stack.func_77973_b() instanceof IShield) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemZeldaShield;
    }

    public static boolean isHoldingWeapon(EntityPlayer player) {
        AttributeModifier itemDamage = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111127_a(itemDamageUUID);
        return itemDamage != null && itemDamage.func_111164_d() > 0.0;
    }

    public static boolean isSword(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IWeapon) {
            return ((IWeapon)stack.func_77973_b()).isSword(stack);
        }
        return WeaponRegistry.INSTANCE.isSword(stack.func_77973_b());
    }

    public static boolean isWeapon(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IWeapon) {
            return ((IWeapon)stack.func_77973_b()).isWeapon(stack);
        }
        return PlayerUtils.isSword(stack) || WeaponRegistry.INSTANCE.isWeapon(stack.func_77973_b());
    }

    public static boolean isHoldingZeldaSword(EntityLivingBase entity) {
        return entity.func_70694_bm() != null && entity.func_70694_bm().func_77973_b() instanceof ItemZeldaSword;
    }

    public static boolean isHoldingMasterSword(EntityLivingBase entity) {
        return PlayerUtils.isHoldingZeldaSword(entity) && ((ItemZeldaSword)entity.func_70694_bm().func_77973_b()).isMasterSword();
    }

    public static boolean hasMasterSword(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemZeldaSword) || !((ItemZeldaSword)stack.func_77973_b()).isMasterSword()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItem(EntityPlayer player, Item item) {
        return PlayerUtils.hasItem(player, item, -1);
    }

    public static boolean hasItem(EntityPlayer player, ItemStack stack) {
        return PlayerUtils.hasItem(player, stack.func_77973_b(), stack.func_77960_j());
    }

    public static boolean hasItem(EntityPlayer player, Item item, int meta) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item || meta != -1 && stack.func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    public static float getHealthMissing(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 0.0f : player.func_110138_aP() - player.func_110143_aJ();
    }

    public static void addItemToInventory(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        } else if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71070_bA);
        }
    }

    public static boolean consumeHeldItem(EntityPlayer player, Item item, int amount) {
        return PlayerUtils.consumeHeldItem(player, item, -1, amount);
    }

    public static boolean consumeHeldItem(EntityPlayer player, Item item, int damage, int amount) {
        if (amount < 1) {
            return false;
        }
        ItemStack stack = player.func_70694_bm();
        if (stack == null || stack.func_77973_b() != item || stack.field_77994_a < amount) {
            return false;
        }
        if (damage > -1 && stack.func_77960_j() != damage) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        stack.field_77994_a -= amount;
        if (stack.field_77994_a < 1) {
            stack = null;
            player.func_70062_b(0, null);
        }
        return true;
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item item, int required) {
        return PlayerUtils.consumeInventoryItem(player, item, 0, required);
    }

    public static boolean consumeInventoryItem(EntityPlayer player, ItemStack stack, int required) {
        return PlayerUtils.consumeInventoryItem(player, stack.func_77973_b(), stack.func_77960_j(), required);
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item item, int meta, int required) {
        if (required < 1) {
            return false;
        }
        int consumed = required;
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && consumed > 0; ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            if (invStack == null || invStack.func_77973_b() != item || invStack.func_77960_j() != meta) continue;
            if (invStack.field_77994_a <= consumed) {
                consumed -= invStack.field_77994_a;
                if (player.field_71075_bZ.field_75098_d) continue;
                player.field_71071_by.func_70299_a(i, null);
                continue;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                invStack = invStack.func_77979_a(invStack.field_77994_a - consumed);
                player.field_71071_by.func_70299_a(i, invStack);
            }
            consumed = 0;
        }
        if (consumed > 0 && !player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_70441_a(new ItemStack(item, required - consumed, meta));
        }
        return consumed == 0;
    }

    public static void sendTranslatedChat(EntityPlayer player, String message, Object ... args) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, args));
    }

    public static void playSound(EntityPlayer player, String sound, float volume, float pitch) {
        if (player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new PlaySoundPacket(sound, volume, pitch, (Entity)player));
        } else if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new PlaySoundPacket(sound, volume, pitch), (EntityPlayerMP)player);
        }
    }

    public static void playRandomizedSound(EntityPlayer player, String sound, float f, float add) {
        float volume = player.field_70170_p.field_73012_v.nextFloat() * f + add;
        float pitch = 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * f + add);
        PlayerUtils.playSound(player, sound, volume, pitch);
    }
}

