/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityVillager;

public class VillagerDescription {
    public final String villagerName;
    public final Class<? extends Entity> villagerClass;
    public final int profession;
    public final boolean isChild;

    public VillagerDescription(String villagerName, Class<? extends Entity> villagerClass) {
        this(villagerName, villagerClass, -1, false);
    }

    public VillagerDescription(String villagerName, Class<? extends Entity> villagerClass, int profession) {
        this(villagerName, villagerClass, profession, false);
    }

    public VillagerDescription(String villagerName, Class<? extends Entity> villagerClass, int profession, boolean isChild) {
        this.villagerName = villagerName;
        this.villagerClass = villagerClass;
        this.profession = profession;
        this.isChild = isChild;
    }

    public boolean matches(Entity entity) {
        return this.matches(entity, true);
    }

    public boolean matches(Entity entity, boolean checkChild) {
        if (!this.matchClassAndName(entity) || !this.matchProfession(entity)) {
            return false;
        }
        return !checkChild || this.matchChild(entity);
    }

    public boolean matchClassAndName(Entity entity) {
        return entity.getClass() == this.villagerClass && entity instanceof EntityLiving && this.villagerName.equals(((EntityLiving)entity).func_94057_bL());
    }

    public boolean matchChild(Entity entity) {
        boolean isChildEntity = entity instanceof EntityAgeable && ((EntityAgeable)entity).func_70631_g_();
        return this.isChild && isChildEntity || !this.isChild && !isChildEntity;
    }

    public boolean matchProfession(Entity entity) {
        if (this.profession != -1) {
            return entity instanceof EntityVillager && ((EntityVillager)entity).func_70946_n() == this.profession;
        }
        return true;
    }
}

