/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.crisis.BossBattle;
import zeldaswordskills.world.gen.structure.RoomBoss;

public class DesertBattle
extends BossBattle {
    public DesertBattle(TileEntityDungeonCore core) {
        super(core);
    }

    @Override
    public void beginCrisis(World world) {
        super.beginCrisis(world);
        if (this.difficulty > 1) {
            this.scheduleUpdateTick(300 - world.field_73012_v.nextInt(100));
            this.handleDispensers(world, false);
            if (this.difficulty == 3) {
                this.setDungeonFloorTo(world, Blocks.field_150425_aM, 0, null);
            }
        }
    }

    @Override
    protected void endCrisis(World world) {
        this.setDungeonFloorTo(world, Blocks.field_150322_A, 0, Blocks.field_150425_aM);
        super.endCrisis(world);
    }

    @Override
    protected void onUpdateTick(World world) {
        this.handleDispensers(world, true);
        this.scheduleUpdateTick(300 - this.difficulty * 50 - world.field_73012_v.nextInt(100));
    }

    protected void handleDispensers(World world, boolean activate) {
        int j = this.box.field_78895_b + 2;
        for (int side = 0; side < 4; ++side) {
            int maxX;
            int minX = side == 3 ? this.box.field_78893_d : (side == 1 ? this.box.field_78897_a : this.box.field_78897_a + 3);
            int n = maxX = side == 0 || side == 2 ? this.box.field_78893_d - 2 : minX + 1;
            int minZ = side == 0 ? this.box.field_78892_f : (side == 2 ? this.box.field_78896_c : this.box.field_78896_c + 3);
            int maxZ = side == 3 || side == 1 ? this.box.field_78892_f - 2 : minZ + 1;
            for (int i = minX; i < maxX; ++i) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (activate) {
                        TileEntity te;
                        if (world.func_147439_a(i, j, k) != Blocks.field_150367_z || world.field_73012_v.nextInt(9 - 2 * this.difficulty) != 0 || !((te = world.func_147438_o(i, j, k)) instanceof IInventory)) continue;
                        WorldUtils.addItemToInventory(new ItemStack(Items.field_151032_g), (IInventory)te);
                        Blocks.field_150367_z.func_149674_a(world, i, j, k, world.field_73012_v);
                        continue;
                    }
                    world.func_147449_b(i, j, k, Blocks.field_150367_z);
                    world.func_72921_c(i, j, k, RoomBoss.facingToOrientation[(side + 2) % 4], 2);
                }
            }
        }
    }
}

