/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.crisis.BossBattle;

public class FireBattle
extends BossBattle {
    public FireBattle(TileEntityDungeonCore core) {
        super(core);
    }

    @Override
    public void beginCrisis(World world) {
        super.beginCrisis(world);
        this.scheduleUpdateTick(50);
    }

    @Override
    protected void endCrisis(World world) {
        StructureGenUtils.replaceMaterialWith(world, this.box.field_78897_a, this.box.field_78893_d, this.box.field_78895_b, this.box.field_78894_e, this.box.field_78896_c, this.box.field_78892_f, Material.field_151587_i, Blocks.field_150350_a, 0);
        super.endCrisis(world);
    }

    @Override
    protected void onUpdateTick(World world) {
        if (this.difficulty > 1) {
            if (this.eventTimer % (550 - this.difficulty * 50) == 0) {
                this.setRandomBlockTo(world, Blocks.field_150353_l, 0, "");
            }
            if (this.eventTimer % (800 - this.difficulty * 50) == 0) {
                boolean flag = this.difficulty == 3;
                this.spawnMobInCorner(world, (Entity)new EntitySkeleton(world), world.field_73012_v.nextInt(4), flag, flag);
            }
        }
        if (this.eventTimer % 500 == 0) {
            this.destroyRandomPillar(world, true);
        }
        this.scheduleUpdateTick(50);
    }
}

