/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import zeldaswordskills.ref.Config;
import zeldaswordskills.world.gen.structure.MapGenBossRoom;
import zeldaswordskills.world.gen.structure.MapGenBossRoomNether;

public class ZSSBossDungeonGen {
    private final MapGenBossRoom bossRoomGen = new MapGenBossRoom();
    private final MapGenBossRoom netherBossGen = new MapGenBossRoomNether();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPopulateChunk(PopulateChunkEvent.Populate event) {
        if (!event.world.field_73011_w.func_76569_d()) {
            return;
        }
        if (event.type != PopulateChunkEvent.Populate.EventType.LAKE && event.type != PopulateChunkEvent.Populate.EventType.LAVA) {
            return;
        }
        if (this.bossRoomGen.shouldDenyLakeAt(event.chunkX, event.chunkZ)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Decorate event) {
        if (event.world.field_73011_w.func_76569_d() && event.type == DecorateBiomeEvent.Decorate.EventType.LAKE && this.bossRoomGen.shouldDenyLakeAt(event.chunkX, event.chunkZ)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void postPopulate(PopulateChunkEvent.Post event) {
        if (!Config.isGenEnabledAt(event.chunkX, event.chunkZ)) {
            return;
        }
        switch (event.world.field_73011_w.field_76574_g) {
            case -1: {
                this.netherBossGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                break;
            }
            case 0: {
                this.bossRoomGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
            }
        }
    }
}

