/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.RoomGenData;

public abstract class ZSSMapGenBase {
    private RoomGenData roomData;
    protected Map<Long, Object> structureMap = new HashMap<Long, Object>();
    protected World worldObj;

    public abstract void generate(IChunkProvider var1, World var2, Random var3, int var4, int var5);

    public abstract String getTagName();

    protected abstract StructureBoundingBox getStructureBBAt(int var1, int var2, int var3);

    public abstract boolean areStructuresWithinRange(RoomBase var1, int var2);

    protected abstract void translateNbtIntoMap(NBTTagCompound var1);

    protected final void addRoomTag(NBTTagCompound compound, int chunkX, int chunkZ) {
        this.roomData.addRoomTag(compound, chunkX, chunkZ);
        this.roomData.func_76185_a();
    }

    protected final void loadOrCreateData(World world) {
        if (this.roomData == null) {
            this.roomData = (RoomGenData)world.perWorldStorage.func_75742_a(RoomGenData.class, this.getTagName());
            if (this.roomData == null) {
                this.roomData = new RoomGenData(this.getTagName());
                world.perWorldStorage.func_75745_a(this.getTagName(), (WorldSavedData)this.roomData);
            } else {
                NBTTagCompound compound = this.roomData.getRoomData();
                for (String s : compound.func_150296_c()) {
                    NBTBase nbtbase = compound.func_74781_a(s);
                    if (nbtbase.func_74732_a() != 10) continue;
                    this.translateNbtIntoMap((NBTTagCompound)nbtbase);
                }
            }
        }
    }

    public boolean hasStructureAt(int x, int y, int z) {
        this.loadOrCreateData(this.worldObj);
        return this.getStructureBBAt(x, y, z) != null;
    }
}

