/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.util.VersionNumber;

public class MixinAPVersion {
    private static final String MIN_VERSION = "0.8.3";
    private static final VersionNumber MIN_VERSION_NUMBER = VersionNumber.parse("0.8.3");
    private static final String BOOTSTRAP_ClASS = "org/spongepowered/asm/launch/MixinBootstrap.class";
    private static boolean checked = false;

    public static void check(ProcessingEnvironment env) {
        if (checked) {
            return;
        }
        checked = true;
        try (InputStream is = MixinAPVersion.findBootstrapClass();){
            if (is == null) {
                MixinAPVersion.printFailed(env);
                return;
            }
            ClassNode node = new ClassNode();
            new ClassReader(is).accept(node, 1);
            VersionNumber version = MixinAPVersion.getBootstrapVersion(node);
            if (version == null) {
                MixinAPVersion.printFailed(env);
                return;
            }
            if (version.compareTo(MIN_VERSION_NUMBER) < 0) {
                throw new IllegalStateException("MixinExtras requires the Mixin AP to be at least 0.8.3");
            }
        }
        catch (IOException ignored) {
            MixinAPVersion.printFailed(env);
        }
    }

    private static VersionNumber getBootstrapVersion(ClassNode bootstrapClass) {
        for (FieldNode field : bootstrapClass.fields) {
            if (!field.name.equals("VERSION")) continue;
            if (!(field.value instanceof String)) {
                return null;
            }
            return VersionNumber.parse((String)field.value);
        }
        return null;
    }

    private static void printFailed(ProcessingEnvironment env) {
        env.getMessager().printMessage(Diagnostic.Kind.WARNING, "[MixinExtras] Failed to determine Mixin version. Assuming >=0.8.3");
    }

    private static InputStream findBootstrapClass() throws IOException {
        Enumeration<URL> urls = MixinAPVersion.class.getClassLoader().getResources(BOOTSTRAP_ClASS);
        if (!urls.hasMoreElements()) {
            return null;
        }
        return urls.nextElement().openStream();
    }
}

