/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.ore;

import de.katzenpapst.amunra.block.ore.SubBlockOre;
import de.katzenpapst.amunra.item.ItemDamagePair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SubBlockOreMultidrop
extends SubBlockOre {
    protected List<DroppedItem> dropList = new ArrayList<DroppedItem>();

    public SubBlockOreMultidrop(String name, String texture) {
        super(name, texture);
    }

    public SubBlockOreMultidrop addDroppedItem(Item item, int metadata, int minDrop, int maxDrop, float probability) {
        this.dropList.add(new DroppedItem(item, metadata, minDrop, maxDrop, probability));
        return this;
    }

    public SubBlockOreMultidrop addDroppedItem(Item item, int metadata, int minDrop, int maxDrop) {
        this.dropList.add(new DroppedItem(item, metadata, minDrop, maxDrop, 1.0f));
        return this;
    }

    public SubBlockOreMultidrop addDroppedItem(ItemDamagePair idp, int minDrop, int maxDrop) {
        this.addDroppedItem(idp.getItem(), idp.getDamage(), minDrop, maxDrop);
        return this;
    }

    public SubBlockOreMultidrop addDroppedItem(ItemDamagePair idp, int minDrop, int maxDrop, float probability) {
        this.addDroppedItem(idp.getItem(), idp.getDamage(), minDrop, maxDrop, probability);
        return this;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (DroppedItem di : this.dropList) {
            float bonusDrop;
            int numDrops;
            float effectiveProb;
            if (di.probability < 1.0f && (effectiveProb = di.probability * (float)fortune) < 1.0f && this.rand.nextFloat() >= effectiveProb || (numDrops = (int)((bonusDrop = (float)Math.round((float)(fortune * this.rand.nextInt(di.maxDrop - di.minDrop + 1)) / 3.0f)) + (float)di.minDrop)) <= 0) continue;
            ret.add(new ItemStack(di.item, numDrops, di.metadata));
        }
        return ret;
    }

    @Override
    public boolean dropsSelf() {
        return this.dropList.size() == 0;
    }

    public class DroppedItem {
        public Item item;
        public int metadata;
        public int minDrop;
        public int maxDrop;
        public float probability = 1.0f;

        public DroppedItem(Item item, int meta, int minDrop, int maxDrop, float probability) {
            this.item = item;
            this.metadata = meta;
            this.minDrop = minDrop;
            this.maxDrop = maxDrop;
            this.probability = probability;
        }
    }
}

