/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.entity;

import de.katzenpapst.amunra.entity.EntityBaseLaserArrow;
import de.katzenpapst.amunra.mob.DamageSourceAR;
import de.katzenpapst.amunra.world.WorldHelper;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public class EntityLaserArrow
extends EntityBaseLaserArrow {
    protected float damage = 2.0f;
    protected boolean doesFireDamage = true;
    private static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("amunra", "textures/entity/laserarrow.png");

    public EntityLaserArrow(World world, EntityLivingBase shooter, Vector3 startVec, EntityLivingBase target) {
        super(world, shooter, startVec, target);
    }

    public EntityLaserArrow(World world) {
        super(world);
    }

    public EntityLaserArrow(World world, EntityLivingBase shooter, double startX, double startY, double startZ) {
        super(world, shooter, startX, startY, startZ);
    }

    public EntityLaserArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityLaserArrow(World world, EntityLivingBase shootingEntity, EntityLivingBase target, float randMod) {
        super(world, shootingEntity, target, randMod);
    }

    public EntityLaserArrow(World par1World, EntityLivingBase par2EntityLivingBase) {
        super(par1World, par2EntityLivingBase);
    }

    @Override
    protected float getSpeed() {
        return 3.0f;
    }

    @Override
    protected float getDamage() {
        return this.damage;
    }

    public void setDoesFireDamage(boolean set) {
        this.doesFireDamage = set;
    }

    public void setDamage(float newDmg) {
        this.damage = newDmg;
    }

    @Override
    protected boolean doesFireDamage() {
        return this.doesFireDamage;
    }

    @Override
    public ResourceLocation getTexture() {
        return ARROW_TEXTURE;
    }

    @Override
    protected int getEntityDependentDamage(Entity ent, int regularDamage) {
        if (ent instanceof EntityBlaze) {
            return Math.max(regularDamage / 2, 1);
        }
        return regularDamage;
    }

    @Override
    protected void onImpactBlock(World worldObj, int x, int y, int z) {
        Block b;
        int blockId;
        Block block = worldObj.func_147439_a(x, y, z);
        int meta = worldObj.func_72805_g(x, y, z);
        if (block == Blocks.field_150432_aD) {
            worldObj.func_147465_d(x, y, z, Blocks.field_150355_j, 0, 3);
            return;
        }
        if (block == Blocks.field_150433_aE || block == Blocks.field_150431_aC) {
            worldObj.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
            return;
        }
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block, 1, meta));
        if (smeltResult != null && (blockId = Item.func_150891_b((Item)smeltResult.func_77973_b())) > 0 && (b = Block.func_149729_e((int)blockId)) != Blocks.field_150350_a) {
            worldObj.func_147465_d(x, y, z, b, smeltResult.func_77960_j(), 3);
            return;
        }
        if (OxygenUtil.noAtmosphericCombustion((WorldProvider)worldObj.field_73011_w)) {
            if (OxygenUtil.isAABBInBreathableAirBlock((World)worldObj, (AxisAlignedBB)AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)))) {
                WorldHelper.setFireToBlock(worldObj, x, y, z, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        } else {
            WorldHelper.setFireToBlock(worldObj, x, y, z, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected void setFireToBlock(World worldObj, int x, int y, int z) {
        double deltaX = (double)x + 0.5 - this.field_70165_t;
        double deltaY = (double)y + 0.5 - this.field_70163_u;
        double deltaZ = (double)z + 0.5 - this.field_70161_v;
        double deltaXabs = Math.abs(deltaX);
        double deltaYabs = Math.abs(deltaY);
        double deltaZabs = Math.abs(deltaZ);
        if (deltaXabs > deltaYabs) {
            if (deltaXabs > deltaZabs) {
                if (deltaX < 0.0) {
                    worldObj.func_147449_b(x + 1, y, z, (Block)Blocks.field_150480_ab);
                } else {
                    worldObj.func_147449_b(x - 1, y, z, (Block)Blocks.field_150480_ab);
                }
            } else if (deltaZ < 0.0) {
                worldObj.func_147449_b(x, y, z + 1, (Block)Blocks.field_150480_ab);
            } else {
                worldObj.func_147449_b(x, y, z - 1, (Block)Blocks.field_150480_ab);
            }
        } else if (deltaYabs > deltaZabs) {
            if (deltaY < 0.0) {
                worldObj.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
            } else {
                worldObj.func_147449_b(x, y - 1, z, (Block)Blocks.field_150480_ab);
            }
        } else if (deltaZ < 0.0) {
            worldObj.func_147449_b(x, y, z + 1, (Block)Blocks.field_150480_ab);
        } else {
            worldObj.func_147449_b(x, y, z - 1, (Block)Blocks.field_150480_ab);
        }
    }

    @Override
    protected void onPassThrough(int x, int y, int z) {
        Block b = this.field_70170_p.func_147439_a(x, y, z);
        if (b == Blocks.field_150355_j) {
            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150350_a);
            this.func_85030_a("random.fizz", 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            this.field_70171_ac = false;
        }
    }

    @Override
    protected DamageSource getDamageSource() {
        if (this.shootingEntity == null) {
            return DamageSourceAR.causeLaserDamage("ar_heatray", this, this);
        }
        return DamageSourceAR.causeLaserDamage("ar_heatray", this, this.shootingEntity);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.damage = tagCompund.func_74760_g("damage");
        this.doesFireDamage = tagCompund.func_74767_n("fireDmg");
    }

    @Override
    protected void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74776_a("damage", this.damage);
        tagCompound.func_74757_a("fireDmg", this.doesFireDamage);
    }
}

