/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.item.ItemThermalSuit;
import de.katzenpapst.amunra.mob.DamageSourceAR;
import de.katzenpapst.amunra.mob.entity.IEntityNonOxygenBreather;
import micdoodle8.mods.galacticraft.api.event.ZeroGravityEvent;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.entity.living.LivingEvent;

public class EventHandlerAR {
    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.entityLiving;
        if (!(entityLiving instanceof IEntityNonOxygenBreather)) {
            return;
        }
        IEntityNonOxygenBreather nonOxygenBreather = (IEntityNonOxygenBreather)entityLiving;
        if (entityLiving.field_70173_aa % 100 == 0) {
            Planet body;
            boolean isInSealedArea = OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)entityLiving);
            WorldProvider worldProvider = entityLiving.field_70170_p.field_73011_w;
            if (worldProvider instanceof IGalacticraftWorldProvider) {
                IGalacticraftWorldProvider gcProvider = (IGalacticraftWorldProvider)worldProvider;
                body = gcProvider.getCelestialBody();
            } else {
                body = GalacticraftCore.planetOverworld;
            }
            if (!nonOxygenBreather.canBreatheIn(body.atmosphere, isInSealedArea)) {
                entityLiving.func_70097_a(DamageSourceAR.dsSuffocate, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onThermalArmorEvent(GCPlayerHandler.ThermalArmorEvent event) {
        if (event.armorStack != null && event.armorStack.func_77973_b() instanceof ItemThermalSuit) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void processGravityEvent(ZeroGravityEvent event) {
        Entity entity = event.entity;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (AmunRa.proxy.doCancelGravityEvent(player)) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGravityEvent(ZeroGravityEvent.InFreefall event) {
        this.processGravityEvent((ZeroGravityEvent)event);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGravityEvent(ZeroGravityEvent.Motion event) {
        this.processGravityEvent((ZeroGravityEvent)event);
    }
}

