/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.angermod.events;

import baubles.api.BaublesApi;
import com.github.namikon.angermod.AngerMod;
import com.github.namikon.angermod.config.AngerModConfig;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.auxiliary.PlayerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PlayerSpawnProtection {
    private AngerModConfig _mCfgManager = null;
    private Map<String, PlayerCoords> _mLastCoords = null;
    private Random _mRnd;
    private LogHelper _mLog = AngerMod.Logger;

    public PlayerSpawnProtection(AngerModConfig pConfigManager) {
        this._mCfgManager = pConfigManager;
        this._mLastCoords = new HashMap<String, PlayerCoords>();
        this._mRnd = new Random();
    }

    public void UpdateOrInitLastCoords(EntityPlayer tEP) {
        if (tEP == null) {
            return;
        }
        try {
            this._mLog.debug((Object)String.format("Updating player's information about his protection", new Object[0]));
            String UID = tEP.func_110124_au().toString();
            PlayerCoords pC = this._mLastCoords.get(UID);
            if (pC != null) {
                this._mLastCoords.remove(UID);
            }
            this._mLastCoords.put(UID, new PlayerCoords(tEP));
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.UpdateOrInitLastCoords.Error", (Object)"An error occoured while processing UpdateOrInitLastCoords. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.UpdateOrInitLastCoords.Stack", e);
        }
    }

    private void CheckMovement(EntityPlayer pPlayer) {
        if (pPlayer == null) {
            return;
        }
        try {
            PlayerCoords pC = this._mLastCoords.get(pPlayer.func_110124_au().toString());
            if (pC == null) {
                this.UpdateOrInitLastCoords(pPlayer);
            }
            if ((pC = this._mLastCoords.get(pPlayer.func_110124_au().toString())) == null) {
                this._mLog.error((Object)"Can't keep track of players movement, something went terrible wrong");
            } else if (pC.ProtectionVoided(pPlayer.field_70165_t, pPlayer.field_70163_u, pPlayer.field_70161_v)) {
                PlayerHelper.RemoveProtection((EntityPlayer)pPlayer);
            }
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.CheckMovement.Error", (Object)"An error occoured while processing CheckMovement. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.CheckMovement.Stack", e);
        }
    }

    public boolean HasProtection(EntityPlayer pEP) {
        if (pEP != null) {
            return pEP.field_71075_bZ.field_75102_a;
        }
        return false;
    }

    private void ProcessPlayerLoginOrRespawn(EntityPlayer pPlayer) {
        try {
            if (pPlayer.field_71075_bZ.field_75098_d) {
                return;
            }
            if (!pPlayer.field_71075_bZ.field_75102_a) {
                if (this.hasWhitelistedItems(pPlayer)) {
                    return;
                }
                PlayerHelper.GiveProtection((EntityPlayer)pPlayer);
                this.UpdateOrInitLastCoords(pPlayer);
            }
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.ProcessPlayerLoginOrRespawn.Error", (Object)"An error occoured while processing ProcessPlayerLoginOrRespawn. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.ProcessPlayerLoginOrRespawn.Stack", e);
        }
    }

    private ArrayList<String> loadItemUIDsFromPlayer(EntityPlayer tEP) {
        ArrayList<String> tReturnList = new ArrayList<String>();
        try {
            IInventory tPlayerBaubles = BaublesApi.getBaubles((EntityPlayer)tEP);
            if (tPlayerBaubles != null) {
                ItemStack[] isBaubles = new ItemStack[tPlayerBaubles.func_70302_i_()];
                for (int i = 0; i < tPlayerBaubles.func_70302_i_(); ++i) {
                    isBaubles[i] = tPlayerBaubles.func_70301_a(i);
                    if (isBaubles[i] == null || isBaubles[i].func_77973_b() == null) continue;
                    tReturnList.add(GameRegistry.findUniqueIdentifierFor((Item)isBaubles[i].func_77973_b()).toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tReturnList;
    }

    private boolean hasWhitelistedItems(EntityPlayer tEP) {
        boolean tFlag = false;
        try {
            ArrayList<String> tItems = this.loadItemUIDsFromPlayer(tEP);
            for (String tItem : this._mCfgManager.WhitelistedProtectionItems) {
                if (!tItems.contains(tItem)) continue;
                return true;
            }
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.hasWhitelistedItems.Error", (Object)"An error occoured while processing hasWhitelistedItems. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.hasWhitelistedItems.Stack", e);
        }
        return tFlag;
    }

    @SubscribeEvent
    public void onInteractEvent(PlayerInteractEvent pEvent) {
        try {
            if (pEvent.entityPlayer.field_70170_p.field_72995_K) {
                return;
            }
            if (pEvent.entityPlayer.field_71075_bZ.field_75098_d) {
                return;
            }
            if (pEvent.world.field_72995_K) {
                return;
            }
            EntityPlayer tEP = pEvent.entityPlayer;
            if (tEP == null) {
                AngerMod.Logger.error((Object)"EntityPlayer is null, but PlayerInteractEvent event was raised. This should not happen!");
                return;
            }
            if (!tEP.field_71075_bZ.field_75102_a) {
                return;
            }
            if (this.hasWhitelistedItems(tEP)) {
                return;
            }
            if (pEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || pEvent.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
                return;
            }
            PlayerHelper.RemoveProtection((EntityPlayer)tEP);
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.onInteractEvent.Error", (Object)"An error occoured while processing onInteractEvent. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.onInteractEvent.Stack", e);
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(EntityJoinWorldEvent event) {
        try {
            if (event.world.field_72995_K) {
                return;
            }
            if (!(event.entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer tEP = (EntityPlayer)event.entity;
            if (this.hasWhitelistedItems(tEP)) {
                return;
            }
            this.ProcessPlayerLoginOrRespawn(tEP);
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.onPlayerSpawn.Error", (Object)"An error occoured while processing onPlayerSpawn. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.onPlayerSpawn.Stack", e);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent pEvent) {
        if (pEvent.player.field_70170_p.field_72995_K) {
            return;
        }
        if (this._mRnd.nextInt(40) == 0 && this.HasProtection(pEvent.player) && !pEvent.player.field_71075_bZ.field_75098_d) {
            if (this.hasWhitelistedItems(pEvent.player)) {
                return;
            }
            this.CheckMovement(pEvent.player);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        try {
            if (event.entityPlayer.field_70170_p.field_72995_K) {
                return;
            }
            if (event.entityPlayer.field_71075_bZ.field_75098_d) {
                return;
            }
            if (!event.entityPlayer.field_71075_bZ.field_75102_a) {
                return;
            }
            if (this.hasWhitelistedItems(event.entityPlayer)) {
                return;
            }
            PlayerHelper.RemoveProtection((EntityPlayer)event.entityPlayer);
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.onAttackEntity.Error", (Object)"An error occoured while processing onAttackEntity. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.onAttackEntity.Stack", e);
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent pEvent) {
        try {
            if (pEvent.player.field_70170_p.field_72995_K) {
                return;
            }
            this.ProcessPlayerLoginOrRespawn(pEvent.player);
        }
        catch (Exception e) {
            AngerMod.Logger.warn("PlayerSpawnProtection.onDimensionChange.Error", (Object)"An error occoured while processing onDimensionChange. Please report");
            AngerMod.Logger.DumpStack("PlayerSpawnProtection.onDimensionChange.Stack", e);
        }
    }

    private class PlayerCoords {
        private LogHelper _mLog = AngerMod.Logger;
        public double _mX;
        public double _mY;
        public double _mZ;
        public long _mProtectionTime;

        public PlayerCoords(EntityPlayer pEp) {
            this._mX = pEp.field_70165_t;
            this._mY = pEp.field_70163_u;
            this._mZ = pEp.field_70161_v;
            this._mProtectionTime = System.currentTimeMillis();
        }

        public boolean ProtectionVoided(double posX, double posY, double posZ) {
            try {
                int tTolerance = AngerMod._cfgManager.SpawnProtectionMoveTolerance;
                int tMaxtimeout = AngerMod._cfgManager.SpawnProtectionTimeout * 1000;
                boolean offsetX = this.OffsetMovement(this._mX, posX, tTolerance);
                boolean offsetY = this.OffsetMovement(this._mY, posY, 5);
                boolean offsetZ = this.OffsetMovement(this._mZ, posZ, tTolerance);
                long tCurrTime = System.currentTimeMillis();
                if (offsetX || offsetY || offsetZ) {
                    this._mLog.debug((Object)String.format("Protection voided because of player movement X[%s] Y[%s] Z[%s]", offsetX, offsetY, offsetZ));
                    return true;
                }
                if (this._mProtectionTime + (long)tMaxtimeout < tCurrTime) {
                    this._mLog.debug((Object)"Protection voided because of timeout");
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }

        private boolean OffsetMovement(double pBase, double posX, int pRange) {
            double tUpper = pBase + (double)pRange;
            double tLower = pBase - (double)pRange;
            return posX > tUpper || posX < tLower;
        }
    }
}

