/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.mixins.minecraft;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockMushroom;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import squeek.applecore.api.AppleCoreAPI;

@Mixin(value={BlockMushroom.class})
public class BlockMushroomMixin
extends BlockBush {
    @Unique
    private Event.Result allowGrowthResult;
    @Unique
    private boolean executedCondition = false;

    @Inject(method={"updateTick"}, at={@At(value="HEAD")})
    private void beforeUpdateTick(World world, int blockX, int blockY, int blockZ, Random random, CallbackInfo callbackInfo) {
        this.allowGrowthResult = AppleCoreAPI.dispatcher.validatePlantGrowth((Block)this, world, blockX, blockY, blockZ, random);
    }

    @Redirect(method={"updateTick"}, at=@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I", ordinal=0))
    private int onUpdateTick(Random random, int const25) {
        if (this.allowGrowthResult == Event.Result.ALLOW) {
            this.executedCondition = true;
            return 0;
        }
        if (this.allowGrowthResult == Event.Result.DEFAULT) {
            int i = random.nextInt(25);
            this.executedCondition = i == 0;
            return i;
        }
        this.executedCondition = false;
        return -1;
    }

    @Inject(method={"updateTick"}, at={@At(value="RETURN")})
    private void afterUpdateTick(World world, int blockX, int blockY, int blockZ, Random random, CallbackInfo callbackInfo) {
        if (this.executedCondition) {
            AppleCoreAPI.dispatcher.announcePlantGrowthWithoutMetadataChange((Block)this, world, blockX, blockY, blockZ);
            this.executedCondition = false;
        }
    }
}

